/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.events;

import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ObjectEvent
extends BufferEvent {
    private IPumpable item = null;

    public ObjectEvent() {
    }

    public ObjectEvent(IPumpable item) {
        this.item = item;
    }

    public void setItem(IPumpable item) {
        this.item = item;
    }

    public IPumpable getItem() {
        return this.item;
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            if (this.item == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.item.getClass().getName());
                this.item.deflate(out);
            }
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not deflate event", e);
        }
    }

    @Override
    public void extendInflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            if (in.readBoolean()) {
                String objType = in.readUTF();
                this.item = (IPumpable)Class.forName(objType).newInstance();
                this.item.inflate(in);
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("Could not inflate event", e);
        }
    }
}

