/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp.mirror;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPWriterMirror
extends Thread
implements IMirror {
    private static Logger logger = Logger.getLogger(TCPWriterMirror.class.getName());
    private Socket socket = null;
    private String key = null;
    private IMirror.MirroringState state = IMirror.MirroringState.Open;
    private DataInputStream in;
    private DataOutputStream out;
    private IBuffer buffer = null;
    private int readerNeeded = 0;
    private boolean doDispose = false;
    private PartialRequestEntry[] partials = null;

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    public void handle() throws GRS2ProxyMirrorInvalidOperationException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Invalid mirroring state");
        }
        if (this.socket == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No socket defined");
        }
        if (this.key == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No key defined");
        }
        if (this.getState() != Thread.State.NEW) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring already in progress");
        }
        this.setDaemon(true);
        this.setName("writer mirror (" + this.key + ")");
        this.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean purge) {
        if (this.state == IMirror.MirroringState.Purged) {
            return;
        }
        this.state = purge ? IMirror.MirroringState.Purged : IMirror.MirroringState.Close;
        if (purge) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.buffer != null) {
                    this.buffer.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean pollPartial(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorInvalidOperationException {
        throw new GRS2ProxyMirrorInvalidOperationException("Operation not supported in writer mirror");
    }

    @Override
    public long requestPartial(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorInvalidOperationException {
        throw new GRS2ProxyMirrorInvalidOperationException("Operation not supported in writer mirror");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.buffer = GRSRegistry.Registry.getBuffer(this.key);
            if (this.buffer == null && (this.state == IMirror.MirroringState.Close || this.state == IMirror.MirroringState.Purged)) {
                throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is already closed. Cannot initialize the protocol");
            }
            if (this.buffer == null && this.state == IMirror.MirroringState.Open) {
                throw new GRS2ProxyMirrorInvalidOperationException("No registry entry found for key " + this.key);
            }
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            try {
                this.flushBufferConfig();
            }
            catch (Exception ex) {
                throw new GRS2ProxyMirrorProtocolErrorException("Could not complete buffer configuration mirroring", ex);
            }
            while (this.state != IMirror.MirroringState.Purged) {
                boolean isClosed;
                try {
                    this.parseRequest();
                }
                catch (Exception ex) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Could not parse input request", ex);
                }
                if (this.doDispose) {
                    logger.log(Level.FINEST, "Writer mirror received dispose request");
                }
                try {
                    this.retrieveEvents();
                }
                catch (Exception ex) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Could not parse input request", ex);
                }
                if (this.state == IMirror.MirroringState.Purged) break;
                if (this.doDispose) {
                    break;
                }
                if (this.state == IMirror.MirroringState.Close) {
                    logger.log(Level.FINEST, "Disposing writer mirror");
                    this.out.writeBoolean(false);
                    this.out.writeBoolean(false);
                    this.out.writeBoolean(false);
                    this.out.writeShort(2);
                    this.out.flush();
                    break;
                }
                this.flushPartialRequests();
                this.flushForwardBuffer();
                this.flushEvents();
                boolean bl = isClosed = this.buffer.getStatus() == IBuffer.Status.Close && this.buffer.availableRecords() == 0;
                if (isClosed) {
                    this.out.writeShort(1);
                } else {
                    this.out.writeShort(0);
                }
                this.out.flush();
            }
        }
        catch (Exception ex) {
            if (this.state == IMirror.MirroringState.Open && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Unrecoverable error during mirroring process", ex);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unrecoverable error during mirroring process", ex);
            }
        }
        finally {
            this.dispose(true);
        }
    }

    private void flushBufferConfig() throws IOException, GRS2Exception {
        this.out.writeUTF(this.buffer.getClass().getName());
        this.out.writeInt(this.buffer.getCapacity());
        this.out.writeInt(this.buffer.getConcurrentPartialCapacity());
        this.out.writeLong(this.buffer.getInactivityTimeout());
        this.out.writeUTF(this.buffer.getInactivityTimeUnit().toString());
        this.out.writeUTF(this.buffer.getTransportDirective().toString());
        this.out.writeInt(this.buffer.getRecordDefinitions().length);
        for (RecordDefinition def : this.buffer.getRecordDefinitions()) {
            this.out.writeUTF(def.getClass().getName());
            def.deflate(this.out);
        }
        this.out.flush();
    }

    private void parseRequest() throws IOException {
        this.doDispose = this.in.readBoolean();
        this.readerNeeded = this.in.readInt();
        boolean simulateActivity = this.in.readBoolean();
        if (simulateActivity) {
            this.buffer.markSimulateActivity();
        }
        int len = this.in.readInt();
        this.partials = new PartialRequestEntry[len];
        for (int i = 0; i < len; ++i) {
            long recordIndex = this.in.readLong();
            int fieldIndex = this.in.readInt();
            IBuffer.TransportOverride override = IBuffer.TransportOverride.valueOf(this.in.readUTF());
            this.partials[i] = new PartialRequestEntry(recordIndex, fieldIndex, override, null);
        }
    }

    private void retrieveEvents() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2RecordSerializationException, GRS2BufferException {
        while (this.in.readBoolean()) {
            String eventType = this.in.readUTF();
            BufferEvent ev = (BufferEvent)Class.forName(eventType).newInstance();
            ev.inflate(this.in);
            this.buffer.emit(ev);
        }
    }

    private void flushEvents() throws IOException, GRS2BufferException, GRS2RecordSerializationException {
        BufferEvent event;
        while ((event = this.buffer.receive(BufferEvent.EventSource.Writer)) != null) {
            this.out.writeBoolean(true);
            this.out.writeUTF(event.getClass().getName());
            event.deflate(this.out);
        }
        this.out.writeBoolean(false);
        this.out.flush();
    }

    private void flushPartialRequests() throws GRS2Exception, IOException {
        int num = 0;
        for (PartialRequestEntry entry : this.partials) {
            Record rec = this.buffer.locate(entry.getRecordIndex());
            if (rec == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid record index provided");
            }
            Field[] fields = rec.getFields();
            if (fields == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("No fields to marshal");
            }
            if (entry.getFieldIndex() < 0 || entry.getFieldIndex() >= fields.length) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid field index provided");
            }
            Field f = fields[entry.getFieldIndex()];
            this.out.writeBoolean(true);
            this.out.writeLong(entry.getRecordIndex());
            this.out.writeInt(entry.getFieldIndex());
            this.out.writeUTF(entry.getOverride().toString());
            f.extendSend(this.out, entry.getOverride());
            ++num;
        }
        this.out.writeBoolean(false);
        this.out.flush();
    }

    private void flushForwardBuffer() throws GRS2Exception, IOException {
        long available = this.buffer.availableRecords();
        long mirrorBuffer = this.buffer.getMirrorBuffer();
        long toMirror = this.readerNeeded;
        if (toMirror > available) {
            toMirror = available;
        }
        if (toMirror > mirrorBuffer) {
            toMirror = mirrorBuffer;
        }
        int i = 0;
        while ((long)i < toMirror) {
            Record rec = this.buffer.get();
            if (rec == null) {
                if (!logger.isLoggable(Level.WARNING)) break;
                logger.log(Level.WARNING, "Record not available although declared as available");
                break;
            }
            this.out.writeBoolean(true);
            this.out.writeUTF(rec.getClass().getName());
            rec.send(this.out);
            ++i;
        }
        this.out.writeBoolean(false);
        this.out.flush();
    }
}

