/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.registry;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LifecycleManager
extends Thread {
    private static final Logger logger = Logger.getLogger(LifecycleManager.class.getName());
    public static final long DefaultCheckPeriod = 120000L;

    @Override
    public void run() {
        try {
            ArrayList<IBuffer> buffersToDispose = new ArrayList<IBuffer>();
            ArrayList<IBufferStore> storesToDispose = new ArrayList<IBufferStore>();
            while (true) {
                long recheck;
                block23: {
                    recheck = 120000L;
                    try {
                        long newRecheck;
                        long thresholdInactivity;
                        long currentInactivity;
                        TimeUnit unit;
                        long timeout;
                        long lastActivity;
                        buffersToDispose.clear();
                        for (IBuffer iBuffer : GRSRegistry.Registry.getBufferEntries()) {
                            try {
                                if (iBuffer == null) continue;
                                long current = System.currentTimeMillis();
                                lastActivity = iBuffer.getLastActivityTime();
                                timeout = iBuffer.getInactivityTimeout();
                                unit = iBuffer.getInactivityTimeUnit();
                                currentInactivity = current - lastActivity;
                                thresholdInactivity = unit.toMillis(timeout);
                                newRecheck = thresholdInactivity - currentInactivity;
                                if (currentInactivity >= thresholdInactivity) {
                                    buffersToDispose.add(iBuffer);
                                    continue;
                                }
                                if (newRecheck >= recheck || newRecheck <= 0L) continue;
                                recheck = newRecheck;
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.log(Level.FINE, "Could not check lifecycle properties for buffer", ex);
                            }
                        }
                        storesToDispose.clear();
                        for (IBufferStore iBufferStore : GRSRegistry.Registry.getStoreEntries()) {
                            try {
                                if (iBufferStore == null) continue;
                                long current = System.currentTimeMillis();
                                lastActivity = iBufferStore.getLastActivityTime();
                                timeout = iBufferStore.getInactivityTimeout();
                                unit = iBufferStore.getInactivityTimeUnit();
                                currentInactivity = current - lastActivity;
                                thresholdInactivity = unit.toMillis(timeout);
                                newRecheck = thresholdInactivity - currentInactivity;
                                if (currentInactivity >= thresholdInactivity) {
                                    storesToDispose.add(iBufferStore);
                                    continue;
                                }
                                if (newRecheck >= recheck || newRecheck <= 0L) continue;
                                recheck = newRecheck;
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.log(Level.FINE, "Could not check lifecycle properties for buffer", ex);
                            }
                        }
                        for (IBuffer iBuffer : buffersToDispose) {
                            try {
                                if (iBuffer == null) continue;
                                iBuffer.dispose();
                                GRSRegistry.Registry.remove(iBuffer.getKey());
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.log(Level.FINE, "Could not dispose buffer", ex);
                            }
                        }
                        for (IBufferStore iBufferStore : storesToDispose) {
                            try {
                                if (iBufferStore == null) continue;
                                iBufferStore.dispose();
                                GRSRegistry.Registry.remove(iBufferStore.getKey());
                            }
                            catch (Exception ex) {
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.log(Level.FINE, "Could not dispose buffer", ex);
                            }
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "disposed " + buffersToDispose.size() + " buffers and " + storesToDispose.size() + " stores");
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(Level.WARNING)) break block23;
                        logger.log(Level.WARNING, "Could not complete lifecycle check cycle", ex);
                    }
                }
                try {
                    Thread.sleep(recheck);
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.SEVERE, "Could not initialize lifecycle manager", ex);
            }
            return;
        }
    }
}

