/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.test;

import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.UUID;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimplePumpable
implements IPumpable {
    private static int counterAll = 0;
    public String payload = null;
    public int counter = 0;

    public void populate() {
        this.payload = UUID.randomUUID().toString();
        this.counter = counterAll++;
    }

    public String toString() {
        return this.payload + " (" + this.counter + ")";
    }

    @Override
    public void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.payload);
            out.writeInt(this.counter);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("oups", ex);
        }
    }

    @Override
    public void inflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.payload = in.readUTF();
            this.counter = in.readInt();
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("oups", ex);
        }
    }

    @Override
    public void inflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        this.inflate(in);
    }

    @Override
    public Element toXML(Document doc) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException {
        Element elm = null;
        if (this.payload != null) {
            elm = doc.createElement("payload");
            elm.setTextContent(this.payload.toString());
        }
        return elm;
    }

    @Override
    public void fromXML(Element element) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException {
        String payload;
        this.payload = payload = element.getElementsByTagName("payload").item(0).getTextContent();
    }
}

