/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy.CollocationRegistry;
import gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy.NodeAssignmentPolicy;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import java.util.List;
import java.util.logging.Logger;

public class SingleRemoteNodePolicy
implements NodeAssignmentPolicy {
    private static Logger logger = Logger.getLogger(SingleRemoteNodePolicy.class.getName());
    private NodeSelector selector = null;
    private CollocationRegistry registry = new CollocationRegistry();

    public SingleRemoteNodePolicy(NodeSelector selector) {
        this.selector = selector;
    }

    public SingleRemoteNodePolicy(NodeSelector selector, float threshold) {
        this.selector = selector;
    }

    @Override
    public NodeAssignmentPolicy.Type getType() {
        return NodeAssignmentPolicy.Type.SingleNode;
    }

    @Override
    public void setPenalty(float collocationPenalty) throws Exception {
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) throws Exception {
        for (HostingNode hn : candidates) {
            if (!this.registry.isSelected(hn)) continue;
            return hn;
        }
        List<HostingNodeInfo> hns = this.selector.assessNodes(candidates);
        for (HostingNodeInfo hn : hns) {
            if (hn.node.isLocal()) continue;
            this.selector.markSelected(hn.node);
            this.registry.markSelected(hn.node);
            return hn.node;
        }
        logger.warning("None of the nodes found are marked as remote or only the local node was found. Candidate size=" + candidates.size() + ". Relying on node selector.");
        return this.selector.selectNode(candidates);
    }

    @Override
    public void reset() {
        this.registry = new CollocationRegistry();
    }
}

