/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine;

import gr.uoa.di.madgik.execution.engine.EngineStatus;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.engine.PlanExecutor;
import gr.uoa.di.madgik.execution.engine.monitoring.ExecutionMonitor;
import gr.uoa.di.madgik.execution.engine.queue.PlanQueue;
import gr.uoa.di.madgik.execution.engine.queue.PlanQueueElement;
import gr.uoa.di.madgik.execution.exception.ExecutionEngineFullException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import java.util.UUID;

public class QueueableExecutionEngine {
    private String RESOURCEID;
    private static ExecutionMonitor executionMonitor;
    private static PlanQueue planQueue;
    private static boolean terminate;
    private static Thread consumer;
    private static final Object lock;
    private static boolean initialized;

    private static synchronized boolean getTerminate() {
        return terminate;
    }

    private static synchronized void setTerminate(boolean term) {
        terminate = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Init(ExecutionEngineConfig Config) {
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
        }
        ExecutionEngine.Init((ExecutionEngineConfig)Config);
        executionMonitor = new ExecutionMonitor(UUID.randomUUID().toString());
        planQueue = new PlanQueue(executionMonitor);
        executionMonitor.init();
        consumer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ExecutionHandle handler = null;
                try {
                    while (!QueueableExecutionEngine.getTerminate()) {
                        PlanQueueElement ele = null;
                        try {
                            ele = planQueue.takeFirst();
                            if (ele == null) {
                                if (planQueue.isEmpty()) continue;
                                Object object = executionMonitor.getLoadUpdatesAvailable();
                                synchronized (object) {
                                    executionMonitor.getLoadUpdatesAvailable().wait(60000L);
                                    continue;
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        handler = ele.getHandle();
                        ExecutionEngine.Execute((ExecutionHandle)handler);
                    }
                    return;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        consumer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionHandle Submit(ExecutionPlan plan) throws ExecutionEngineFullException, ExecutionValidationException, ExecutionInternalErrorException {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                return null;
            }
        }
        return ExecutionEngine.Submit((ExecutionPlan)plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionHandle Submit(ExecutionPlan plan, Float util, Integer passedBy) throws ExecutionEngineFullException, ExecutionValidationException, ExecutionInternalErrorException {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                return null;
            }
        }
        plan.Config.Utilization = util == null ? plan.Config.Utilization : util.floatValue();
        plan.Config.PassedBy = passedBy == null ? plan.Config.PassedBy : passedBy;
        return ExecutionEngine.Submit((ExecutionPlan)plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Execute(ExecutionHandle Handle) throws ExecutionInternalErrorException {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                return;
            }
        }
        PlanQueueElement planElement = new PlanQueueElement(Handle.GetPlan().Config.Utilization, Handle.GetPlan().Config.PassedBy, Handle);
        try {
            if (!ExecutionEngine.isInitialized()) {
                throw new ExecutionInternalErrorException("Execution engine has not been initialized");
            }
            planQueue.putLast(planElement);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new ExecutionInternalErrorException("Interrupted exception occured", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineStatus GetEngineStatus() throws ExecutionInternalErrorException {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                return null;
            }
        }
        return ExecutionEngine.GetEngineStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void RemoveExecutor(PlanExecutor executor) {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                return;
            }
        }
        ExecutionEngine.RemoveExecutor((PlanExecutor)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Destroy() {
        Object object = lock;
        synchronized (object) {
            if (!initialized) {
                return;
            }
        }
        QueueableExecutionEngine.setTerminate(true);
        executionMonitor.terminate();
        consumer.interrupt();
    }

    static {
        terminate = false;
        lock = new String("Initialization lock");
        initialized = false;
    }
}

