/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine.queue;

import gr.uoa.di.madgik.execution.engine.monitoring.ExecutionMonitor;
import gr.uoa.di.madgik.execution.engine.queue.PlanQueueElement;
import java.util.LinkedList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanQueue {
    private Logger log = LoggerFactory.getLogger((String)PlanQueue.class.getName());
    private BlockingDeque<PlanQueueElement> queue = new LinkedBlockingDeque<PlanQueueElement>();
    private ExecutionMonitor monitor;

    public PlanQueue(ExecutionMonitor monitor) {
        this.monitor = monitor;
    }

    public void putLast(PlanQueueElement e) throws InterruptedException {
        this.queue.putLast(e);
    }

    public PlanQueueElement takeFirst() throws InterruptedException {
        PlanQueueElement elem;
        LinkedList<PlanQueueElement> tempQ = new LinkedList<PlanQueueElement>();
        LinkedList<PlanQueueElement> toGetDecreased = new LinkedList<PlanQueueElement>();
        while (!this.monitor.evaluate((elem = this.queue.takeFirst()).getHandle(), elem.getUtil())) {
            tempQ.addFirst(elem);
            if (!elem.canGetDecreaseTtl()) {
                this.log.debug("Found plan element that cant be decreased. Returing null");
                elem = null;
                break;
            }
            toGetDecreased.add(elem);
            this.log.debug("Passing by an element from queue with remaining " + elem.getTtl());
            if (!this.queue.isEmpty()) continue;
            elem = null;
            break;
        }
        if (elem == null) {
            toGetDecreased.clear();
        }
        while (!toGetDecreased.isEmpty()) {
            ((PlanQueueElement)toGetDecreased.remove()).decreaseTtl();
        }
        while (!tempQ.isEmpty()) {
            this.queue.addFirst((PlanQueueElement)tempQ.removeFirst());
        }
        return elem;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

