/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import gr.uoa.di.madgik.rr.plugins.PluginManager;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

public class RRContext {
    private static Logger logger = Logger.getLogger(RRContext.class.getName());
    private PersistenceManagerFactory pmfLocal;
    private String connectionURL = null;
    private PersistenceManagerFactory pmfRemoteRead;
    private PersistenceManagerFactory pmfRemoteWrite;
    private PersistenceManagerFactory pmfBufferLocal;
    private Set<String> readOnlyTargets = new HashSet<String>();
    private Set<String> editableTargets = new HashSet<String>();
    private Set<String> updateTargets = new HashSet<String>();
    private Set<String> inMemoryTargets = new HashSet<String>();
    private Set<String> nonUpdateVOScopes = new HashSet<String>();
    private String repositoryProvider = null;
    private Properties repositoryProviderConfig = null;
    private Long bridgingPeriod = null;
    private Long shortBridgingPeriod = null;
    private Boolean clearDataStoreOnStartup = null;
    private String localNodeHostname = null;
    private String localNodePort = null;
    private ReadWriteLock lock = null;

    protected RRContext() throws ResourceRegistryException {
        try {
            String targetsModelConfig;
            String remoteWriteDatastoreConfig;
            this.lock = new ReentrantReadWriteLock(true);
            Properties propsRegistry = new Properties();
            propsRegistry.load(Thread.currentThread().getContextClassLoader().getResource("resourceregistry.properties").openStream());
            try {
                Properties propsVOScopesRegistry = new Properties();
                logger.log(Level.INFO, "nonUpdateVOScopes reading");
                propsVOScopesRegistry.load(Thread.currentThread().getContextClassLoader().getResource("nonupdatescopes.properties").openStream());
                this.nonUpdateVOScopes = this.parseNonUpdateVOScopes(propsVOScopesRegistry);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "nonupdatescopes.properties could not be read");
            }
            logger.log(Level.INFO, "nonUpdateVOScopes : " + this.nonUpdateVOScopes);
            String localDatastoreConfig = this.parseLocalDatastoreConfig(propsRegistry);
            logger.log(Level.INFO, "localDatastoreConfig : " + localDatastoreConfig);
            if (localDatastoreConfig == null) {
                throw new ResourceRegistryException("Could not find configuration for local data store");
            }
            Properties propsLocal = new Properties();
            URL propsLocalResource = Thread.currentThread().getContextClassLoader().getResource(localDatastoreConfig);
            if (propsLocalResource == null) {
                throw new ResourceRegistryException("Could not find specified configuration for local data store");
            }
            propsLocal.load(propsLocalResource.openStream());
            this.pmfLocal = JDOHelper.getPersistenceManagerFactory((Map)propsLocal);
            this.connectionURL = propsLocal.getProperty("datanucleus.ConnectionURL") + ";user=" + propsLocal.getProperty("javax.jdo.option.ConnectionUserName") + ";password=" + propsLocal.getProperty("javax.jdo.option.ConnectionPassword");
            logger.log(Level.INFO, "connectionURL : " + this.connectionURL);
            String localBufferDatastoreConfig = this.parseLocalBufferDatastoreConfig(propsRegistry);
            if (localBufferDatastoreConfig == null) {
                throw new ResourceRegistryException("Could not find configuration for local buffer data store");
            }
            Properties propsBufferLocal = new Properties();
            URL propsLocalBufferConfigResource = Thread.currentThread().getContextClassLoader().getResource(localBufferDatastoreConfig);
            if (propsLocalBufferConfigResource == null) {
                throw new ResourceRegistryException("Could not find specified configuration for local buffer data store");
            }
            propsBufferLocal.load(propsLocalBufferConfigResource.openStream());
            this.pmfBufferLocal = JDOHelper.getPersistenceManagerFactory((Map)propsBufferLocal);
            String remoteReadDatastoreConfig = this.parseRemoteReadDatastoreConfig(propsRegistry);
            if (remoteReadDatastoreConfig != null) {
                Properties propsRemote = new Properties();
                URL propsRemoteReadDatastoreConfigResource = Thread.currentThread().getContextClassLoader().getResource(remoteReadDatastoreConfig);
                if (propsRemoteReadDatastoreConfigResource == null) {
                    throw new ResourceRegistryException("Could not find specified configuration for remote data store - read mode");
                }
                propsRemote.load(propsRemoteReadDatastoreConfigResource.openStream());
                this.pmfRemoteRead = JDOHelper.getPersistenceManagerFactory((Map)propsRemote);
            }
            if ((remoteWriteDatastoreConfig = this.parseRemoteWriteDatastoreConfig(propsRegistry)) != null) {
                if (remoteReadDatastoreConfig.equals(remoteWriteDatastoreConfig)) {
                    this.pmfRemoteWrite = this.pmfRemoteRead;
                } else {
                    Properties propsRemote = new Properties();
                    URL propsRemoteWriteDatastoreConfig = Thread.currentThread().getContextClassLoader().getResource(remoteWriteDatastoreConfig);
                    if (propsRemoteWriteDatastoreConfig == null) {
                        throw new ResourceRegistryException("Could not find specified configutation for remote data store - write mode");
                    }
                    propsRemote.load(propsRemoteWriteDatastoreConfig.openStream());
                    this.pmfRemoteWrite = JDOHelper.getPersistenceManagerFactory((Map)propsRemote);
                }
            }
            if ((targetsModelConfig = this.parseTargetsModelConfig(propsRegistry)) == null) {
                throw new ResourceRegistryException("Could not find model targets configuration");
            }
            Properties propsTargets = new Properties();
            URL propsTargetsConfigResource = Thread.currentThread().getContextClassLoader().getResource(targetsModelConfig);
            if (propsTargetsConfigResource == null) {
                throw new ResourceRegistryException("Could not find specified model targets configuration");
            }
            propsTargets.load(propsTargetsConfigResource.openStream());
            this.bridgingPeriod = this.parseBridgingPeriod(propsRegistry);
            this.shortBridgingPeriod = this.parseShortBridgingPeriod(propsRegistry);
            this.clearDataStoreOnStartup = this.parseClearDataStoreOnStartup(propsRegistry);
            this.repositoryProvider = this.parseRepositoryProvider(propsRegistry);
            this.repositoryProviderConfig = this.parseRepositoryProviderConfig(propsRegistry);
            this.readOnlyTargets = this.parseReadOnlyTargets(propsTargets);
            this.editableTargets = this.parseEditableTargets(propsTargets);
            this.updateTargets = this.parseUpdateTargets(propsTargets);
            this.inMemoryTargets = this.parseInMemoryTargets(propsTargets);
            logger.log(Level.INFO, "bridgingPeriod : " + this.bridgingPeriod);
            logger.log(Level.INFO, "shortBridgingPeriod : " + this.shortBridgingPeriod);
            logger.log(Level.INFO, "clearDataStoreOnStartup : " + this.clearDataStoreOnStartup);
            logger.log(Level.INFO, "repositoryProvider : " + this.repositoryProvider);
            logger.log(Level.INFO, "repositoryProviderConfig : " + this.repositoryProviderConfig);
            logger.log(Level.INFO, "readOnlyTargets : " + this.readOnlyTargets);
            logger.log(Level.INFO, "editableTargets : " + this.editableTargets);
            logger.log(Level.INFO, "updateTargets : " + this.updateTargets);
            logger.log(Level.INFO, "inMemoryTargets : " + this.inMemoryTargets);
            URL loggingConfigResource = Thread.currentThread().getContextClassLoader().getResource("logging.rr.properties");
            if (loggingConfigResource != null) {
                InputStream is = loggingConfigResource.openStream();
                if (is == null) {
                    throw new ResourceRegistryException("Could not find logging config location logging.rr.properties");
                }
                LogManager.getLogManager().readConfiguration(is);
                is.close();
            }
            this.registerPlugins(propsRegistry);
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("Could not load persistency factories", ex);
        }
    }

    private void registerPlugins(Properties props) throws ResourceRegistryException {
        try {
            int maxOrder = -1;
            int count = Integer.parseInt(props.getProperty("pluginCount", "0"));
            for (int i = 0; i < count; ++i) {
                int pluginOrder;
                String pluginClass = props.getProperty("plugin." + i + ".class");
                if (pluginClass == null) {
                    throw new ResourceRegistryException("Missing class for plugin #" + i);
                }
                String propPluginOrder = props.getProperty("plugin." + i + ".order");
                if (propPluginOrder != null) {
                    pluginOrder = Integer.parseInt(propPluginOrder.trim());
                    if (pluginOrder > maxOrder) {
                        maxOrder = pluginOrder;
                    }
                } else if (maxOrder != -1) {
                    pluginOrder = maxOrder;
                } else {
                    maxOrder = 0;
                    pluginOrder = 0;
                }
                Plugin p = (Plugin)Class.forName(pluginClass.trim()).newInstance();
                p.setup();
                p.readConfiguration("plugin." + i, props);
                PluginManager.registerPlugin(p, pluginOrder);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not register plugins", e);
        }
    }

    private String parseRepositoryProvider(Properties props) {
        return props.getProperty("repositoryProvider", "");
    }

    private String parseLocalDatastoreConfig(Properties props) throws Exception {
        return props.getProperty("localDatastoreConfig");
    }

    private String parseLocalBufferDatastoreConfig(Properties props) throws Exception {
        return props.getProperty("localBufferDatastoreConfig");
    }

    private String parseRemoteReadDatastoreConfig(Properties props) throws Exception {
        String prop = props.getProperty("remoteDatastoreConfig");
        if (prop != null) {
            return prop;
        }
        return props.getProperty("remoteReadDatastoreConfig");
    }

    private String parseRemoteWriteDatastoreConfig(Properties props) throws Exception {
        String prop = props.getProperty("remoteDatastoreConfig");
        if (prop != null) {
            return prop;
        }
        return props.getProperty("remoteWriteDatastoreConfig");
    }

    private Properties parseRepositoryProviderConfig(Properties props) throws Exception {
        Properties repositoryConfig = new Properties();
        String config = props.getProperty("repositoryProviderConfig");
        if (config == null) {
            return repositoryConfig;
        }
        URL configResource = Thread.currentThread().getContextClassLoader().getResource(config);
        if (configResource == null) {
            return repositoryConfig;
        }
        repositoryConfig.load(configResource.openStream());
        return repositoryConfig;
    }

    private String parseTargetsModelConfig(Properties props) throws Exception {
        return props.getProperty("targetsModelConfig", "targets.model.properties");
    }

    private Set<String> parseReadOnlyTargets(Properties props) {
        int count = Integer.parseInt(props.getProperty("readonlyTargetsCount", "0"));
        HashSet<String> res = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            res.add(props.getProperty("readonlyTargets." + i, "undefined"));
        }
        return res;
    }

    private Set<String> parseEditableTargets(Properties props) {
        int count = Integer.parseInt(props.getProperty("editableTargetsCount", "0"));
        HashSet<String> res = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            res.add(props.getProperty("editableTargets." + i, "undefined"));
        }
        return res;
    }

    private Set<String> parseUpdateTargets(Properties props) {
        int count = Integer.parseInt(props.getProperty("updateTargetsCount", "0"));
        HashSet<String> res = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            res.add(props.getProperty("updateTargets." + i, "undefined"));
        }
        return res;
    }

    private Set<String> parseInMemoryTargets(Properties props) {
        int count = Integer.parseInt(props.getProperty("inmemoryTargetsCount", "0"));
        HashSet<String> res = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            res.add(props.getProperty("inmemoryTargets." + i, "undefined"));
        }
        return res;
    }

    private Set<String> parseNonUpdateVOScopes(Properties props) {
        int count = Integer.parseInt(props.getProperty("nonUpdateVOScopesCount", "0"));
        logger.log(Level.INFO, "nonupdatescopes count : " + count);
        HashSet<String> res = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            res.add(props.getProperty("nonUpdateVOScopes." + i, "undefined"));
        }
        logger.log(Level.INFO, "nonupdatescopes : " + res);
        return res;
    }

    private Long parseBridgingPeriod(Properties props) {
        Long value = null;
        String period = props.getProperty("bridgingPeriod");
        if (period == null) {
            return null;
        }
        String periodUnit = props.getProperty("bridgingPeriodUnit");
        if (periodUnit == null) {
            return null;
        }
        value = TimeUnit.MILLISECONDS.convert(Long.parseLong(period.trim()), TimeUnit.valueOf(periodUnit.trim()));
        return value;
    }

    private Long parseShortBridgingPeriod(Properties props) {
        Long value = null;
        String period = props.getProperty("shortBridgingPeriod");
        if (period == null) {
            return null;
        }
        String periodUnit = props.getProperty("shortBridgingPeriodUnit");
        if (periodUnit == null) {
            return null;
        }
        value = TimeUnit.MILLISECONDS.convert(Long.parseLong(period.trim()), TimeUnit.valueOf(periodUnit.trim()));
        return value;
    }

    private Boolean parseClearDataStoreOnStartup(Properties props) {
        Boolean propValue = null;
        String prop = null;
        prop = props.getProperty("clearDataStoreOnStartup");
        if (prop == null) {
            return null;
        }
        propValue = Boolean.parseBoolean(prop.trim());
        return propValue;
    }

    public String getRepositoryProvider() {
        return this.repositoryProvider;
    }

    public Properties getRepositoryProviderConfig() {
        return this.repositoryProviderConfig;
    }

    public Set<String> getReadOnlyTargets() {
        return this.readOnlyTargets;
    }

    public Set<String> getEditableTargets() {
        return this.editableTargets;
    }

    public Set<String> getUpdateTargets() {
        return this.updateTargets;
    }

    public Set<String> getInMemoryTargets() {
        return this.inMemoryTargets;
    }

    public Set<String> getNonUpdateVOScopes() {
        return this.nonUpdateVOScopes;
    }

    public void setLocalNodeHostname(String localNodeHostname) {
        this.localNodeHostname = localNodeHostname;
    }

    public String getLocalNodeHostname() throws ResourceRegistryException {
        if (this.localNodeHostname == null) {
            throw new ResourceRegistryException("Missing local node hostname information.");
        }
        return this.localNodeHostname;
    }

    public void setLocalNodePort(String localNodePort) {
        this.localNodePort = localNodePort;
    }

    public String getLocalNodePort() throws ResourceRegistryException {
        if (this.localNodePort == null) {
            throw new ResourceRegistryException("Missing local node port information.");
        }
        return this.localNodePort;
    }

    public boolean isTargetInMemory(String target) {
        if (!this.inMemoryTargets.contains(target)) {
            return InMemoryStore.containsItemType(target);
        }
        return true;
    }

    public Long getBridgingPeriod() {
        return this.bridgingPeriod;
    }

    public Long getShortBridgingPeriod() {
        return this.shortBridgingPeriod;
    }

    public Boolean getClearDataStoreOnStartup() {
        return this.clearDataStoreOnStartup;
    }

    public PersistenceManagerFactory getFactoryForRead(DatastoreType persistencyType) throws ResourceRegistryException {
        switch (persistencyType) {
            case REMOTE: {
                return this.pmfRemoteRead;
            }
            case LOCAL: {
                return this.pmfLocal;
            }
            case LOCALBUFFER: {
                return this.pmfBufferLocal;
            }
        }
        throw new ResourceRegistryException("undefined context type " + (Object)((Object)persistencyType));
    }

    public PersistenceManagerFactory getFactoryForWrite(DatastoreType persistencyType) throws ResourceRegistryException {
        switch (persistencyType) {
            case REMOTE: {
                return this.pmfRemoteWrite;
            }
            case LOCAL: {
                return this.pmfLocal;
            }
            case LOCALBUFFER: {
                return this.pmfBufferLocal;
            }
        }
        throw new ResourceRegistryException("undefined context type " + (Object)((Object)persistencyType));
    }

    public PersistenceManager getManagerForRead(DatastoreType persistencyType) throws ResourceRegistryException {
        switch (persistencyType) {
            case REMOTE: {
                return this.pmfRemoteRead.getPersistenceManager();
            }
            case LOCAL: {
                return this.pmfLocal.getPersistenceManager();
            }
            case LOCALBUFFER: {
                return this.pmfBufferLocal.getPersistenceManager();
            }
        }
        throw new ResourceRegistryException("undefined context type " + (Object)((Object)persistencyType));
    }

    public PersistenceManager getManagerForWrite(DatastoreType persistencyType) throws ResourceRegistryException {
        switch (persistencyType) {
            case REMOTE: {
                return this.pmfRemoteWrite.getPersistenceManager();
            }
            case LOCAL: {
                return this.pmfLocal.getPersistenceManager();
            }
            case LOCALBUFFER: {
                return this.pmfBufferLocal.getPersistenceManager();
            }
        }
        throw new ResourceRegistryException("undefined context type " + (Object)((Object)persistencyType));
    }

    public boolean isDatastoreSupportedForRead(DatastoreType datastore) {
        switch (datastore) {
            case LOCAL: {
                return this.pmfLocal != null;
            }
            case LOCALBUFFER: {
                return this.pmfBufferLocal != null;
            }
            case REMOTE: {
                return this.pmfRemoteRead != null;
            }
        }
        return false;
    }

    public boolean isDatastoreSupportedForWrite(DatastoreType datastore) {
        switch (datastore) {
            case LOCAL: {
                return this.pmfLocal != null;
            }
            case LOCALBUFFER: {
                return this.pmfBufferLocal != null;
            }
            case REMOTE: {
                return this.pmfRemoteRead != null;
            }
        }
        return false;
    }

    public boolean isDatastoreSupported(DatastoreType datastore) {
        return this.isDatastoreSupportedForRead(datastore) && this.isDatastoreSupportedForWrite(datastore);
    }

    public Lock getSharedLock() {
        return this.lock.readLock();
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public void reset() throws ResourceRegistryException {
        try {
            this.resetDT(DatastoreType.LOCAL);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error resetting", e);
        }
        try {
            this.resetDT(DatastoreType.LOCALBUFFER);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error resetting", e);
        }
        try {
            this.resetDT(DatastoreType.REMOTE);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error resetting", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDT(DatastoreType datastoretype) throws ResourceRegistryException {
        PersistenceManager pm = null;
        Lock lock = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            lock = this.getExclusiveLock();
            lock.lock();
            pm = this.getManagerForWrite(datastoretype);
            pm.currentTransaction().begin();
            HashSet<String> classes = new HashSet<String>();
            classes.addAll(this.readOnlyTargets);
            classes.addAll(this.editableTargets);
            classes.addAll(this.updateTargets);
            classes.addAll(pm.getManagedObjects());
            classes.remove("gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao");
            for (String cl : classes) {
                try {
                    pm.newQuery(Class.forName(cl)).deletePersistentAll();
                }
                catch (Exception e) {}
            }
            try {
                pm.deletePersistentAll(classes);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pm.deletePersistentAll((Collection)pm.getManagedObjects());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                conn = DriverManager.getConnection(this.connectionURL);
                stmt = conn.createStatement();
                int val = stmt.executeUpdate("DELETE from NUCLEUS_TABLES");
            }
            catch (Exception ex) {
                throw new ResourceRegistryException(ex.getMessage(), ex.getCause());
            }
            pm.currentTransaction().commit();
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                throw new ResourceRegistryException(ex.getMessage(), ex.getCause());
            }
            lock.unlock();
        }
    }

    public static enum WritePolicy {
        WRITE_THROUGH,
        WRITE_LOCAL,
        WRITE_BEHIND;

    }

    public static enum ReadPolicy {
        READ_THROUGH,
        READ_LOCAL,
        REFRESH_AHEAD;

    }

    public static enum DatastoreType {
        REMOTE,
        LOCAL,
        LOCALBUFFER;

    }
}

