/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.query;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(QueryHelper.class);

    public static Map<String, String> getAllCollections(String scope) throws ResourceRegistryException {
        HashMap<String, String> collections = new HashMap<String, String>();
        List<DataCollection> cols = DataCollection.getAllCollections(true);
        for (DataCollection col : cols) {
            logger.info("    col : " + col.getID() + " , " + col.getName() + " with scopes : " + col.getScopes());
            if (scope != null && !col.getScopes().contains(scope)) continue;
            collections.put(col.getID(), col.getName());
        }
        logger.info("all collections in Resource Registry are : " + collections);
        return collections;
    }

    public static Map<String, String> getAllCollectionsTypes(String scope) throws ResourceRegistryException {
        HashMap<String, String> collections = new HashMap<String, String>();
        List<DataCollection> cols = DataCollection.getAllCollections(true);
        for (DataCollection col : cols) {
            logger.info("    col : " + col.getID() + " , " + col.getName() + " with scopes : " + col.getScopes() + " type : " + col.getCollectionType());
            if (scope != null && !col.getScopes().contains(scope)) continue;
            String type = col.getCollectionType();
            if (type == null || type.trim().length() == 0) {
                type = "non opensearch";
            }
            collections.put(col.getID(), type);
        }
        logger.info("all collections in Resource Registry are : " + collections);
        return collections;
    }

    public static Map<String, String> getAllSearchableCollections(String scope) throws ResourceRegistryException {
        Map<String, String> allAvailableCollections = QueryHelper.getAllCollections(scope);
        logger.info("all available collections in Resource Registry are : " + allAvailableCollections);
        Set<String> allSearchableCollectionsIDs = QueryHelper.getAllSearchableFieldsPerCollection(scope).keySet();
        logger.info("all searchable collection ids in Resource Registry are : " + allSearchableCollectionsIDs);
        HashMap<String, String> allSearchableCollections = new HashMap<String, String>();
        for (String collID : allSearchableCollectionsIDs) {
            String collName = allAvailableCollections.get(collID);
            allSearchableCollections.put(collID, collName);
        }
        logger.info("all collections in Resource Registry are : " + allSearchableCollections);
        return allSearchableCollections;
    }

    public static Map<String, Set<String>> getAllSearchableFieldsPerCollection(String scope) throws ResourceRegistryException {
        HashMap<String, Set<String>> fieldsPerCollection = new HashMap<String, Set<String>>();
        List<Field> fields = Field.getAll(true);
        for (Field field : fields) {
            for (Searchable searchable : field.getSearchables()) {
                String collection = searchable.getCollection();
                logger.info(" field : " + field.getName() + " searchable : " + searchable.getID() + "   col : " + collection + " with scopes : " + searchable.getDatasourceScopes());
                if (scope != null && !searchable.getDatasourceScopes().contains(scope)) continue;
                if (!fieldsPerCollection.containsKey(collection)) {
                    fieldsPerCollection.put(collection, new HashSet());
                }
                ((Set)fieldsPerCollection.get(collection)).add(field.getName());
            }
        }
        logger.info("all (searchable) fields in Resource Registry are : " + fieldsPerCollection);
        return fieldsPerCollection;
    }

    public static Map<String, Set<String>> getCollectionLangsByFieldRelation(Map<String, List<String>> fieldRelationMap, List<String> projections, String scope) throws ResourceRegistryException {
        logger.info("getting collection languages by field relation. fieldRelationMap : " + fieldRelationMap + " projections : " + projections + " scope : " + scope);
        HashMap<String, Set<String>> lngs = new HashMap<String, Set<String>>();
        List<DataCollection> cols = DataCollection.getAllCollections(true);
        logger.info("all collections : ");
        for (DataCollection col : cols) {
            logger.info("    col : " + col.getID() + " , " + col.getName() + " with scopes : " + col.getScopes());
            if (scope != null && !col.getScopes().contains(scope)) continue;
            Set<String> langByFieldRelationCol = QueryHelper.getLanguageByFieldRelationCol(fieldRelationMap, col.getID(), projections, scope);
            logger.info("     langByFieldRelationCol : " + langByFieldRelationCol);
            lngs.put(col.getID(), langByFieldRelationCol);
        }
        logger.info("getting collection languages by field relation. fieldRelationMap : " + fieldRelationMap + " projections : " + projections + " scope : " + scope + " Found : " + lngs);
        return lngs;
    }

    public static Set<String> getLanguageByFieldRelationCol(Map<String, List<String>> fieldRelationMap, String collection, List<String> projections, String scope) throws ResourceRegistryException {
        logger.info("getting languages by field relation collection(1). fieldRelationMap : " + fieldRelationMap + " collection : " + collection + " projections : " + projections + " scope : " + scope);
        HashSet<Object> lngs = null;
        for (Map.Entry<String, List<String>> m : fieldRelationMap.entrySet()) {
            logger.info("  ~>examining field relation : " + m);
            Set<String> l = QueryHelper.getLanguageByFieldRelationCol(m.getKey(), m.getValue(), collection, projections, scope);
            logger.info("  ~>languages by field relation col : " + l);
            if (lngs == null) {
                lngs = new HashSet<String>(l);
                continue;
            }
            lngs.retainAll(l);
        }
        logger.info("getting languages by field relation collection(1). fieldRelationMap : " + fieldRelationMap + " collection : " + collection + " projections : " + projections + " scope : " + scope + " Found : " + lngs);
        if (lngs == null) {
            lngs = new HashSet();
        }
        return lngs;
    }

    public static Set<String> getCollectionByFieldRelationLang(Map<String, List<String>> fieldRelationMap, String language, List<String> projections, String scope) throws ResourceRegistryException {
        HashSet<Object> cols = null;
        for (Map.Entry<String, List<String>> m : fieldRelationMap.entrySet()) {
            Set<String> c = QueryHelper.getCollectionByFieldRelationLang(m.getKey(), m.getValue(), language, projections, scope);
            if (cols == null) {
                cols = new HashSet<String>(c);
                continue;
            }
            cols.retainAll(c);
        }
        if (cols == null) {
            cols = new HashSet();
        }
        return cols;
    }

    public static Set<String> getLanguageByFieldRelationCol(String field, List<String> relations, String collection, List<String> projections, String scope) throws ResourceRegistryException {
        logger.info("getting languages by field realtion collection(2). relations : " + relations + " collection : " + collection + " projections : " + projections + " scope : " + scope);
        List<DataSource> indexes = DataSource.queryByFieldIDAndTypeAndCollection(true, field, collection, FieldIndexContainer.FieldType.Searchable);
        logger.info("indexes found for field : " + field + " collection : " + collection + " type : " + (Object)((Object)FieldIndexContainer.FieldType.Searchable) + ". number of indexes found : " + indexes.size());
        HashMap x = new HashMap();
        for (DataSource dataSource : indexes) {
            logger.info("    index : " + dataSource.getID() + " , type : " + (Object)((Object)dataSource.getType()) + " scopes : " + dataSource.getScopes());
            if (scope != null && !dataSource.getScopes().contains(scope)) {
                logger.info("    index : " + dataSource.getID() + " is skipped because scope : " + scope + " is not contained in  : " + dataSource.getScopes());
                continue;
            }
            Set<String> languages = dataSource.getLanguagesForCollectionAndSearchableField(collection, field);
            logger.info("    languages for collection and searchable field. collection : " + collection + " , field : " + field + " =>  languages : " + languages);
            for (String lang : languages) {
                if (!x.containsKey(lang)) {
                    x.put(lang, new ArrayList());
                }
                ((List)x.get(lang)).add(dataSource);
            }
        }
        logger.info("datasources per language");
        for (Map.Entry entry : x.entrySet()) {
            ArrayList<String> dsList = new ArrayList<String>();
            for (DataSource ds : (List)entry.getValue()) {
                dsList.add(ds.getID() + " " + ds.getCapabilities());
            }
            logger.info("     language : " + (String)entry.getKey() + " -> datasources (id, capabilities): " + dsList);
        }
        HashSet<String> lngs = new HashSet<String>();
        for (String lang : x.keySet()) {
            boolean include = true;
            for (String relation : relations) {
                boolean found = false;
                for (DataSource index : (List)x.get(lang)) {
                    if (!index.getCapabilities().contains(relation)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                include = false;
                break;
            }
            if (!include) continue;
            lngs.add(lang);
        }
        logger.info("getting languages by field realtion collection(2). relations : " + relations + " collection : " + collection + " projections : " + projections + " scope : " + scope + ". Found : " + relations);
        return lngs;
    }

    public static Set<String> getCollectionByFieldRelationLang(String field, List<String> relations, String language, List<String> projections, String scope) throws ResourceRegistryException {
        logger.info("getting collection by field realtion lang. field : " + field + "relations : " + relations + " language : " + language + " projections : " + projections + " scope : " + scope);
        List<DataSource> indexes = DataSource.queryByFieldIDAndTypeAndLanguage(true, field, language, FieldIndexContainer.FieldType.Searchable);
        logger.info("indexes found for field : " + field + " language : " + language + " type : " + (Object)((Object)FieldIndexContainer.FieldType.Searchable));
        HashMap x = new HashMap();
        for (DataSource dataSource : indexes) {
            logger.info("    index : " + dataSource.getID() + " , type : " + (Object)((Object)dataSource.getType()) + " scopes : " + dataSource.getScopes());
            if (scope != null && !dataSource.getScopes().contains(scope)) continue;
            Set<String> collections = dataSource.getLanguagesForCollectionAndSearchableField(language, field);
            logger.info("    collections for languages and searchable field. collection : " + language + " , field : " + field + " =>  languages : " + collections);
            for (String col : collections) {
                if (!x.containsKey(col)) {
                    x.put(col, new ArrayList());
                }
                ((List)x.get(col)).add(dataSource);
            }
        }
        logger.info("datasources per language");
        for (Map.Entry entry : x.entrySet()) {
            ArrayList<String> dsList = new ArrayList<String>();
            for (DataSource ds : (List)entry.getValue()) {
                dsList.add(ds.getID() + " " + ds.getCapabilities());
            }
            logger.info("     language : " + (String)entry.getKey() + " -> datasources (id, capabilities): " + dsList);
        }
        HashSet<String> cols = new HashSet<String>();
        for (String col : x.keySet()) {
            boolean include = true;
            for (String relation : relations) {
                boolean found = false;
                for (DataSource index : (List)x.get(x)) {
                    if (!index.getCapabilities().contains(relation)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                include = false;
                break;
            }
            if (!include) continue;
            cols.add(col);
        }
        logger.info("getting collection by field realtion lang. field : " + field + "relations : " + relations + " language : " + language + " projections : " + projections + " scope : " + scope + ". Found : " + cols);
        return cols;
    }

    public static Map<String, Set<Field>> getCollectionFieldsByPresentationInfo(Set<String> info) throws ResourceRegistryException {
        HashMap<String, Set<Field>> res = new HashMap<String, Set<Field>>();
        List<Field> allFields = Field.getAll(true);
        for (Field f : allFields) {
            for (Presentable p : f.getPresentables()) {
                boolean found = true;
                for (String pi : info) {
                    if (p.getPresentationInfo().contains(pi)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                if (!res.containsKey(p.getCollection())) {
                    res.put(p.getCollection(), new HashSet());
                }
                ((Set)res.get(p.getCollection())).add(f);
            }
        }
        return res;
    }

    public static Set<Field> getFieldsByPresentationInfo(Set<String> info) throws ResourceRegistryException {
        HashSet<Field> res = new HashSet<Field>();
        List<Field> allFields = Field.getAll(true);
        for (Field f : allFields) {
            block1: for (Presentable p : f.getPresentables()) {
                for (String pi : info) {
                    if (!p.getPresentationInfo().contains(pi)) continue;
                    res.add(f);
                    continue block1;
                }
            }
        }
        return res;
    }

    public static Set<String> getPresentationInfoOfField(Field f) throws ResourceRegistryException {
        HashSet<String> info = new HashSet<String>();
        if (f.getPresentables().isEmpty()) {
            return info;
        }
        info.addAll(f.getPresentables().iterator().next().getPresentationInfo());
        for (Presentable p : f.getPresentables()) {
            HashSet<String> toDelInfo = new HashSet<String>();
            for (String i : info) {
                if (p.getPresentationInfo().contains(i)) continue;
                toDelInfo.add(i);
            }
            info.removeAll(toDelInfo);
            if (!info.isEmpty()) continue;
            return info;
        }
        return info;
    }

    public static Set<DataCollection> getExternalCollectionsOfScope(String scope) throws ResourceRegistryException {
        HashSet<String> colIds = new HashSet<String>();
        HashSet<DataCollection> cols = new HashSet<DataCollection>();
        List<Field> allFields = Field.getAll(true);
        List<DataSource> allDs = DataSource.getAll(true);
        ArrayList<DataSource> dsToRemove = new ArrayList<DataSource>();
        for (DataSource ds : allDs) {
            if (ds.getScopes().contains(scope)) continue;
            dsToRemove.add(ds);
        }
        allDs.removeAll(dsToRemove);
        for (DataSource ds : allDs) {
            if (!ds.getScopes().contains(scope)) continue;
            for (Field f : allFields) {
                boolean foundService;
                for (Searchable s : f.getSearchables()) {
                    if (ds.getDataSourceServices() == null) continue;
                    foundService = false;
                    for (DataSourceService service : ds.getDataSourceServices()) {
                        if (!service.getID().equals(s.getLocator())) continue;
                        foundService = true;
                        break;
                    }
                    if (!foundService || !ds.getType().isExternal()) continue;
                    colIds.add(s.getCollection());
                }
                for (Presentable p : f.getPresentables()) {
                    foundService = false;
                    for (DataSourceService service : ds.getDataSourceServices()) {
                        if (!service.getID().equals(p.getLocator())) continue;
                        foundService = true;
                        break;
                    }
                    if (!foundService || !ds.getScopes().contains(scope) || !ds.getType().isExternal()) continue;
                    colIds.add(p.getCollection());
                }
            }
        }
        for (String colId : colIds) {
            DataCollection col = new DataCollection();
            col.setID(colId);
            if (!col.load(true)) {
                logger.info("Could not load collection with id " + colId);
                continue;
            }
            cols.add(col);
        }
        return cols;
    }

    public static Set<DataCollection> getExternalCollections() throws ResourceRegistryException {
        HashSet<String> colIds = new HashSet<String>();
        HashSet<DataCollection> cols = new HashSet<DataCollection>();
        List<Field> allFields = Field.getAll(true);
        List<DataSource> allDs = DataSource.getAll(true);
        for (DataSource ds : allDs) {
            for (Field f : allFields) {
                boolean foundService;
                for (Searchable s : f.getSearchables()) {
                    if (ds.getDataSourceServices() == null) continue;
                    foundService = false;
                    for (DataSourceService service : ds.getDataSourceServices()) {
                        if (!service.getID().equals(s.getLocator())) continue;
                        foundService = true;
                        break;
                    }
                    if (!foundService || !ds.getType().isExternal()) continue;
                    colIds.add(s.getCollection());
                }
                for (Presentable p : f.getPresentables()) {
                    if (ds.getDataSourceServices() == null) continue;
                    foundService = false;
                    for (DataSourceService service : ds.getDataSourceServices()) {
                        if (!service.getID().equals(p.getLocator())) continue;
                        foundService = true;
                        break;
                    }
                    if (!foundService || !ds.getType().isExternal()) continue;
                    colIds.add(p.getCollection());
                }
            }
        }
        for (String colId : colIds) {
            DataCollection col = new DataCollection();
            col.setID(colId);
            if (!col.load(true)) {
                logger.info("Could not load collection with id " + colId);
                continue;
            }
            cols.add(col);
        }
        return cols;
    }

    public static Set<String> getCapabilitiesByFieldCollection(Field f, String collection) throws ResourceRegistryException {
        HashSet<String> capabilities = new HashSet<String>();
        for (Searchable s : f.getSearchables()) {
            if (s.getCapabilities().isEmpty()) {
                s.load(true);
            }
            if (!s.getCollection().equals(collection)) continue;
            capabilities.addAll(s.getCapabilities());
        }
        return capabilities;
    }

    public static List<String> getSourceIdsForFieldRelationCollectionLanguage(String field, String relation, String collection, String language, String scope) throws ResourceRegistryException {
        logger.info("getting source ids for field : " + field + ", relation : " + relation + ", collection : " + collection + ", language : " + language + ", scope : " + scope);
        ArrayList<String> sources = new ArrayList<String>();
        long fieldRetrieveStart = Calendar.getInstance().getTimeInMillis();
        Field f = new Field();
        f.setID(field);
        if (!f.exists()) {
            throw new ResourceRegistryException("field with id " + field + " does not exist");
        }
        f = Field.getById(true, field);
        long fieldRetrieveEnd = Calendar.getInstance().getTimeInMillis();
        long processSearchablesStart = Calendar.getInstance().getTimeInMillis();
        for (Searchable s : f.getSearchables()) {
            logger.info("    checking searchable : " + s.getID());
            logger.info("    scope : " + scope);
            logger.info("    datasource scopes : " + s.getDatasourceScopes());
            logger.info("    relation : " + relation);
            logger.info("    capabilities : " + s.getCapabilities());
            logger.info("    collection : " + collection);
            logger.info("    collections : " + s.getCollection());
            if (scope != null && !s.getDatasourceScopes().contains(scope) || !s.getCapabilities().contains(relation) || !s.getCollection().equals(collection)) continue;
            Set<String> lngs = DataLanguage.getLanguages(collection, field);
            logger.info("    language : " + language);
            logger.info("    languages : " + lngs);
            if (lngs == null || !lngs.contains(language)) continue;
            logger.info("searchable : " + s.getLocator() + " added!");
            sources.add(s.getLocator());
        }
        long processSearchablesEnd = Calendar.getInstance().getTimeInMillis();
        logger.info("getting source ids for field : " + field + ", relation : " + relation + ", collection : " + collection + ", language : " + language + " returned : " + sources);
        return sources;
    }

    public static HashMap<String, HashSet<String>> getProjectionsPerSource(Set<String> sources, Set<String> projectionsNeeded, HashMap<String, HashSet<String>> colLangs, String scope) throws ResourceRegistryException {
        HashMap<String, HashSet<String>> ret = new HashMap<String, HashSet<String>>();
        Set allDatasources = null;
        Set allFieldInfo = null;
        try {
            allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
            allFieldInfo = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldIndexContainerDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not load data source information", (Throwable)e);
        }
        for (IDaoElement indEl : allDatasources) {
            DataSourceDao ind = (DataSourceDao)indEl;
            if (scope != null && !ind.getScopes().contains(scope)) continue;
            boolean foundService = false;
            String foundServiceId = null;
            if (ind.getBoundDataSourceServices() == null) continue;
            for (String service : ind.getBoundDataSourceServices()) {
                if (!sources.contains(service)) continue;
                foundService = true;
                foundServiceId = service;
                break;
            }
            if (!foundService) continue;
            if (!ret.containsKey(foundServiceId)) {
                ret.put(foundServiceId, new HashSet());
            }
            for (String projection : projectionsNeeded) {
                if (!QueryHelper.IndexCompliesForPresentableForAllCollLanguages(ind, allFieldInfo, projection, colLangs)) continue;
                ret.get(ind.getID()).add(projection);
            }
        }
        return ret;
    }

    private static boolean IndexCompliesForPresentableForAllCollLanguages(DataSourceDao index, Set<IDaoElement> allFieldInfo, String field, HashMap<String, HashSet<String>> colLangs) {
        HashMap indColLangs = new HashMap();
        for (String string : index.getFields()) {
            FieldIndexContainerDao container = null;
            for (IDaoElement fic : allFieldInfo) {
                if (!((FieldIndexContainerDao)fic).getID().equals(string)) continue;
                container = (FieldIndexContainerDao)fic;
                break;
            }
            if (!container.getFieldType().equalsIgnoreCase("p")) continue;
            if (!indColLangs.containsKey(container.getCollection())) {
                indColLangs.put(container.getCollection(), new HashSet());
            }
            ((HashSet)indColLangs.get(container.getCollection())).add(container.getLanguage());
        }
        if (colLangs.size() > indColLangs.size()) {
            return false;
        }
        for (Map.Entry entry : colLangs.entrySet()) {
            if (!indColLangs.containsKey(entry.getKey())) {
                return false;
            }
            for (String l : (HashSet)entry.getValue()) {
                if (((HashSet)indColLangs.get(entry.getKey())).contains(l)) continue;
                return false;
            }
        }
        return true;
    }

    public static DataSource GetSourceById(String id) throws ResourceRegistryException {
        return DataSource.getById(true, id);
    }

    public static DataSourceService GetSourceServiceById(String id) throws ResourceRegistryException {
        return DataSourceService.getById(true, id);
    }

    public static String GetFieldNameById(String id) throws ResourceRegistryException {
        return Field.getFieldNameById(id);
    }

    public static List<DataSource> GetSources(String type) throws ResourceRegistryException {
        if (type.equals(DataSource.class.getName())) {
            return new ArrayList<DataSource>(DataSource.getAll(true));
        }
        return null;
    }
}

