/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSourceManagerPlugin
extends Plugin {
    private static Logger logger = Logger.getLogger(DataSourceManagerPlugin.class.getName());
    public static long InactiveDataSourceGracePeriodDef = 10L;
    public static TimeUnit InactiveDataSourceGracePeriodUnitDef = TimeUnit.DAYS;
    public static long InactiveDataSourceGracePeriod = InactiveDataSourceGracePeriodDef;
    public static TimeUnit InactiveDataSourceGracePeriodUnit = InactiveDataSourceGracePeriodUnitDef;

    public DataSourceManagerPlugin() {
        this.type = Plugin.Type.PRE_UPDATE;
        this.processedItems.add(new Plugin.ProcessedItemType(SearchableDao.class, RRContext.DatastoreType.LOCAL));
        this.processedItems.add(new Plugin.ProcessedItemType(PresentableDao.class, RRContext.DatastoreType.LOCAL));
        this.processedItems.add(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCAL));
    }

    public void readConfiguration(String prefix, Properties properties) throws ResourceRegistryException {
        super.readConfiguration(prefix, properties);
        if (properties == null) {
            return;
        }
        boolean defaultUsed = true;
        String value = null;
        value = properties.getProperty("inactiveDataSourceGrace");
        if (value != null) {
            String intervalValue = value;
            value = properties.getProperty("inactiveDataSourceGraceUnit");
            if (value != null) {
                InactiveDataSourceGracePeriod = Long.parseLong(intervalValue);
                InactiveDataSourceGracePeriodUnit = TimeUnit.valueOf(value);
                defaultUsed = false;
                logger.log(Level.INFO, "Using inactive DataSource grace period: " + InactiveDataSourceGracePeriod + " " + (Object)((Object)InactiveDataSourceGracePeriodUnit));
            }
        }
        if (defaultUsed) {
            logger.log(Level.INFO, "Using default inactive DataSource grace period: " + InactiveDataSourceGracePeriod + " " + (Object)((Object)InactiveDataSourceGracePeriodUnit));
        }
    }

    private List<Field> getFields() throws ResourceRegistryException {
        Set fields = (Set)this.items.get(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCAL));
        if (fields == null) {
            return Field.getAll((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCAL);
        }
        return new ArrayList<Field>(fields);
    }

    private Set<IDaoElement> getSearchables() throws ResourceRegistryException {
        Set s = (Set)this.itemDaos.get(new Plugin.ProcessedItemType(SearchableDao.class, RRContext.DatastoreType.LOCAL));
        try {
            if (s == null) {
                return DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("", (Throwable)e);
        }
        return s;
    }

    private Set<IDaoElement> getPresentables() throws ResourceRegistryException {
        Set p = (Set)this.itemDaos.get(new Plugin.ProcessedItemType(PresentableDao.class, RRContext.DatastoreType.LOCAL));
        try {
            if (p == null) {
                return DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("", (Throwable)e);
        }
        return p;
    }

    public void setup() throws ResourceRegistryException {
    }

    private ElementMetadata createElementMetadataForDataSource(String dataSourceId, long timestamp) throws ResourceRegistryException {
        DataSource ds = DataSource.getById((boolean)true, (String)dataSourceId);
        ElementMetadata m = new ElementMetadata();
        m.setID(dataSourceId);
        m.setType(ElementMetadata.Type.DataSource);
        m.setMetadataTimestamp(timestamp);
        StringBuffer buf = new StringBuffer();
        if (ds != null) {
            for (String scope : ds.getScopes()) {
                buf.append(scope + " ");
            }
        }
        m.getProperties().put("scopes", buf.toString().trim());
        return m;
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        long timestamp = new Date().getTime();
        try {
            if (targets.contains(ElementMetadataDao.class)) {
                ElementMetadata m;
                Set<IDaoElement> allSearchables = this.getSearchables();
                Set<IDaoElement> allPresentables = this.getPresentables();
                Set allDataSourceIds = DataSource.getAllIds();
                for (String dsId : allDataSourceIds) {
                    m = null;
                    m = ElementMetadata.getById((boolean)true, (String)dsId);
                    if (m == null) {
                        logger.log(Level.FINE, "Creating element metadata for active datasource " + dsId);
                        m = this.createElementMetadataForDataSource(dsId, timestamp);
                        m.store(true, RRContext.DatastoreType.LOCAL);
                        continue;
                    }
                    m.setMetadataTimestamp(timestamp);
                    m.store(true, RRContext.DatastoreType.LOCAL);
                }
                for (IDaoElement s : allSearchables) {
                    m = ElementMetadata.getById((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, (String)((SearchableDao)s).getLocator());
                    if (allDataSourceIds.contains(((SearchableDao)s).getLocator()) || m != null) continue;
                    logger.log(Level.FINE, "Creating element metadata for inactive datasource " + ((SearchableDao)s).getLocator());
                    m = this.createElementMetadataForDataSource(((SearchableDao)s).getLocator(), timestamp);
                    m.store(true, RRContext.DatastoreType.LOCAL);
                    allDataSourceIds.add(((SearchableDao)s).getLocator());
                }
                for (IDaoElement s : allPresentables) {
                    m = ElementMetadata.getById((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, (String)((PresentableDao)s).getLocator());
                    if (allDataSourceIds.contains(((PresentableDao)s).getLocator()) || m != null) continue;
                    logger.log(Level.FINE, "Creating element metadata for inactive datasource " + ((PresentableDao)s).getLocator());
                    m = this.createElementMetadataForDataSource(((PresentableDao)s).getLocator(), timestamp);
                    m.store(true, RRContext.DatastoreType.LOCAL);
                    allDataSourceIds.add(((PresentableDao)s).getLocator());
                }
                if (targets.contains(FieldDao.class) && targets.contains(SearchableDao.class) && targets.contains(PresentableDao.class)) {
                    List<Field> allFields = this.getFields();
                    HashSet<String> toDelMetadata = new HashSet<String>();
                    for (Field f : allFields) {
                        boolean updated = false;
                        ArrayList<Searchable> toDelSearchables = new ArrayList<Searchable>();
                        for (Searchable s : f.getSearchables()) {
                            ElementMetadata m2;
                            if (DataSource.exists((String)s.getLocator()) || timestamp - (m2 = ElementMetadata.getById((boolean)true, (String)s.getLocator())).getMetadataTimestamp() <= TimeUnit.MILLISECONDS.convert(InactiveDataSourceGracePeriod, InactiveDataSourceGracePeriodUnit)) continue;
                            updated = true;
                            toDelSearchables.add(s);
                            toDelMetadata.add(s.getLocator());
                        }
                        ArrayList<Presentable> toDelPresentables = new ArrayList<Presentable>();
                        for (Presentable p : f.getPresentables()) {
                            ElementMetadata m3;
                            if (DataSource.exists((String)p.getLocator()) || timestamp - (m3 = ElementMetadata.getById((boolean)true, (String)p.getLocator())).getMetadataTimestamp() <= TimeUnit.MILLISECONDS.convert(InactiveDataSourceGracePeriod, InactiveDataSourceGracePeriodUnit)) continue;
                            updated = true;
                            toDelPresentables.add(p);
                            toDelMetadata.add(p.getLocator());
                        }
                        for (Searchable s : toDelSearchables) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Datasource " + s.getLocator() + " was inactive for more than " + InactiveDataSourceGracePeriod + " " + (Object)((Object)InactiveDataSourceGracePeriodUnit) + ". Removing searchable " + s.getID());
                            }
                            f.getSearchables().remove(s);
                            s.delete(true, RRContext.DatastoreType.LOCAL);
                        }
                        for (Presentable p : toDelPresentables) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Datasource " + p.getLocator() + " was inactive for more than " + InactiveDataSourceGracePeriod + " " + (Object)((Object)InactiveDataSourceGracePeriodUnit) + ". Removing presentable " + p.getID());
                            }
                            f.getPresentables().remove(p);
                            p.delete(true, RRContext.DatastoreType.LOCAL);
                        }
                        if (!updated) continue;
                        f.store(false, RRContext.DatastoreType.LOCAL);
                    }
                    for (String m4 : toDelMetadata) {
                        ElementMetadata toDel = new ElementMetadata();
                        toDel.setID(m4);
                        toDel.delete(true, RRContext.DatastoreType.LOCAL);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("could not align outgoing elements", (Throwable)e);
        }
    }
}

