/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPServerNozzleConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.execution.datatype.DataTypeString;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.execution.plan.PlanConfig;
import gr.uoa.di.madgik.execution.plan.element.BoundaryPlanElement;
import gr.uoa.di.madgik.execution.plan.element.BreakPlanElement;
import gr.uoa.di.madgik.execution.plan.element.ConditionalPlanElement;
import gr.uoa.di.madgik.execution.plan.element.FileTransferPlanElement;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.LoopPlanElement;
import gr.uoa.di.madgik.execution.plan.element.ParameterProcessingPlanElement;
import gr.uoa.di.madgik.execution.plan.element.SequencePlanElement;
import gr.uoa.di.madgik.execution.plan.element.ShellPlanElement;
import gr.uoa.di.madgik.execution.plan.element.TryCatchFinallyPlanElement;
import gr.uoa.di.madgik.execution.plan.element.WaitPlanElement;
import gr.uoa.di.madgik.execution.plan.element.attachment.ExecutionAttachment;
import gr.uoa.di.madgik.execution.plan.element.condition.BooleanVariableCondition;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTree;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTreeLeaf;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTreeNode;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionalFlow;
import gr.uoa.di.madgik.execution.plan.element.condition.TimeOutPlanCondition;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyReactionRetry;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterExternalFilter;
import gr.uoa.di.madgik.execution.plan.element.invocable.BoundaryConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExceptionExitCodeMaping;
import gr.uoa.di.madgik.execution.plan.element.invocable.simple.AttributedInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.FilteredInParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.SimpleInOutParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.SimpleInParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.SimpleOutParameter;
import gr.uoa.di.madgik.execution.plan.trycatchfinally.CatchElement;
import gr.uoa.di.madgik.execution.utils.BoundaryIsolationInfo;
import gr.uoa.di.madgik.execution.utils.EnvironmentKeyValue;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.workflow.adaptor.IWorkflowAdaptor;
import gr.uoa.di.madgik.workflow.adaptor.utils.AdaptorUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.IAdaptorResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.IOutputResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.AdaptorGridResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.AttachedGridResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.JobLogInfoFilter;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.JobStatusBreakLoopFilter;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.JobStatusExternalFilter;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.JobStatusSuccessFilter;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.OutputSandboxGridResource;
import gr.uoa.di.madgik.workflow.exception.WorkflowEnvironmentException;
import gr.uoa.di.madgik.workflow.exception.WorkflowInternalErrorException;
import gr.uoa.di.madgik.workflow.exception.WorkflowSerializationException;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowGridAdaptor
implements IWorkflowAdaptor {
    private static Logger logger = LoggerFactory.getLogger(WorkflowGridAdaptor.class);
    private AdaptorGridResources Resources = null;
    private Set<IOutputResource> OutputResources = null;
    private ExecutionPlan Plan = null;
    private String ExecutionId = null;
    private EnvHintCollection Hints = new EnvHintCollection();
    private NodeInfo GridUINode = null;
    private static long DefaultTimeout = Long.MAX_VALUE;
    private static long DefaultWaitPeriod = 60000L;
    private static long DefaultRetryOnErrorPeriod = 60000L;
    private static int DefaultRetryOnErrorTimes = 10;
    public long Timeout = DefaultTimeout;
    public long WaitPeriod = DefaultWaitPeriod;
    public long RetryOnErrorPeriod = DefaultRetryOnErrorPeriod;
    public int RetryOnErrorTimes = DefaultRetryOnErrorTimes;

    public WorkflowGridAdaptor() {
        this.OutputResources = new HashSet<IOutputResource>();
    }

    @Override
    public void SetAdaptorResources(IAdaptorResources Resources) throws WorkflowValidationException {
        if (!(Resources instanceof AdaptorGridResources)) {
            throw new WorkflowValidationException("Invalid adaptor resources provided");
        }
        this.Resources = (AdaptorGridResources)Resources;
        this.Resources.Validate();
    }

    @Override
    public void SetExecutionId(String executionId) {
        this.ExecutionId = executionId;
    }

    @Override
    public void CreatePlan() throws WorkflowValidationException, WorkflowSerializationException, WorkflowInternalErrorException, WorkflowEnvironmentException {
        if (this.Resources == null) {
            throw new WorkflowValidationException("No resources specified");
        }
        if (this.Timeout <= 0L) {
            this.Timeout = DefaultTimeout;
        }
        if (this.WaitPeriod <= 0L) {
            this.WaitPeriod = DefaultWaitPeriod;
        }
        this.CreateEnvironmentHints();
        this.ConstructWorkflow();
        this.ExcludeOutputResourcesCleanUp();
    }

    private void ExcludeOutputResourcesCleanUp() {
        for (IOutputResource res : this.OutputResources) {
            if (!(res instanceof OutputSandboxGridResource)) continue;
            this.Plan.CleanUpSSExclude.Add(((OutputSandboxGridResource)res).VariableID);
        }
    }

    private void CreateEnvironmentHints() {
        AttachedGridResource res = this.Resources.GetScopeResource();
        if (res != null) {
            this.Hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(res.Value)));
        }
    }

    @Override
    public ExecutionPlan GetCreatedPlan() {
        return this.Plan;
    }

    @Override
    public Set<IOutputResource> GetOutput() {
        return this.OutputResources;
    }

    private void ConstructWorkflow() throws WorkflowInternalErrorException, WorkflowValidationException, WorkflowEnvironmentException {
        try {
            try {
                HashSet<AttachedGridResource.ResourceType> ResourcesToStore = new HashSet<AttachedGridResource.ResourceType>();
                ResourcesToStore.add(AttachedGridResource.ResourceType.Config);
                ResourcesToStore.add(AttachedGridResource.ResourceType.InData);
                ResourcesToStore.add(AttachedGridResource.ResourceType.JDL);
                this.Resources.StoreResources(ResourcesToStore, this.Hints);
            }
            catch (Exception ex) {
                throw new WorkflowEnvironmentException("Could not store resources in storage system", ex);
            }
            this.Plan = new ExecutionPlan();
            this.Plan.Config = new PlanConfig();
            this.Plan.Config.ConnectionCallbackTimeout = 86400000L;
            this.Plan.Config.ModeOfConnection = PlanConfig.ConnectionMode.Callback;
            this.Plan.EnvHints = this.Hints;
            BoundaryPlanElement bound = this.ConstructBoundaryElement();
            this.Plan.Root = bound;
            bound.Root = new SequencePlanElement();
            if (this.Resources.GetConfigResource() != null) {
                ((SequencePlanElement)bound.Root).ElementCollection.add(this.CreateRetrieveFileElement(this.Resources.GetConfigResource()));
            }
            ((SequencePlanElement)bound.Root).ElementCollection.add(this.CreateRetrieveFileElement(this.Resources.GetJDLResource()));
            for (AttachedGridResource att : this.Resources.GetInDataResources()) {
                ((SequencePlanElement)bound.Root).ElementCollection.add(this.CreateRetrieveFileElement(att));
            }
            String jobIDFile = UUID.randomUUID().toString() + ".id.file.txt";
            SimpleInOutParameter LoopBreakCondition = AdaptorUtils.GetInOutParameter(true, this.Plan);
            SimpleInOutParameter StatusSuccessCondition = AdaptorUtils.GetInOutParameter(false, this.Plan);
            ((SequencePlanElement)bound.Root).ElementCollection.add(this.ConstructSubmitJobElement(jobIDFile));
            ((SequencePlanElement)bound.Root).ElementCollection.add(this.CreateStoreFileElement(jobIDFile));
            ((SequencePlanElement)bound.Root).ElementCollection.add(this.CheckLoop(jobIDFile, LoopBreakCondition, StatusSuccessCondition));
            ConditionalPlanElement cond = this.CheckTimeoutAndRetrieveOutput(LoopBreakCondition, StatusSuccessCondition, jobIDFile);
            if (cond != null) {
                ((SequencePlanElement)bound.Root).ElementCollection.add(cond);
            }
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private ConditionalPlanElement CheckTimeoutAndRetrieveOutput(SimpleInOutParameter LoopBreakCondition, SimpleInOutParameter StatusSuccessCondition, String jobIDFile) throws WorkflowValidationException {
        ConditionalPlanElement cond = new ConditionalPlanElement();
        if (this.Timeout == Long.MIN_VALUE || this.Timeout == Long.MAX_VALUE || this.Timeout == 0L) {
            ConditionalFlow retrieveOutput = this.GetOutputConditionalFlow(StatusSuccessCondition, jobIDFile);
            if (retrieveOutput != null) {
                cond.IfFlow = retrieveOutput;
            }
            cond.ElseIfFlows.clear();
            cond.ElseFlow = null;
        } else {
            cond.IfFlow = this.GetTimeoutConditionalFlow(LoopBreakCondition, jobIDFile);
            cond.ElseIfFlows.clear();
            ConditionalFlow retrieveOutput = this.GetOutputConditionalFlow(StatusSuccessCondition, jobIDFile);
            if (retrieveOutput != null) {
                cond.ElseIfFlows.add(retrieveOutput);
            }
            cond.ElseFlow = null;
        }
        return cond;
    }

    private ConditionalFlow GetOutputConditionalFlow(SimpleInOutParameter StatusSuccessCondition, String jobIDFile) throws WorkflowValidationException {
        if (this.Resources.GetOutDataResources().size() <= 0) {
            return null;
        }
        ConditionalFlow cond = new ConditionalFlow();
        cond.Condition = new ConditionTree();
        cond.Condition.Root = new ConditionTreeLeaf();
        ((ConditionTreeLeaf)cond.Condition.Root).Condition = new BooleanVariableCondition();
        ((BooleanVariableCondition)((ConditionTreeLeaf)cond.Condition.Root).Condition).FlagParameter = StatusSuccessCondition;
        cond.Root = new SequencePlanElement();
        String OutputDirectory = UUID.randomUUID().toString() + ".output.dir";
        ((SequencePlanElement)cond.Root).ElementCollection.add(this.RetrieveOutput(jobIDFile, OutputDirectory));
        String compressName = "Output";
        ((SequencePlanElement)cond.Root).ElementCollection.add(this.CompressOutput(compressName, OutputDirectory));
        AttachedGridResource att = new AttachedGridResource(compressName + ".tar", null);
        ((SequencePlanElement)cond.Root).ElementCollection.add(this.ChockError((IPlanElement)this.CreateStoreFileElement(att, OutputDirectory)));
        return cond;
    }

    private TryCatchFinallyPlanElement ChockError(IPlanElement element) {
        TryCatchFinallyPlanElement tcf = new TryCatchFinallyPlanElement();
        tcf.TryFlow = element;
        CatchElement c = new CatchElement();
        c.Error = null;
        c.Rethrow = false;
        c.Root = null;
        tcf.CatchFlows.add(c);
        tcf.FinallyFlow = null;
        return tcf;
    }

    private ConditionalFlow GetTimeoutConditionalFlow(SimpleInOutParameter LoopBreakCondition, String jobIDFile) throws WorkflowValidationException {
        ConditionalFlow cond = new ConditionalFlow();
        cond.Condition = new ConditionTree();
        cond.Condition.Root = new ConditionTreeNode();
        ((ConditionTreeNode)cond.Condition.Root).Verb = ConditionTreeNode.NodeVerb.AND;
        ((ConditionTreeNode)cond.Condition.Root).Post = ConditionTreeNode.PostVerb.Negate;
        ConditionTreeLeaf boolCond = new ConditionTreeLeaf();
        boolCond.Condition = new BooleanVariableCondition();
        ((BooleanVariableCondition)boolCond.Condition).FlagParameter = LoopBreakCondition;
        ((ConditionTreeNode)cond.Condition.Root).Childen.add(boolCond);
        cond.Root = new SequencePlanElement();
        ((SequencePlanElement)cond.Root).ElementCollection.add(this.CancelJob(jobIDFile));
        BreakPlanElement br = new BreakPlanElement();
        br.Message = "Timeout while waiting for job to complete";
        ((SequencePlanElement)cond.Root).ElementCollection.add(br);
        return cond;
    }

    private LoopPlanElement CheckLoop(String jobIDFile, SimpleInOutParameter LoopBreakCondition, SimpleInOutParameter StatusSuccessCondition) throws WorkflowValidationException {
        LoopPlanElement loop = new LoopPlanElement();
        loop.LoopCondition = this.GetCheckLoopCondition(LoopBreakCondition);
        loop.Root = new SequencePlanElement();
        ((SequencePlanElement)loop.Root).ElementCollection.add(this.PauseToRecheck());
        String StatusOutputVariableID = AdaptorUtils.GetInOutPrameter((ExecutionPlan)this.Plan).VariableName;
        ShellPlanElement sts = this.CheckStatus(jobIDFile, StatusOutputVariableID);
        ((SequencePlanElement)loop.Root).ElementCollection.add(sts);
        String LoggingOutputVariableID = AdaptorUtils.GetInOutPrameter((ExecutionPlan)this.Plan).VariableName;
        ShellPlanElement lognfo = this.CheckLoggingInfo(jobIDFile, LoggingOutputVariableID);
        ((SequencePlanElement)loop.Root).ElementCollection.add(lognfo);
        ParameterProcessingPlanElement proc = this.ProcessOutputs(StatusOutputVariableID, LoggingOutputVariableID, LoopBreakCondition.VariableName, lognfo.GetID(), StatusSuccessCondition.VariableName);
        ((SequencePlanElement)loop.Root).ElementCollection.add(proc);
        return loop;
    }

    private ConditionTree GetCheckLoopCondition(SimpleInOutParameter LoopBreakCondition) {
        ConditionTree condt = new ConditionTree();
        if (this.Timeout == Long.MIN_VALUE || this.Timeout == Long.MAX_VALUE || this.Timeout == 0L) {
            condt.Root = new ConditionTreeLeaf();
            ((ConditionTreeLeaf)condt.Root).Condition = new BooleanVariableCondition();
            ((BooleanVariableCondition)((ConditionTreeLeaf)condt.Root).Condition).FlagParameter = LoopBreakCondition;
        } else {
            condt.Root = new ConditionTreeNode();
            ((ConditionTreeNode)condt.Root).Verb = ConditionTreeNode.NodeVerb.AND;
            ConditionTreeLeaf jobDone = new ConditionTreeLeaf();
            jobDone.Condition = new BooleanVariableCondition();
            ((BooleanVariableCondition)jobDone.Condition).FlagParameter = LoopBreakCondition;
            ConditionTreeLeaf jobTimedOut = new ConditionTreeLeaf();
            jobTimedOut.Condition = new TimeOutPlanCondition();
            ((TimeOutPlanCondition)jobTimedOut.Condition).TimeoutThreshold = this.Timeout;
            ((ConditionTreeNode)condt.Root).Childen.add(jobDone);
            ((ConditionTreeNode)condt.Root).Childen.add(jobTimedOut);
        }
        return condt;
    }

    private WaitPlanElement PauseToRecheck() {
        WaitPlanElement wait = new WaitPlanElement();
        wait.WaitPeriod = this.WaitPeriod;
        return wait;
    }

    private ParameterProcessingPlanElement ProcessOutputs(String StatusOutputVariableID, String LoggingOutputVariableID, String BreakParameterName, String StatusCheckNodeID, String SuccessParameterName) {
        ParameterProcessingPlanElement proc = new ParameterProcessingPlanElement();
        ParameterExternalFilter statusFilter = new ParameterExternalFilter();
        statusFilter.Order = 0;
        statusFilter.TokenMapping.clear();
        statusFilter.ExternalFilter = new JobStatusExternalFilter();
        ((JobStatusExternalFilter)statusFilter.ExternalFilter).JobStatusVariableName = StatusOutputVariableID;
        NamedDataType ndtJobStatus = new NamedDataType();
        ndtJobStatus.IsAvailable = false;
        ndtJobStatus.Token = ndtJobStatus.Name = UUID.randomUUID().toString();
        ndtJobStatus.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtJobStatus);
        ((JobStatusExternalFilter)statusFilter.ExternalFilter).JobStatusOutputVariableName = ndtJobStatus.Name;
        ((JobStatusExternalFilter)statusFilter.ExternalFilter).StoreOutput = true;
        ParameterExternalFilter parseStatusFilter = new ParameterExternalFilter();
        parseStatusFilter.Order = 1;
        parseStatusFilter.TokenMapping.clear();
        parseStatusFilter.ExternalFilter = new JobStatusBreakLoopFilter();
        ((JobStatusBreakLoopFilter)parseStatusFilter.ExternalFilter).JobStatusVariableName = ndtJobStatus.Name;
        ((JobStatusBreakLoopFilter)parseStatusFilter.ExternalFilter).JobStatusOutputVariableName = BreakParameterName;
        ((JobStatusBreakLoopFilter)parseStatusFilter.ExternalFilter).StoreOutput = true;
        ParameterExternalFilter parseSuccessFilter = new ParameterExternalFilter();
        parseSuccessFilter.Order = 2;
        parseSuccessFilter.TokenMapping.clear();
        parseSuccessFilter.ExternalFilter = new JobStatusSuccessFilter();
        ((JobStatusSuccessFilter)parseSuccessFilter.ExternalFilter).JobStatusVariableName = ndtJobStatus.Name;
        ((JobStatusSuccessFilter)parseSuccessFilter.ExternalFilter).JobStatusOutputVariableName = SuccessParameterName;
        ((JobStatusSuccessFilter)parseSuccessFilter.ExternalFilter).StoreOutput = true;
        ParameterExternalFilter parseLoggingInfoFilter = new ParameterExternalFilter();
        parseLoggingInfoFilter.Order = 3;
        parseLoggingInfoFilter.TokenMapping.clear();
        parseLoggingInfoFilter.ExternalFilter = new JobLogInfoFilter();
        ((JobLogInfoFilter)parseLoggingInfoFilter.ExternalFilter).JobLogInfoVariableName = LoggingOutputVariableID;
        ((JobLogInfoFilter)parseLoggingInfoFilter.ExternalFilter).PlanNodeID = StatusCheckNodeID;
        FilteredInParameter procParam = new FilteredInParameter();
        procParam.Filters.add(statusFilter);
        procParam.Filters.add(parseStatusFilter);
        procParam.Filters.add(parseSuccessFilter);
        procParam.Filters.add(parseLoggingInfoFilter);
        proc.Parameters.add(procParam);
        return proc;
    }

    private ShellPlanElement CompressOutput(String compressedName, String OutputDirectory) throws WorkflowValidationException {
        try {
            ShellPlanElement sts = new ShellPlanElement();
            sts.Command = "/bin/tar";
            sts.SetName("tar");
            String glite_location_string = this.GridUINode.getExtension("glite.glite_location");
            if (glite_location_string == null || glite_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            String globus_location_string = this.GridUINode.getExtension("glite.globus_location");
            if (globus_location_string == null || globus_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            sts.Environment.add(new EnvironmentKeyValue("X509_USER_PROXY", this.Resources.GetUserProxyResource().Key));
            sts.Environment.add(new EnvironmentKeyValue("GLOBUS_LOCATION", globus_location_string));
            sts.Triggers.clear();
            sts.ExitCodeErrors.add(AdaptorUtils.GetExitCodeMapping(0, "Could not retrieve job output", ExceptionExitCodeMaping.MapType.NotEqual));
            sts.StdErrIsFile = false;
            sts.StdErrParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            sts.StdExitValueParameter = AdaptorUtils.GetOutPrameter(this.Plan);
            sts.StdInIsFile = false;
            sts.StdInParameter = null;
            sts.StdOutIsFile = false;
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("-cvf", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(OutputDirectory + "/" + compressedName + ".tar", this.Plan), true));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(OutputDirectory, this.Plan), true));
            return sts;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private ShellPlanElement CancelJob(String jobIDFile) throws WorkflowValidationException {
        try {
            ShellPlanElement sts = new ShellPlanElement();
            sts.SetName("glite-wms-job-cancel");
            String glite_location_string = this.GridUINode.getExtension("glite.glite_location");
            if (glite_location_string == null || glite_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            String globus_location_string = this.GridUINode.getExtension("glite.globus_location");
            if (globus_location_string == null || globus_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            sts.Command = glite_location_string + "/bin/glite-wms-job-cancel";
            sts.Environment.add(new EnvironmentKeyValue("X509_USER_PROXY", this.Resources.GetUserProxyResource().Key));
            sts.Environment.add(new EnvironmentKeyValue("GLOBUS_LOCATION", globus_location_string));
            sts.Triggers.clear();
            sts.ExitCodeErrors.add(AdaptorUtils.GetExitCodeMapping(0, "Could not cancel the job", ExceptionExitCodeMaping.MapType.NotEqual));
            sts.StdErrIsFile = false;
            sts.StdErrParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            sts.StdExitValueParameter = AdaptorUtils.GetOutPrameter(this.Plan);
            sts.StdInIsFile = false;
            sts.StdInParameter = null;
            sts.StdOutIsFile = false;
            sts.StdOutParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("--noint", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("-i", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(jobIDFile, this.Plan), true));
            return sts;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private ShellPlanElement CheckStatus(String jobIDFile, String OutputVariableID) throws WorkflowValidationException {
        try {
            ShellPlanElement sts = new ShellPlanElement();
            String glite_location_string = this.GridUINode.getExtension("glite.glite_location");
            if (glite_location_string == null || glite_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            String globus_location_string = this.GridUINode.getExtension("glite.globus_location");
            if (globus_location_string == null || globus_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            sts.Command = glite_location_string + "/bin/glite-wms-job-status";
            sts.SetName("glite-wms-job-status");
            sts.Environment.add(new EnvironmentKeyValue("X509_USER_PROXY", this.Resources.GetUserProxyResource().Key));
            sts.Environment.add(new EnvironmentKeyValue("GLOBUS_LOCATION", globus_location_string));
            ContingencyTrigger trig = new ContingencyTrigger();
            trig.IsFullNameOfError = false;
            trig.TriggeringError = null;
            trig.Reaction = new ContingencyReactionRetry();
            ((ContingencyReactionRetry)trig.Reaction).NumberOfRetries = this.RetryOnErrorTimes;
            ((ContingencyReactionRetry)trig.Reaction).RetryInterval = this.RetryOnErrorPeriod;
            sts.Triggers.add(trig);
            sts.ExitCodeErrors.add(AdaptorUtils.GetExitCodeMapping(0, "Could not check status of the job", ExceptionExitCodeMaping.MapType.NotEqual));
            sts.StdErrIsFile = false;
            sts.StdErrParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            sts.StdExitValueParameter = AdaptorUtils.GetOutPrameter(this.Plan);
            sts.StdInIsFile = false;
            sts.StdInParameter = null;
            sts.StdOutIsFile = false;
            sts.StdOutParameter = AdaptorUtils.GetInOutPrameter(OutputVariableID, this.Plan);
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("-i", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(jobIDFile, this.Plan), true));
            return sts;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private ShellPlanElement RetrieveOutput(String jobIDFile, String OutputDirectory) throws WorkflowValidationException {
        try {
            ShellPlanElement sts = new ShellPlanElement();
            String glite_location_string = this.GridUINode.getExtension("glite.glite_location");
            if (glite_location_string == null || glite_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            String globus_location_string = this.GridUINode.getExtension("glite.globus_location");
            if (globus_location_string == null || globus_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            sts.Command = glite_location_string + "/bin/glite-wms-job-output";
            sts.SetName("glite-wms-job-output");
            sts.Environment.add(new EnvironmentKeyValue("X509_USER_PROXY", this.Resources.GetUserProxyResource().Key));
            sts.Environment.add(new EnvironmentKeyValue("GLOBUS_LOCATION", globus_location_string));
            logger.debug("X509_USER_PROXY env var: " + this.Resources.GetUserProxyResource().Key);
            logger.debug("GLOBUS_LOCATIOIN env var: " + globus_location_string);
            sts.Triggers.clear();
            sts.ExitCodeErrors.add(AdaptorUtils.GetExitCodeMapping(0, "Could not retrieve job output", ExceptionExitCodeMaping.MapType.NotEqual));
            sts.StdErrIsFile = false;
            sts.StdErrParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            sts.StdExitValueParameter = AdaptorUtils.GetOutPrameter(this.Plan);
            sts.StdInIsFile = false;
            sts.StdInParameter = null;
            sts.StdOutIsFile = false;
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("--noint", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("--nosubdir", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("--dir", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(OutputDirectory, this.Plan), true));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("-i", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(jobIDFile, this.Plan), true));
            return sts;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private ShellPlanElement CheckLoggingInfo(String jobIDFile, String OutputVariableID) throws WorkflowValidationException {
        try {
            ShellPlanElement sts = new ShellPlanElement();
            String glite_location_string = this.GridUINode.getExtension("glite.glite_location");
            if (glite_location_string == null || glite_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            String globus_location_string = this.GridUINode.getExtension("glite.globus_location");
            if (globus_location_string == null || globus_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            sts.Command = glite_location_string + "/bin/glite-wms-job-logging-info";
            sts.SetName("glite-wms-job-logging-info");
            sts.Environment.add(new EnvironmentKeyValue("X509_USER_PROXY", this.Resources.GetUserProxyResource().Key));
            sts.Environment.add(new EnvironmentKeyValue("GLOBUS_LOCATION", globus_location_string));
            ContingencyTrigger trig = new ContingencyTrigger();
            trig.IsFullNameOfError = false;
            trig.TriggeringError = null;
            trig.Reaction = new ContingencyReactionRetry();
            ((ContingencyReactionRetry)trig.Reaction).NumberOfRetries = this.RetryOnErrorTimes;
            ((ContingencyReactionRetry)trig.Reaction).RetryInterval = this.RetryOnErrorPeriod;
            sts.Triggers.add(trig);
            sts.ExitCodeErrors.add(AdaptorUtils.GetExitCodeMapping(0, "Could not check logging info of the job", ExceptionExitCodeMaping.MapType.NotEqual));
            sts.StdErrIsFile = false;
            sts.StdErrParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            sts.StdExitValueParameter = AdaptorUtils.GetOutPrameter(this.Plan);
            sts.StdInIsFile = false;
            sts.StdInParameter = null;
            sts.StdOutIsFile = false;
            sts.StdOutParameter = AdaptorUtils.GetInOutPrameter(OutputVariableID, this.Plan);
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("-i", this.Plan)));
            sts.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(jobIDFile, this.Plan), true));
            return sts;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private ShellPlanElement ConstructSubmitJobElement(String jobIDFile) throws WorkflowValidationException {
        try {
            ShellPlanElement subm = new ShellPlanElement();
            String glite_location_string = this.GridUINode.getExtension("glite.glite_location");
            if (glite_location_string == null || glite_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            String globus_location_string = this.GridUINode.getExtension("glite.globus_location");
            if (globus_location_string == null || globus_location_string.trim().length() == 0) {
                throw new WorkflowValidationException("needed property glite.globus_location set in globus.gateway node");
            }
            subm.Command = glite_location_string + "/bin/glite-wms-job-submit";
            subm.SetName("glite-wms-job-submit");
            subm.Environment.add(new EnvironmentKeyValue("X509_USER_PROXY", this.Resources.GetUserProxyResource().Key));
            subm.Environment.add(new EnvironmentKeyValue("GLOBUS_LOCATION", globus_location_string));
            subm.Triggers.clear();
            subm.ExitCodeErrors.add(AdaptorUtils.GetExitCodeMapping(0, "Could not submit the job", ExceptionExitCodeMaping.MapType.NotEqual));
            subm.StdErrIsFile = false;
            subm.StdErrParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            subm.StdExitValueParameter = AdaptorUtils.GetOutPrameter(this.Plan);
            subm.StdInIsFile = false;
            subm.StdInParameter = null;
            subm.StdOutIsFile = false;
            subm.StdOutParameter = AdaptorUtils.GetInOutPrameter(this.Plan);
            if (this.Resources.GetConfigResource() != null) {
                subm.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("--config", this.Plan)));
                subm.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(this.Resources.GetConfigResource().Key, this.Plan), true));
            }
            subm.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("-a", this.Plan)));
            subm.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter("--output", this.Plan)));
            subm.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(jobIDFile, this.Plan), true));
            subm.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)AdaptorUtils.GetInParameter(this.Resources.GetJDLResource().Key, this.Plan), true));
            return subm;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private BoundaryPlanElement ConstructBoundaryElement() throws WorkflowEnvironmentException {
        BoundaryPlanElement bound = new BoundaryPlanElement();
        this.Plan.Root = bound;
        bound.CleanUpLocalFiles.clear();
        bound.Triggers.clear();
        bound.Config = this.GetBoundaryConfig();
        bound.Isolation = new BoundaryIsolationInfo();
        bound.Isolation.Isolate = true;
        bound.Isolation.CleanUp = true;
        bound.Isolation.BaseDir = new SimpleInOutParameter();
        NamedDataType ndtIsolationBaseDirParameter = new NamedDataType();
        ndtIsolationBaseDirParameter.IsAvailable = false;
        ndtIsolationBaseDirParameter.Token = ndtIsolationBaseDirParameter.Name = UUID.randomUUID().toString();
        ndtIsolationBaseDirParameter.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtIsolationBaseDirParameter);
        ((SimpleInOutParameter)bound.Isolation.BaseDir).VariableName = ndtIsolationBaseDirParameter.Name;
        ExecutionAttachment att = new ExecutionAttachment();
        att.CleanUpRestored = true;
        att.LocationType = ExecutionAttachment.AttachmentLocation.LocalFile;
        att.LocationValue = this.Resources.GetUserProxyResource().Value;
        att.RestoreLocationValue = this.Resources.GetUserProxyResource().Key;
        att.Permissions = "0600";
        bound.Attachments.add(att);
        return bound;
    }

    private BoundaryConfig GetBoundaryConfig() throws WorkflowEnvironmentException {
        try {
            this.GridUINode = InformationSystem.GetMatchingNode(null, (String)"glite.gateway == true", (EnvHintCollection)this.Hints);
            if (this.GridUINode == null) {
                throw new WorkflowEnvironmentException("Could not find appropriate grid UI node to host execution");
            }
            logger.info("Selected Execution Engine: " + this.GridUINode.getExtension("hostname") + ":" + this.GridUINode.getExtension("pe2ng.port"));
        }
        catch (Exception ex) {
            throw new WorkflowEnvironmentException("Could not retrieve environment information from Information System", ex);
        }
        BoundaryConfig Config = new BoundaryConfig();
        Config.HostName = this.GridUINode.getExtension("hostname");
        Config.Port = Integer.parseInt(this.GridUINode.getExtension("pe2ng.port"));
        Config.NozzleConfig = new TCPServerNozzleConfig(false, 0);
        return Config;
    }

    private FileTransferPlanElement CreateStoreFileElement(String FileName) throws WorkflowValidationException {
        try {
            FileTransferPlanElement ftr = new FileTransferPlanElement();
            ftr.Direction = FileTransferPlanElement.TransferDirection.Store;
            ftr.Input = AdaptorUtils.GetInParameter(FileName, this.Plan);
            ftr.IsExecutable = false;
            ftr.MoveTo = null;
            ftr.Output = AdaptorUtils.GetOutPrameter(this.Plan);
            return ftr;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct submit job script", ex);
        }
    }

    private FileTransferPlanElement CreateStoreFileElement(AttachedGridResource attachment, String OutputDirectory) throws WorkflowValidationException {
        try {
            FileTransferPlanElement ftr = new FileTransferPlanElement();
            ftr.Direction = FileTransferPlanElement.TransferDirection.Store;
            ftr.Input = AdaptorUtils.GetInParameter(OutputDirectory + "/" + attachment.Key, this.Plan);
            if (attachment.ResourceLocationType == AttachedGridResource.AttachedResourceType.Reference) {
                boolean slashFound = attachment.Value.charAt(attachment.Value.length() - 1) == '/';
                ftr.OutputStoreMode = FileTransferPlanElement.StoreMode.Url;
                ftr.StoreUrlLocation = attachment.Value + (slashFound ? "" : "/") + (this.ExecutionId != null ? this.ExecutionId + "." : "") + attachment.Key;
                ftr.accessInfo.port = attachment.accessInfo.port;
                ftr.accessInfo.userId = attachment.accessInfo.userId;
                ftr.accessInfo.password = attachment.accessInfo.password;
            }
            ftr.IsExecutable = false;
            ftr.MoveTo = null;
            SimpleOutParameter outParam = AdaptorUtils.GetOutPrameter(this.Plan);
            ftr.Output = outParam;
            OutputSandboxGridResource out = new OutputSandboxGridResource();
            out.Key = attachment.Key;
            out.VariableID = outParam.VariableName;
            this.OutputResources.add(out);
            return ftr;
        }
        catch (ExecutionValidationException ex) {
            throw new WorkflowValidationException("Could not construct store file element", ex);
        }
    }

    private FileTransferPlanElement CreateRetrieveFileElement(AttachedGridResource attachment) throws WorkflowValidationException {
        FileTransferPlanElement ftr = new FileTransferPlanElement();
        ftr.Direction = FileTransferPlanElement.TransferDirection.Retrieve;
        ftr.Input = new SimpleInParameter();
        ftr.IsExecutable = false;
        NamedDataType ndtAttachment = new NamedDataType();
        ndtAttachment.IsAvailable = true;
        ndtAttachment.Token = ndtAttachment.Name = UUID.randomUUID().toString();
        ndtAttachment.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtAttachment);
        try {
            ((DataTypeString)ndtAttachment.Value).SetValue((Object)attachment.StorageSystemID);
        }
        catch (Exception ex) {
            throw new WorkflowValidationException("Could not create execution plan", ex);
        }
        ((SimpleInParameter)ftr.Input).VariableName = ndtAttachment.Name;
        ftr.Output = new SimpleOutParameter();
        NamedDataType ndtRetrievedAttachment = new NamedDataType();
        ndtRetrievedAttachment.IsAvailable = false;
        ndtRetrievedAttachment.Name = UUID.randomUUID().toString();
        ndtRetrievedAttachment.Token = ndtAttachment.Name;
        ndtRetrievedAttachment.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtRetrievedAttachment);
        ((SimpleOutParameter)ftr.Output).VariableName = ndtRetrievedAttachment.Name;
        ftr.MoveTo = new SimpleInParameter();
        NamedDataType ndtRename = new NamedDataType();
        ndtRename.IsAvailable = true;
        ndtRename.Name = UUID.randomUUID().toString();
        ndtRename.Token = ndtAttachment.Name;
        ndtRename.Value = new DataTypeString();
        String RenameTo = attachment.Key;
        if (RenameTo == null || RenameTo.trim().length() == 0) {
            throw new WorkflowValidationException("Defined resource name is not valid");
        }
        try {
            ((DataTypeString)ndtRename.Value).SetValue((Object)RenameTo);
        }
        catch (Exception ex) {
            throw new WorkflowValidationException("Could not create execution plan", ex);
        }
        this.Plan.Variables.Add(ndtRename);
        ((SimpleInParameter)ftr.MoveTo).VariableName = ndtRename.Name;
        return ftr;
    }
}

