/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.wrappers;

import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterSerializationFilter;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSSOAPArgument;
import gr.uoa.di.madgik.execution.plan.element.variable.FilteredInParameter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.workflow.utils.SOAPBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceWrapper {
    private HashMap<Variables, String> variableNames = new HashMap();
    private Map<Variables, NamedDataType> variables = new EnumMap<Variables, NamedDataType>(Variables.class);
    private SOAPBuilder soapBuilder;
    private Map<String, String> wsVars;
    private static Logger logger = LoggerFactory.getLogger(ServiceWrapper.class);

    public ServiceWrapper(String inEnvelope, Map<String, String> wsVars) {
        this.wsVars = wsVars;
        HashMap<String, String> inputs = new HashMap<String, String>();
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(inEnvelope));
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                inputs.put((String)entry.getKey(), (String)entry.getValue());
            }
            if (wsVars != null) {
                for (Map.Entry<Object, Object> entry : wsVars.entrySet()) {
                    logger.info("Added a variable from another service:  " + (String)entry.getKey() + " = " + (String)entry.getValue());
                    inputs.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (Map.Entry<Object, Object> entry : inputs.entrySet()) {
                logger.info("INPUT:  " + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Can not find WS SOAP input file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while reading WS SOAP input file", (Throwable)e);
        }
        this.soapBuilder = new SOAPBuilder(inputs, new String[0]);
        this.setVariableNames();
        this.setVariableValues(inputs);
    }

    public String getInvocationResult() {
        return this.variableNames.get((Object)Variables.InvocationResult);
    }

    public String getOutputLocator() {
        return this.variableNames.get((Object)Variables.OutputLocator);
    }

    public String getOutputLocatorExtractionExpressionVariable() {
        return this.variableNames.get((Object)Variables.OutputLocatorExtractionExpression);
    }

    private void setVariableNames() {
        this.variableNames.put(Variables.ServiceEndpoint, UUID.randomUUID().toString());
        this.variableNames.put(Variables.OutputLocator, UUID.randomUUID().toString());
        this.variableNames.put(Variables.OutputLocatorExtractionExpression, UUID.randomUUID().toString());
        this.variableNames.put(Variables.InvocationResult, UUID.randomUUID().toString());
        this.variableNames.put(Variables.SOAPTemplate, UUID.randomUUID().toString());
    }

    private void setVariableValues(Map<String, String> map) {
        try {
            this.variables.put(Variables.ServiceEndpoint, DataTypeUtils.GetNamedDataType((boolean)true, (String)this.variableNames.get((Object)Variables.ServiceEndpoint), null, (IDataType.DataTypes)IDataType.DataTypes.String, (Object)map.get("To")));
            this.variables.put(Variables.OutputLocator, DataTypeUtils.GetNamedDataType((boolean)true, (String)this.variableNames.get((Object)Variables.OutputLocator), (String)this.variableNames.get((Object)Variables.OutputLocator), (IDataType.DataTypes)IDataType.DataTypes.String, null));
            this.variables.put(Variables.OutputLocatorExtractionExpression, DataTypeUtils.GetNamedDataType((boolean)true, (String)this.variableNames.get((Object)Variables.OutputLocatorExtractionExpression), null, (IDataType.DataTypes)IDataType.DataTypes.String, (Object)this.getOutputLocatorExtractionExpression()));
            this.variables.put(Variables.InvocationResult, DataTypeUtils.GetNamedDataType((boolean)true, (String)this.variableNames.get((Object)Variables.InvocationResult), null, (IDataType.DataTypes)IDataType.DataTypes.String, null));
            this.variables.put(Variables.SOAPTemplate, DataTypeUtils.GetNamedDataType((boolean)true, (String)this.variableNames.get((Object)Variables.SOAPTemplate), null, (IDataType.DataTypes)IDataType.DataTypes.String, (Object)this.soapBuilder.getSOAP()));
        }
        catch (ExecutionValidationException e) {
            logger.error("Error while setting variable values", (Throwable)e);
        }
    }

    private String getOutputLocatorExtractionExpression() {
        return this.soapBuilder.getOutputLocatorExtractionExpression();
    }

    public String getActionOperation() {
        String[] table = this.soapBuilder.getAction().split("/");
        return table[table.length - 2] + "/" + table[table.length - 1];
    }

    public String getActionURN() {
        return this.soapBuilder.getAction();
    }

    public WSSOAPArgument getQueryEnvelopeArgument() {
        WSSOAPArgument queryEnvelop = new WSSOAPArgument();
        queryEnvelop.Order = 0;
        queryEnvelop.ArgumentName = "full envelop";
        FilteredInParameter filterQueryEnvelopInput = new FilteredInParameter();
        ParameterSerializationFilter instantiateQueryEnvelopInput = new ParameterSerializationFilter();
        instantiateQueryEnvelopInput.Order = 0;
        instantiateQueryEnvelopInput.StoreOutput = false;
        instantiateQueryEnvelopInput.StoreOutputVariableName = null;
        instantiateQueryEnvelopInput.FilteredVariableName = this.variableNames.get((Object)Variables.SOAPTemplate);
        for (Map.Entry<String, String> entry : this.wsVars.entrySet()) {
            instantiateQueryEnvelopInput.TokenProvidingVariableNames.add(entry.getValue());
        }
        filterQueryEnvelopInput.Filters.add(instantiateQueryEnvelopInput);
        queryEnvelop.Parameter = filterQueryEnvelopInput;
        return queryEnvelop;
    }

    public void addVariablesToPlan(ExecutionPlan plan) {
        plan.Variables.Add(this.variables.get((Object)Variables.ServiceEndpoint));
        plan.Variables.Add(this.variables.get((Object)Variables.OutputLocator));
        plan.Variables.Add(this.variables.get((Object)Variables.OutputLocatorExtractionExpression));
        plan.Variables.Add(this.variables.get((Object)Variables.InvocationResult));
        plan.Variables.Add(this.variables.get((Object)Variables.SOAPTemplate));
    }

    public String getServiceEndpoint() {
        return this.variableNames.get((Object)Variables.ServiceEndpoint);
    }

    public NamedDataType getOutputVariable() {
        return this.variables.get((Object)Variables.OutputLocator);
    }

    public static void main(String[] args) {
        new ServiceWrapper("/home/panagiotis/sotrios/inputs.txt", null);
    }

    public static enum Variables {
        ServiceEndpoint,
        SOAPTemplate,
        OutputLocatorExtractionExpression,
        InvocationResult,
        OutputLocator;

    }
}

