/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.workflowengine.service;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.notificationhandling.NotificationHandling;
import gr.uoa.di.madgik.reporting.ReportingFramework;
import gr.uoa.di.madgik.ss.StorageSystem;
import gr.uoa.di.madgik.workflow.directory.ExecutionDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;

public class ServiceContext
extends GCUBEServiceContext {
    private static Logger logger = Logger.getLogger(ServiceContext.class.getName());
    private static ServiceContext Context = null;
    private static final Object lockMe = new Object();

    private ServiceContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext GetServiceContext() {
        if (Context == null) {
            Object object = lockMe;
            synchronized (object) {
                if (Context == null) {
                    Context = new ServiceContext();
                }
            }
        }
        return Context;
    }

    protected String getJNDIName() {
        return "execution/workflowengine";
    }

    protected void onReady() throws Exception {
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("StorageSystemDeleteOnExit", new EnvHint(Boolean.TRUE.toString())));
        Hints.AddHint(new NamedEnvHint("StorageSystemLocalFileSystemBufferPath", new EnvHint(this.GetLocalFSBuffer())));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorCount", new EnvHint(Integer.toString(this.GetRetryOnErrorTimes()))));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorInterval", new EnvHint(Integer.toString(this.GetRetryOnErrorInterval()))));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint(this.GetInformationSystemRIContainerServiceClass())));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint(this.GetInformationSystemRIContainerServiceName())));
        String nodeSelector = this.GetNodeSelector();
        if (nodeSelector != null) {
            Hints.AddHint(new NamedEnvHint("NodeSelector", new EnvHint(nodeSelector)));
        }
        Hints.AddHint(new NamedEnvHint("ReportingFrameworkRIContainerServiceClass", new EnvHint(this.GetReportingFrameworkRIContainerServiceClass())));
        Hints.AddHint(new NamedEnvHint("ReportingFrameworkRIContainerServiceName", new EnvHint(this.GetReportingFrameworkRIContainerServiceName())));
        Hints.AddHint(new NamedEnvHint("ReportingFrameworkRIContainerServiceJNDIName", new EnvHint(this.GetReportingFrameworkRIContainerServiceJNDIName())));
        Hints.AddHint(new NamedEnvHint("GCubeGHN", new EnvHint(this.GetHostName())));
        this.InitLogging();
        this.InitWorkflowEngineEnvironment(Hints);
        String JMSPROVIDER = this.GetJMSProvider();
        NotificationHandling.Init((String)JMSPROVIDER, (EnvHintCollection)Hints);
        super.onReady();
    }

    private void InitWorkflowEngineEnvironment(EnvHintCollection Hints) throws Exception {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initalizing Engine Environment");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initalizing TCPManager");
        }
        List<PortRange> range = this.GetPortRanges();
        for (PortRange r : range) {
            if (!logger.isLoggable(Level.INFO) || !logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "port range : " + r.GetStart() + "-" + r.GetEnd());
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(this.GetHostName(), range, this.GetUseRandomPort().booleanValue()));
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Registering entries");
        }
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngCallbackTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ChannelTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initializing Execution Engine");
        }
        ExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0));
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Collecting Environment Hints");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initializing Information System Provider");
        }
        InformationSystem.Init((String)this.GetInformationSystemProvider(), (EnvHintCollection)Hints);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initializing Storage System Provider");
        }
        StorageSystem.Init((String)this.GetStorageSystemProvider(), (EnvHintCollection)Hints);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initializing Reporting Framework Provider");
        }
        ReportingFramework.Init((String)this.GetReportingProvider(), (EnvHintCollection)Hints);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initializing Execution Directory CleanUp");
        }
        ExecutionDirectory.SetCleanupPeriod((long)this.GetExecutionDirectoryCleanup());
    }

    private void InitLogging() throws SecurityException, IOException {
        InputStream is;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Initalizing Logging Environment");
        }
        if ((is = ServiceContext.class.getResourceAsStream(this.GetLoggingConfigLocation())) == null) {
            throw new IllegalStateException("Could not find logging config location " + this.GetLoggingConfigLocation());
        }
        LogManager.getLogManager().readConfiguration(is);
        is.close();
    }

    private String GetLocalFSBuffer() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("localFSBuffer", new boolean[]{false});
        if (tmpObj == null) {
            return "";
        }
        return tmpObj.toString();
    }

    private long GetExecutionDirectoryCleanup() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("executionDirectoryCleanup", new boolean[]{false});
        if (tmpObj == null) {
            return 0L;
        }
        try {
            return Long.parseLong(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private int GetRetryOnErrorInterval() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("retryOnErrorInterval", new boolean[]{false});
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int GetRetryOnErrorTimes() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("retryOnErrorTimes", new boolean[]{false});
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String GetInformationSystemProvider() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("providerInformationName", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetStorageSystemProvider() {
        Object storageProviderObj = ServiceContext.GetServiceContext().getProperty("providerStorageName", new boolean[]{false});
        if (storageProviderObj == null) {
            return null;
        }
        return storageProviderObj.toString();
    }

    private String GetJMSProvider() {
        Object JMSProviderObj = ServiceContext.GetServiceContext().getProperty("JMSProviderName", new boolean[]{false});
        if (JMSProviderObj == null) {
            return null;
        }
        return JMSProviderObj.toString();
    }

    private String GetReportingProvider() {
        Object reportingProviderObj = ServiceContext.GetServiceContext().getProperty("providerReportingName", new boolean[]{false});
        if (reportingProviderObj == null) {
            return null;
        }
        return reportingProviderObj.toString();
    }

    private String GetInformationSystemRIContainerServiceClass() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("informationSystemRIContainerServiceClass", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetInformationSystemRIContainerServiceName() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("informationSystemRIContainerServiceName", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetNodeSelector() {
        Object nodeSelectorObj = ServiceContext.GetServiceContext().getProperty("nodeSelector, false)", new boolean[0]);
        if (nodeSelectorObj == null) {
            return null;
        }
        return nodeSelectorObj.toString();
    }

    private String GetReportingFrameworkRIContainerServiceClass() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("reportingFrameworkRIContainerServiceClass", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetReportingFrameworkRIContainerServiceName() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("reportingFrameworkRIContainerServiceName", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetReportingFrameworkRIContainerServiceJNDIName() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("reportingFrameworkRIContainerServiceJNDIName", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private List<PortRange> GetPortRanges() {
        Object portRangesObj = ServiceContext.GetServiceContext().getProperty("portRanges", new boolean[]{false});
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "port ranges retrieved is " + portRangesObj);
        }
        if (portRangesObj == null) {
            return new ArrayList<PortRange>();
        }
        String portRangesStr = portRangesObj.toString();
        String[] rangePairs = portRangesStr.trim().split("-");
        ArrayList<PortRange> ranges = new ArrayList<PortRange>();
        for (String pair : rangePairs) {
            String[] pairSplit = pair.trim().split(",");
            if (pairSplit.length != 2) {
                return new ArrayList<PortRange>();
            }
            String pairStart = pairSplit[0].trim();
            if (!pairStart.startsWith("{")) {
                return new ArrayList<PortRange>();
            }
            pairStart = pairStart.substring(1).trim();
            String pairEnd = pairSplit[1].trim();
            if (!pairEnd.endsWith("}")) {
                return new ArrayList<PortRange>();
            }
            pairEnd = pairEnd.substring(0, pairEnd.length() - 1).trim();
            int beginPair = 0;
            int endPair = 0;
            try {
                beginPair = Integer.parseInt(pairStart.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            try {
                endPair = Integer.parseInt(pairEnd.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            ranges.add(new PortRange(beginPair, endPair));
        }
        return ranges;
    }

    private Boolean GetUseRandomPort() {
        Object portRandomObj = ServiceContext.GetServiceContext().getProperty("useRandomPort", new boolean[]{false});
        if (portRandomObj == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(portRandomObj.toString().trim());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String GetHostName() {
        return GHNContext.getContext().getHostname();
    }

    private String GetLoggingConfigLocation() {
        Object loggingObj = ServiceContext.GetServiceContext().getProperty("loggingConfigLocation", new boolean[]{false});
        if (loggingObj == null) {
            return null;
        }
        return loggingObj.toString();
    }
}

