<#macro content>
    <!-- D4Science footer -->
    <footer style="${properties.footerStyle!}">
        <div>
            <a href="${properties.linkTerms!}">Terms of Use</a> | 
            <a href="${properties.linkCookies!'#'}">Cookies Policy</a> | 
            <a href="${properties.linkPrivacy!'#'}" target="_blank">Privacy Policy</a> | 
            <#if properties.linkProject?has_content><a href="${properties.linkProject!}" target="_blank">${properties.descrProject!}</a></#if>
        </div>
        <#if properties.ECLogo?has_content && properties.ECLogo='yes'>
            <div style="display: flex; padding-top: 10px; justify-content: space-between; gap: 10px;">
                <#if properties.footerRow?has_content><div>${kcSanitize(properties.footerRow)?no_esc}</div></#if>
                <div style="align-self: center;">
                    <a href="${properties.ECLogoLink!}" target="_blank">
                        <img class="float-right" alt="${properties.ECLogoAlt!}" src="${properties.ECLogoSrc!}" style="${properties.ECLogoStyle!}">
                    </a>
                </div>
            </div>
        <#else>
            <#if properties.footerRow?has_content><div style="padding-top: 10px;">${kcSanitize(properties.footerRow)?no_esc}</div></#if>
        </#if>
    </footer>
    <script>
      // Replacing twitter icon that is not still available on this fa bundle
      let twitterUrl = '${url.resourcesPath}/img/twitter.svg';
      let ieleTwitter = document.querySelectorAll('.fa-twitter');
      ieleTwitter.forEach(e => {
        e.classList.remove('fa-twitter');
        e.innerHTML = '<img src="' + twitterUrl + '" style="width: 80%; height: 80%;" />';
      })
      // Replacing orcid icon that is not still available on this fa bundle
      let orchidUrl = '${url.resourcesPath}/img/orcid.svg';
      let ieleOrcid = document.querySelectorAll('.fa-orcid');
      ieleOrcid.forEach(e => {
        e.classList.remove('fa-orcid');
        e.innerHTML = '<img src="' + orchidUrl + '" style="width: 80%; height: 80%;" />';
      })
    </script>
</#macro>
