/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.keycloack;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.common.is.InfrastrctureServiceClient;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.service.idm.keycloack.KeycloackApiClient;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KkClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(KkClientFactory.class);
    private static final String RUNTIME_RESOURCE_NAME = "IAM";
    private static final String CATEGORY = "Service";
    private static final String END_POINT_NAME = "d4science";
    private static final boolean IS_ROOT_SERVICE = true;
    private IsServerConfig config;
    private Secret secret;
    private static KkClientFactory singleton = new KkClientFactory();

    public static KkClientFactory getSingleton() {
        if (singleton == null) {
            singleton = new KkClientFactory();
        }
        return singleton;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void setConfig(IsServerConfig configuration) {
        this.config = configuration;
    }

    public Secret getSecretForInfrastructure() {
        return InfrastrctureServiceClient.getSecretForInfrastructure();
    }

    public IsServerConfig fetchIsConfig() throws InternalServerErrorException {
        if (this.secret == null) {
            this.secret = this.getSecretForInfrastructure();
        }
        return this.fetchIsConfig(this.secret);
    }

    public IsServerConfig fetchIsConfig(Secret secret) throws InternalServerErrorException {
        if (secret == null) {
            throw new InternalServerErrorException("null secret for fetchIsConfig");
        }
        try {
            IsServerConfig cfg = InfrastrctureServiceClient.serviceConfigFromIS((String)"IAM", (String)"Service", (String)"d4science", (boolean)true, (Secret)secret);
            logger.info("KeycloakAPICredentials object built {} - {}", (Object)cfg.getServerUrl(), (Object)cfg.getName());
            return cfg;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public KeycloackApiClient createtKeycloakInstance(String context) {
        if (this.secret == null) {
            this.secret = this.getSecretForInfrastructure();
        }
        if (this.config == null) {
            this.config = this.fetchIsConfig(this.secret);
        }
        return KkClientFactory.createtKeycloakInstance((IsServerConfig)this.config, (String)context);
    }

    public static KeycloackApiClient createtKeycloakInstance(IsServerConfig config, String context) {
        Keycloak kclient = KeycloakBuilder.builder().serverUrl(config.getServerUrl()).realm(config.getName()).grantType(config.getGrantType()).clientId(config.getClientId()).clientSecret(config.getClientSecret()).build();
        return new KeycloackApiClient(kclient, config.getName(), context);
    }

    public RealmResource getKKRealm() {
        String ctx = SecretManagerProvider.get().getContext();
        return this.getKKRealm(ctx);
    }

    public RealmResource getKKRealm(String ctx) {
        logger.info("Searching client for contex");
        KeycloackApiClient keycloackApiClient = this.createtKeycloakInstance(ctx);
        RealmResource realm = keycloackApiClient.kclient.realm(keycloackApiClient.realmName);
        return realm;
    }

    public ClientResource getKKClient() {
        String ctx = SecretManagerProvider.get().getContext();
        return this.getKKClient(ctx);
    }

    public ClientResource getKKClient(String ctx) {
        logger.info("Searching client for contex");
        RealmResource realm = this.getKKRealm(ctx);
        List clients = realm.clients().findByClientId(KkClientFactory.encodeClientIdContext((String)ctx));
        if (clients.size() == 0) {
            return null;
        }
        String id = ((ClientRepresentation)clients.get(0)).getId();
        return realm.clients().get(id);
    }

    public ClientResource getKKClientById(String clientId) {
        if (clientId == null) {
            return KkClientFactory.getSingleton().getKKClient();
        }
        RealmResource realmResource = this.getKKRealm();
        List clients = realmResource.clients().findByClientId(clientId);
        if (clients.size() == 0) {
            throw new NotFoundException();
        }
        String id = ((ClientRepresentation)clients.get(0)).getId();
        return realmResource.clients().get(id);
    }

    public static String encodeClientIdContext(String context) {
        return context.replace("/", "%2F");
    }
}

