/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm;

import jakarta.ws.rs.InternalServerErrorException;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.common.is.InfrastrctureServiceClient;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClientFactory.class);
    protected IsServerConfig config;
    protected Secret secret;

    public abstract String getRuntimeResourceName();

    public abstract String getCategory();

    public abstract String getEndPointName();

    public abstract boolean isRootService();

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void setConfig(IsServerConfig configuration) {
        this.config = configuration;
    }

    public IsServerConfig fetchIsConfig() throws InternalServerErrorException {
        if (this.getSecret() == null) {
            this.setSecret(AbstractClientFactory.getSecretForInfrastructure());
        }
        return this.fetchIsConfig(this.getSecret());
    }

    public IsServerConfig fetchIsConfig(Secret secret) throws InternalServerErrorException {
        if (secret == null) {
            throw new InternalServerErrorException("null secret for fetchIsConfig");
        }
        try {
            IsServerConfig cfg = InfrastrctureServiceClient.serviceConfigFromIS((String)this.getRuntimeResourceName(), (String)this.getCategory(), (String)this.getEndPointName(), (boolean)this.isRootService(), (Secret)secret);
            logger.info("KeycloakAPICredentials object built {} - {}", (Object)cfg.getServerUrl(), (Object)cfg.getName());
            return cfg;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static Secret getSecretForInfrastructure() {
        ApplicationContext ctx = ContextProvider.get();
        ContainerContext container = ctx.container();
        ContainerConfiguration configuration = container.configuration();
        String infra_context = configuration.infrastructure();
        Secret secret = ctx.container().authorizationProvider().getSecretForContext(infra_context);
        return secret;
    }
}

