/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.service.idm.IdMManager;
import org.gcube.service.idm.beans.ResponseBeanMap;
import org.gcube.service.idm.controller.LiferayProfileClient;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=IdMManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
@Path(value="2/people")
public class SocialPeopleAPI {
    private static final Logger logger = LoggerFactory.getLogger(SocialPeopleAPI.class);

    @Produces(value={"application/json"})
    @GET
    @Path(value="profile")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieval of user's profile, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getProfile() {
        ResponseBeanMap responseBean = new ResponseBeanMap();
        Response.Status status = Response.Status.OK;
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        String username = owner.getId();
        String context = secret.getContext();
        if (owner.isApplication()) {
            logger.warn("Trying to access users method via a token different than USER is not allowed");
            throw new ForbiddenException("User's information can only be retrieved through a user token (not qualified)");
        }
        try {
            GCubeUser profile = LiferayProfileClient.getUserProfileByUsername((String)username);
            responseBean.putResult("username", (Object)username);
            responseBean.putResult("avatar", (Object)profile.getUserAvatarURL());
            responseBean.putResult("fullname", (Object)(owner.getFirstName() + " " + owner.getLastName()));
            responseBean.putResult("context", (Object)context);
            responseBean.putResult("roles", (Object)owner.getRoles());
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user's profile", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

