/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowsetParser {
    private static final Logger logger = LoggerFactory.getLogger(RowsetParser.class);
    private static String regexIdxTypeNameRowset = "<ROWSET[^>]*idxType=\"([^\"]*?)\"";
    private static Pattern patternIdxTypeNameRowset = Pattern.compile(regexIdxTypeNameRowset);
    private static String regexLangRowset = "<ROWSET[^>]*lang=\"([^\"]*?)\"";
    private static Pattern patternLangRowset = Pattern.compile(regexLangRowset);
    private static String regexColIDRowset = "<ROWSET[^>]*colID=\"([^\"]*?)\"";
    private static Pattern patternColIDRowset = Pattern.compile(regexColIDRowset);
    private static final String ROWSETFIELD = "Rowset";

    public static String getIdxTypeNameRowset(String rowset) {
        return RowsetParser.getMatchRegex(patternIdxTypeNameRowset, rowset);
    }

    public static String getLangRowset(String rowset) {
        return RowsetParser.getMatchRegex(patternLangRowset, rowset);
    }

    public static String getColIDRowset(String rowset) {
        return RowsetParser.getMatchRegex(patternColIDRowset, rowset);
    }

    private static String getMatchRegex(Pattern pattern, String rowset) {
        Matcher m = pattern.matcher(rowset);
        String match = null;
        try {
            if (m.find()) {
                match = m.group(1).trim();
                return !match.equals("") ? match : null;
            }
        }
        catch (Exception e) {
            logger.error("exception while getting idxType", (Throwable)e);
        }
        return match;
    }

    public static boolean addToFieldInfo(List<String> toBeAdded, String field, String colIDandLang, FullTextIndexType idxType) {
        boolean found = false;
        boolean searchable = false;
        boolean presentable = false;
        for (IndexField idxField : idxType.getFields()) {
            if (!idxField.name.equals(field)) continue;
            found = true;
            searchable = idxField.index;
            presentable = idxField.returned;
            break;
        }
        if (field.equalsIgnoreCase("ObjectID")) {
            searchable = true;
            presentable = false;
        } else if (!found) {
            logger.error("The field: " + field + ", is not declared in the indexType.");
            return false;
        }
        if (searchable) {
            toBeAdded.add(colIDandLang + ":" + "s" + ":" + field);
        }
        if (presentable) {
            toBeAdded.add(colIDandLang + ":" + "p" + ":" + field);
        }
        return true;
    }

    public static String getRowsetFromResult(Record record) throws GRS2RecordDefinitionException, GRS2BufferException {
        return ((StringField)record.getField(ROWSETFIELD)).getPayload();
    }
}

