/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.parser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.gcube.elasticsearch.parser.ElasticSearchParserLexer;
import org.gcube.elasticsearch.parser.ElasticSearchParserParser;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchParser {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchParser.class);
    private RRadaptor adaptor;
    private ElasticSearchParserLexer lexer;
    private ElasticSearchParserParser parser;
    private QueryBuilder q = null;
    private Set<String> sids;

    public ElasticSearchParser(String query, RRadaptor adaptor, Set<String> sids) {
        this.adaptor = adaptor;
        this.sids = sids;
        this.lexer = new ElasticSearchParserLexer((CharStream)new ANTLRStringStream(query));
        this.parser = new ElasticSearchParserParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
    }

    public QueryBuilder parse() {
        if (this.q != null) {
            return this.q;
        }
        try {
            this.q = this.parser.esQuery(this.adaptor);
            if (this.sids != null && !this.sids.isEmpty()) {
                OrFilterBuilder f = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
                for (String sid : this.sids) {
                    f = f.add((FilterBuilder)FilterBuilders.termFilter((String)"sid", (String)sid));
                }
                this.q = QueryBuilders.filteredQuery((QueryBuilder)this.q, (FilterBuilder)f);
            }
            return this.q;
        }
        catch (RecognitionException e) {
            logger.error("Error while parsing: ", (Throwable)e);
            return null;
        }
    }

    public ArrayList<String> getDistincts() {
        return this.parser.distincts;
    }

    public ArrayList<String> getProjects() {
        return this.parser.projects;
    }

    public ArrayList<AbstractMap.SimpleEntry<String, String>> getSortBys() {
        return this.parser.sortbys;
    }

    public Set<String> getCollections() {
        return this.parser.collections;
    }

    public static void main(String[] args) {
        String input = "((geo geosearch \"11 7 20 100\") and ((type exact \"new\") and ((geo geosearch \"-2 -6 8 4\") and ((gDocCollectionLang == \"en\") and (((desci any \"new\") and (gDocCollectionID == \"C\")) or ((abstract exact \"new\") and ((spec any \"new\") or (tech any \"new\"))))))))";
        input = "(((aaaaa == vvv and dfdfdfd = fdfdfda) and paok = paokara) and fdfd=fdfdfd) or dsdsdasd = dsds";
        input = "((((gDocCollectionID == \"c9076f3f-be8d-43e2-9f02-de35e6d8f72c\") and (gDocCollectionLang == \"unknown\"))) and (allIndexes = tuna)) project *";
        input = "((((gDocCollectionID == \"c9076f3f-be8d-43e2-9f02-de35e6d8f72c\") and (gDocCollectionLang == \"unknown\"))) and (allIn = tunaqa)) project 6ef6b515-6bcd-4007-af57-8394595fe584 87c4056b-447e-4c8b-90ee-2661e4bde7de";
        input = "((((gDocCollectionID == \"c9076f3f-be8d-43e2-9f02-de35e6d8f72c\") and (gDocCollectionLang == \"unknown\")) and (allIn = tunaqa)) and (another = other)) project 6ef6b515-6bcd-4007-af57-8394595fe584 87c4056b-447e-4c8b-90ee-2661e4bde7de";
        input = "gDocCollectionID == \"paok\" and gDocCollectionLang == \"paokara\" and aaaaa = fdfds and dfdfdf = fdfd and ssss = aa";
        input = "aaaaa = fdfds and dfdfdf = fdfd and ssss = aa and gDocCollectionID == \"paok\" and gDocCollectionLang == \"paokara\" ";
        input = "gDocCollectionID == \"paok\" and (gDocCollectionLang = \"paokara\" or aaaaa = \"paokara\" or dfdfdf = \"paokara\" or ssss = \"paokara\")";
        input = "(text = tuna OR title = tuna OR species_english_name = tuna OR country = tuna OR type_of_vessel = tuna OR gear_used = tuna OR technology_used = tuna) AND gDocCollectionID == \"8dc17a91-378a-4396-98db-469280911b2f\" project gDocCollectionID gDocCollectionLang title text provenance country_uri vessel_uri gear_uri technology_used species_uri doc_uri gear_used technology_used management_uri sector_uri management sector ";
        HashSet<String> set = new HashSet<String>();
        ElasticSearchParser out = new ElasticSearchParser(input, null, set);
        System.out.println(out.parse().getClass() + " " + out.parse().toString());
        System.out.println(out.getDistincts());
        System.out.println(out.getProjects());
        System.out.println(out.getSortBys());
        System.out.println(out.getCollections());
        System.out.println(QueryBuilders.boolQuery().getClass());
        QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery()).should((QueryBuilder)QueryBuilders.boolQuery()).minimumNumberShouldMatch(1);
    }
}

