/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.parser;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.impl.PointImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.GeoDistanceFilterBuilder;
import org.elasticsearch.index.query.GeoPolygonFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.gcube.elasticsearch.parser.helpers.ParserHelpers;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchParserParser
extends Parser {
    public static final String[] tokenNames = new String[]{"<invalid>", "<EOR>", "<DOWN>", "<UP>", "TWODOUBLEQUOTES", "SORTBY", "PROJECT", "LPAREN", "RPAREN", "DISTANCE", "COMMA", "OVERLAPS", "EQUALS", "GREATER", "LESS", "GEQUAL", "LEQUAL", "NOTEQUAL", "EXACT", "SLASH", "CHARSTRING1", "CHARSTRING2", "AND", "OR", "NOT", "PROX", "LBRACK", "RBRACK", "DOUBLE", "INT", "ASC", "DESC", "FUSE", "WHITESPACE"};
    public static final int EOF = -1;
    public static final int TWODOUBLEQUOTES = 4;
    public static final int SORTBY = 5;
    public static final int PROJECT = 6;
    public static final int LPAREN = 7;
    public static final int RPAREN = 8;
    public static final int DISTANCE = 9;
    public static final int COMMA = 10;
    public static final int OVERLAPS = 11;
    public static final int EQUALS = 12;
    public static final int GREATER = 13;
    public static final int LESS = 14;
    public static final int GEQUAL = 15;
    public static final int LEQUAL = 16;
    public static final int NOTEQUAL = 17;
    public static final int EXACT = 18;
    public static final int SLASH = 19;
    public static final int CHARSTRING1 = 20;
    public static final int CHARSTRING2 = 21;
    public static final int AND = 22;
    public static final int OR = 23;
    public static final int NOT = 24;
    public static final int PROX = 25;
    public static final int LBRACK = 26;
    public static final int RBRACK = 27;
    public static final int DOUBLE = 28;
    public static final int INT = 29;
    public static final int ASC = 30;
    public static final int DESC = 31;
    public static final int FUSE = 32;
    public static final int WHITESPACE = 33;
    public ArrayList<String> projects = new ArrayList();
    public ArrayList<AbstractMap.SimpleEntry<String, String>> sortbys = new ArrayList();
    public ArrayList<String> distincts = new ArrayList();
    public Set<String> collections = new HashSet<String>();
    private final String ASCENDING = "ASC";
    private final String DISTINCT = "distinct";
    private final String ALLINDEXES = "allindexes";
    private RRadaptor adaptor;
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchParserParser.class);
    private int count;
    public static final BitSet FOLLOW_TWODOUBLEQUOTES_in_esQuery67 = new BitSet(new long[]{0L});
    public static final BitSet FOLLOW_EOF_in_esQuery69 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_scopedClause_in_esQuery81 = new BitSet(new long[]{96L});
    public static final BitSet FOLLOW_sortSpec_in_esQuery89 = new BitSet(new long[]{96L});
    public static final BitSet FOLLOW_projectSpec_in_esQuery102 = new BitSet(new long[]{96L});
    public static final BitSet FOLLOW_EOF_in_esQuery111 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_EOF_in_esQuery122 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SORTBY_in_sortSpec136 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_singleSpec_in_sortSpec146 = new BitSet(new long[]{4029677570L});
    public static final BitSet FOLLOW_order_in_sortSpec154 = new BitSet(new long[]{0x30300002L});
    public static final BitSet FOLLOW_PROJECT_in_projectSpec175 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_singleSpec_in_projectSpec183 = new BitSet(new long[]{0x30300002L});
    public static final BitSet FOLLOW_index_in_singleSpec206 = new BitSet(new long[]{524290L});
    public static final BitSet FOLLOW_modifierList_in_singleSpec219 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_scopedClause_in_cqlQuery251 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_searchClause_in_scopedClause274 = new BitSet(new long[]{62914562L});
    public static final BitSet FOLLOW_booleanGroup_in_scopedClause287 = new BitSet(new long[]{808454784L});
    public static final BitSet FOLLOW_searchClause_in_scopedClause293 = new BitSet(new long[]{62914562L});
    public static final BitSet FOLLOW_booleanOp_in_booleanGroup323 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_LPAREN_in_searchClause346 = new BitSet(new long[]{808454784L});
    public static final BitSet FOLLOW_cqlQuery_in_searchClause352 = new BitSet(new long[]{256L});
    public static final BitSet FOLLOW_RPAREN_in_searchClause354 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_index_in_searchClause365 = new BitSet(new long[]{3665920L});
    public static final BitSet FOLLOW_relation_in_searchClause371 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_searchTerm_in_searchClause377 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_searchTerm_in_searchClause392 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_distanceClause_in_searchClause403 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_overlapsClause_in_searchClause414 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_DISTANCE_in_distanceClause432 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_LPAREN_in_distanceClause434 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_index_in_distanceClause440 = new BitSet(new long[]{1024L});
    public static final BitSet FOLLOW_COMMA_in_distanceClause442 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_num_in_distanceClause448 = new BitSet(new long[]{1024L});
    public static final BitSet FOLLOW_COMMA_in_distanceClause450 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_geoPoint_in_distanceClause456 = new BitSet(new long[]{256L});
    public static final BitSet FOLLOW_RPAREN_in_distanceClause458 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_OVERLAPS_in_overlapsClause478 = new BitSet(new long[]{128L});
    public static final BitSet FOLLOW_LPAREN_in_overlapsClause480 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_index_in_overlapsClause486 = new BitSet(new long[]{1024L});
    public static final BitSet FOLLOW_COMMA_in_overlapsClause488 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_geoPointList_in_overlapsClause494 = new BitSet(new long[]{256L});
    public static final BitSet FOLLOW_RPAREN_in_overlapsClause496 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_comparitor_in_relation518 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_comparitorSymbol_in_comparitor541 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_namedComparitor_in_comparitor552 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_EQUALS_in_comparitorSymbol572 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_GREATER_in_comparitorSymbol583 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_LESS_in_comparitorSymbol594 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_GEQUAL_in_comparitorSymbol605 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_LEQUAL_in_comparitorSymbol616 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NOTEQUAL_in_comparitorSymbol627 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_EXACT_in_comparitorSymbol638 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_identifier_in_namedComparitor658 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_modifier_in_modifierList683 = new BitSet(new long[]{524290L});
    public static final BitSet FOLLOW_SLASH_in_modifier705 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_modifierName_in_modifier711 = new BitSet(new long[]{520194L});
    public static final BitSet FOLLOW_comparitorSymbol_in_modifier721 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_modifierValue_in_modifier727 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_term_in_prefix751 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_term_in_uri771 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_term_in_modifierName792 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_term_in_modifierValue812 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_term_in_searchTerm832 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_term_in_index853 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_identifier_in_term874 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_num_in_term885 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_set_in_identifier908 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_AND_in_booleanOp932 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_OR_in_booleanOp940 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_NOT_in_booleanOp949 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_PROX_in_booleanOp957 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_LBRACK_in_geoPointList974 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_geoPoint_in_geoPointList980 = new BitSet(new long[]{0x8000400L});
    public static final BitSet FOLLOW_COMMA_in_geoPointList995 = new BitSet(new long[]{0x4000000L});
    public static final BitSet FOLLOW_geoPoint_in_geoPointList1001 = new BitSet(new long[]{0x8000400L});
    public static final BitSet FOLLOW_RBRACK_in_geoPointList1013 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_LBRACK_in_geoPoint1028 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_num_in_geoPoint1034 = new BitSet(new long[]{1024L});
    public static final BitSet FOLLOW_COMMA_in_geoPoint1036 = new BitSet(new long[]{0x30300000L});
    public static final BitSet FOLLOW_num_in_geoPoint1042 = new BitSet(new long[]{0x8000000L});
    public static final BitSet FOLLOW_RBRACK_in_geoPoint1044 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_DOUBLE_in_num1065 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INT_in_num1079 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_ASC_in_order1103 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_DESC_in_order1111 = new BitSet(new long[]{2L});

    public ElasticSearchParserParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }

    public ElasticSearchParserParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public String[] getTokenNames() {
        return tokenNames;
    }

    public String getGrammarFileName() {
        return "org/gcube/elasticsearch/parser/ElasticSearchParser.g";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QueryBuilder esQuery(RRadaptor adaptor) throws RecognitionException {
        QueryBuilder qb = null;
        QueryBuilder sc = null;
        boolean s = false;
        boolean p = false;
        this.adaptor = adaptor;
        try {
            int alt2 = 3;
            switch (this.input.LA(1)) {
                case 4: {
                    alt2 = 1;
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 20: 
                case 21: 
                case 28: 
                case 29: {
                    alt2 = 2;
                    break;
                }
                case -1: {
                    alt2 = 3;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 2, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt2) {
                case 1: {
                    this.match((IntStream)this.input, 4, FOLLOW_TWODOUBLEQUOTES_in_esQuery67);
                    this.match((IntStream)this.input, -1, FOLLOW_EOF_in_esQuery69);
                    break;
                }
                case 2: {
                    this.pushFollow(FOLLOW_scopedClause_in_esQuery81);
                    sc = this.scopedClause();
                    --this.state._fsp;
                    block18: while (true) {
                        int alt1 = 3;
                        int LA1_0 = this.input.LA(1);
                        if (LA1_0 == 5 && !s) {
                            alt1 = 1;
                        } else if (LA1_0 == 6 && !p) {
                            alt1 = 2;
                        }
                        switch (alt1) {
                            case 1: {
                                if (s) {
                                    throw new FailedPredicateException((IntStream)this.input, "esQuery", " s == false ");
                                }
                                this.pushFollow(FOLLOW_sortSpec_in_esQuery89);
                                this.sortSpec();
                                --this.state._fsp;
                                s = true;
                                continue block18;
                            }
                            case 2: {
                                if (p) {
                                    throw new FailedPredicateException((IntStream)this.input, "esQuery", " p == false ");
                                }
                                this.pushFollow(FOLLOW_projectSpec_in_esQuery102);
                                this.projectSpec();
                                --this.state._fsp;
                                p = true;
                                continue block18;
                            }
                        }
                        break;
                    }
                    this.match((IntStream)this.input, -1, FOLLOW_EOF_in_esQuery111);
                    qb = sc;
                    break;
                }
                case 3: {
                    this.match((IntStream)this.input, -1, FOLLOW_EOF_in_esQuery122);
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return qb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String sortSpec() throws RecognitionException {
        String value;
        block18: {
            value = null;
            String s = null;
            String o = null;
            try {
                this.match((IntStream)this.input, 5, FOLLOW_SORTBY_in_sortSpec136);
                int cnt4 = 0;
                while (true) {
                    int alt4 = 2;
                    switch (this.input.LA(1)) {
                        case 20: 
                        case 21: 
                        case 28: 
                        case 29: {
                            alt4 = 1;
                        }
                    }
                    switch (alt4) {
                        case 1: {
                            o = this.ASCENDING;
                            this.pushFollow(FOLLOW_singleSpec_in_sortSpec146);
                            s = this.singleSpec();
                            --this.state._fsp;
                            int alt3 = 2;
                            switch (this.input.LA(1)) {
                                case 30: 
                                case 31: {
                                    alt3 = 1;
                                }
                            }
                            switch (alt3) {
                                case 1: {
                                    this.pushFollow(FOLLOW_order_in_sortSpec154);
                                    o = this.order();
                                    --this.state._fsp;
                                }
                            }
                            this.sortbys.add(new AbstractMap.SimpleEntry<String, String>(ParserHelpers.translateField(s, this.adaptor), o));
                            break;
                        }
                        default: {
                            if (cnt4 < 1) {
                                EarlyExitException eee = new EarlyExitException(4, (IntStream)this.input);
                                throw eee;
                            }
                            break block18;
                        }
                    }
                    ++cnt4;
                }
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover((IntStream)this.input, re);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String projectSpec() throws RecognitionException {
        String value;
        block12: {
            value = null;
            String s = null;
            try {
                this.match((IntStream)this.input, 6, FOLLOW_PROJECT_in_projectSpec175);
                int cnt5 = 0;
                while (true) {
                    int alt5 = 2;
                    switch (this.input.LA(1)) {
                        case 20: 
                        case 21: 
                        case 28: 
                        case 29: {
                            alt5 = 1;
                        }
                    }
                    switch (alt5) {
                        case 1: {
                            this.pushFollow(FOLLOW_singleSpec_in_projectSpec183);
                            s = this.singleSpec();
                            --this.state._fsp;
                            this.projects.add(ParserHelpers.translateField(s, this.adaptor));
                            break;
                        }
                        default: {
                            if (cnt5 < 1) {
                                EarlyExitException eee = new EarlyExitException(5, (IntStream)this.input);
                                throw eee;
                            }
                            break block12;
                        }
                    }
                    ++cnt5;
                }
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover((IntStream)this.input, re);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String singleSpec() throws RecognitionException {
        String value = null;
        String i = null;
        ArrayList<String> ml = null;
        try {
            this.pushFollow(FOLLOW_index_in_singleSpec206);
            i = this.index();
            --this.state._fsp;
            value = i;
            int alt6 = 2;
            switch (this.input.LA(1)) {
                case 19: {
                    alt6 = 1;
                }
            }
            switch (alt6) {
                case 1: {
                    this.pushFollow(FOLLOW_modifierList_in_singleSpec219);
                    ml = this.modifierList();
                    --this.state._fsp;
                    for (String s : ml) {
                        if (!s.toLowerCase().equals(this.DISTINCT)) continue;
                        this.distincts.add(ParserHelpers.translateField(i, this.adaptor));
                    }
                    break;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QueryBuilder cqlQuery() throws RecognitionException {
        QueryBuilder qb = null;
        QueryBuilder sc = null;
        try {
            this.pushFollow(FOLLOW_scopedClause_in_cqlQuery251);
            sc = this.scopedClause();
            --this.state._fsp;
            qb = sc;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return qb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QueryBuilder scopedClause() throws RecognitionException {
        Object qb = null;
        ToXContent s1 = null;
        String b = null;
        ToXContent s2 = null;
        try {
            this.pushFollow(FOLLOW_searchClause_in_scopedClause274);
            s1 = this.searchClause();
            --this.state._fsp;
            this.count = 0;
            qb = s1 instanceof FilterBuilder ? QueryBuilders.constantScoreQuery((FilterBuilder)((FilterBuilder)s1)) : (QueryBuilder)s1;
            block10: while (true) {
                int alt7 = 2;
                switch (this.input.LA(1)) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        alt7 = 1;
                    }
                }
                switch (alt7) {
                    case 1: {
                        this.pushFollow(FOLLOW_booleanGroup_in_scopedClause287);
                        b = this.booleanGroup();
                        --this.state._fsp;
                        this.pushFollow(FOLLOW_searchClause_in_scopedClause293);
                        s2 = this.searchClause();
                        --this.state._fsp;
                        ++this.count;
                        if (b.equals("AND")) {
                            if (s2 instanceof FilterBuilder) {
                                qb = QueryBuilders.filteredQuery((QueryBuilder)qb, (FilterBuilder)((FilterBuilder)s2));
                                continue block10;
                            }
                            if (s1 instanceof FilterBuilder && this.count == 1) {
                                qb = QueryBuilders.filteredQuery((QueryBuilder)((QueryBuilder)s2), (FilterBuilder)((FilterBuilder)s1));
                                continue block10;
                            }
                            qb = ParserHelpers.getCombinedQuery(qb, (QueryBuilder)s2);
                            continue block10;
                        }
                        if (b.equals("OR")) {
                            if (s2 instanceof FilterBuilder) {
                                qb = QueryBuilders.boolQuery().should(qb).should((QueryBuilder)QueryBuilders.constantScoreQuery((FilterBuilder)((FilterBuilder)s2))).minimumNumberShouldMatch(1);
                                continue block10;
                            }
                            qb = ParserHelpers.getCombinedOrQuery(qb, (QueryBuilder)s2);
                            continue block10;
                        }
                        if (!b.equals("NOT")) continue block10;
                        if (s2 instanceof FilterBuilder) {
                            qb = QueryBuilders.boolQuery().must(qb).mustNot((QueryBuilder)QueryBuilders.constantScoreQuery((FilterBuilder)((FilterBuilder)s2)));
                            continue block10;
                        }
                        qb = QueryBuilders.boolQuery().must(qb).mustNot((QueryBuilder)s2);
                        continue block10;
                    }
                }
                break;
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return qb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String booleanGroup() throws RecognitionException {
        String value = null;
        String b = null;
        try {
            this.pushFollow(FOLLOW_booleanOp_in_booleanGroup323);
            b = this.booleanOp();
            --this.state._fsp;
            value = b;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ToXContent searchClause() throws RecognitionException {
        GeoDistanceFilterBuilder qb = null;
        QueryBuilder q = null;
        String i = null;
        String r = null;
        String s = null;
        GeoDistanceFilterBuilder d = null;
        GeoPolygonFilterBuilder o = null;
        try {
            int alt8 = 5;
            block2 : switch (this.input.LA(1)) {
                case 7: {
                    alt8 = 1;
                    break;
                }
                case 20: 
                case 21: {
                    switch (this.input.LA(2)) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 21: {
                            alt8 = 2;
                            break block2;
                        }
                        case -1: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            alt8 = 3;
                            break block2;
                        }
                    }
                    NoViableAltException nvae = new NoViableAltException("", 8, 2, (IntStream)this.input);
                    throw nvae;
                }
                case 28: {
                    switch (this.input.LA(2)) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 21: {
                            alt8 = 2;
                            break block2;
                        }
                        case -1: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            alt8 = 3;
                            break block2;
                        }
                    }
                    NoViableAltException nvae = new NoViableAltException("", 8, 3, (IntStream)this.input);
                    throw nvae;
                }
                case 29: {
                    switch (this.input.LA(2)) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 21: {
                            alt8 = 2;
                            break block2;
                        }
                        case -1: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            alt8 = 3;
                            break block2;
                        }
                    }
                    NoViableAltException nvae = new NoViableAltException("", 8, 4, (IntStream)this.input);
                    throw nvae;
                }
                case 9: {
                    alt8 = 4;
                    break;
                }
                case 11: {
                    alt8 = 5;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 8, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt8) {
                case 1: {
                    this.match((IntStream)this.input, 7, FOLLOW_LPAREN_in_searchClause346);
                    this.pushFollow(FOLLOW_cqlQuery_in_searchClause352);
                    q = this.cqlQuery();
                    --this.state._fsp;
                    this.match((IntStream)this.input, 8, FOLLOW_RPAREN_in_searchClause354);
                    qb = q;
                    break;
                }
                case 2: {
                    this.pushFollow(FOLLOW_index_in_searchClause365);
                    i = this.index();
                    --this.state._fsp;
                    this.pushFollow(FOLLOW_relation_in_searchClause371);
                    r = this.relation();
                    --this.state._fsp;
                    this.pushFollow(FOLLOW_searchTerm_in_searchClause377);
                    s = this.searchTerm();
                    --this.state._fsp;
                    String translated = ParserHelpers.translateField(i, this.adaptor);
                    logger.info("Translated field " + i + " to: " + translated);
                    if (s.equals("\"*\"")) {
                        qb = QueryBuilders.matchAllQuery();
                    } else if (r.equals("==")) {
                        qb = FilterBuilders.boolFilter().must((FilterBuilder)FilterBuilders.termFilter((String)i, (String)s.replaceAll("\"", "")));
                    } else if (translated.toLowerCase().equals("allindexes")) {
                        qb = QueryBuilders.queryString((String)s);
                    } else if (r.equals("=")) {
                        qb = QueryBuilders.queryString((String)(translated + ":" + s));
                    } else if (r.toLowerCase().equals("within")) {
                        String[] range = s.replaceAll("\"", "").split(" ");
                        qb = QueryBuilders.rangeQuery((String)translated).from(range[0].trim()).to(range[1].trim()).includeLower(true).includeUpper(true);
                    } else {
                        qb = QueryBuilders.queryString((String)(ParserHelpers.translateField(i, this.adaptor) + ":" + r + s));
                    }
                    if (i.equals("gDocCollectionID")) {
                        this.collections.add(s.replaceAll("\"", ""));
                    }
                    break;
                }
                case 3: {
                    this.pushFollow(FOLLOW_searchTerm_in_searchClause392);
                    s = this.searchTerm();
                    --this.state._fsp;
                    qb = QueryBuilders.queryString((String)s);
                    break;
                }
                case 4: {
                    this.pushFollow(FOLLOW_distanceClause_in_searchClause403);
                    d = this.distanceClause();
                    --this.state._fsp;
                    qb = d;
                    break;
                }
                case 5: {
                    this.pushFollow(FOLLOW_overlapsClause_in_searchClause414);
                    o = this.overlapsClause();
                    --this.state._fsp;
                    qb = o;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return qb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeoDistanceFilterBuilder distanceClause() throws RecognitionException {
        GeoDistanceFilterBuilder fb = null;
        String i = null;
        String n = null;
        Point g = null;
        try {
            this.match((IntStream)this.input, 9, FOLLOW_DISTANCE_in_distanceClause432);
            this.match((IntStream)this.input, 7, FOLLOW_LPAREN_in_distanceClause434);
            this.pushFollow(FOLLOW_index_in_distanceClause440);
            i = this.index();
            --this.state._fsp;
            this.match((IntStream)this.input, 10, FOLLOW_COMMA_in_distanceClause442);
            this.pushFollow(FOLLOW_num_in_distanceClause448);
            n = this.num();
            --this.state._fsp;
            this.match((IntStream)this.input, 10, FOLLOW_COMMA_in_distanceClause450);
            this.pushFollow(FOLLOW_geoPoint_in_distanceClause456);
            g = this.geoPoint();
            --this.state._fsp;
            this.match((IntStream)this.input, 8, FOLLOW_RPAREN_in_distanceClause458);
            fb = FilterBuilders.geoDistanceFilter((String)i).optimizeBbox("memory").geoDistance(GeoDistance.ARC).point(g.getX(), g.getY()).distance(Double.parseDouble(n), DistanceUnit.METERS);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return fb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GeoPolygonFilterBuilder overlapsClause() throws RecognitionException {
        GeoPolygonFilterBuilder fb = null;
        String i = null;
        ArrayList<Point> g = null;
        try {
            this.match((IntStream)this.input, 11, FOLLOW_OVERLAPS_in_overlapsClause478);
            this.match((IntStream)this.input, 7, FOLLOW_LPAREN_in_overlapsClause480);
            this.pushFollow(FOLLOW_index_in_overlapsClause486);
            i = this.index();
            --this.state._fsp;
            this.match((IntStream)this.input, 10, FOLLOW_COMMA_in_overlapsClause488);
            this.pushFollow(FOLLOW_geoPointList_in_overlapsClause494);
            g = this.geoPointList();
            --this.state._fsp;
            this.match((IntStream)this.input, 8, FOLLOW_RPAREN_in_overlapsClause496);
            fb = FilterBuilders.geoPolygonFilter((String)i);
            for (Point p : g) {
                fb = fb.addPoint(p.getX(), p.getY());
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return fb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String relation() throws RecognitionException {
        String value = null;
        String c = null;
        try {
            this.pushFollow(FOLLOW_comparitor_in_relation518);
            c = this.comparitor();
            --this.state._fsp;
            value = c;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String comparitor() throws RecognitionException {
        String value = null;
        String c = null;
        try {
            int alt9 = 2;
            switch (this.input.LA(1)) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    alt9 = 1;
                    break;
                }
                case 20: 
                case 21: {
                    alt9 = 2;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 9, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt9) {
                case 1: {
                    this.pushFollow(FOLLOW_comparitorSymbol_in_comparitor541);
                    c = this.comparitorSymbol();
                    --this.state._fsp;
                    value = c;
                    break;
                }
                case 2: {
                    this.pushFollow(FOLLOW_namedComparitor_in_comparitor552);
                    c = this.namedComparitor();
                    --this.state._fsp;
                    value = c;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String comparitorSymbol() throws RecognitionException {
        String value = null;
        Token c = null;
        try {
            int alt10 = 7;
            switch (this.input.LA(1)) {
                case 12: {
                    alt10 = 1;
                    break;
                }
                case 13: {
                    alt10 = 2;
                    break;
                }
                case 14: {
                    alt10 = 3;
                    break;
                }
                case 15: {
                    alt10 = 4;
                    break;
                }
                case 16: {
                    alt10 = 5;
                    break;
                }
                case 17: {
                    alt10 = 6;
                    break;
                }
                case 18: {
                    alt10 = 7;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 10, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt10) {
                case 1: {
                    c = (Token)this.match((IntStream)this.input, 12, FOLLOW_EQUALS_in_comparitorSymbol572);
                    value = c != null ? c.getText() : null;
                    break;
                }
                case 2: {
                    c = (Token)this.match((IntStream)this.input, 13, FOLLOW_GREATER_in_comparitorSymbol583);
                    value = c != null ? c.getText() : null;
                    break;
                }
                case 3: {
                    c = (Token)this.match((IntStream)this.input, 14, FOLLOW_LESS_in_comparitorSymbol594);
                    value = c != null ? c.getText() : null;
                    break;
                }
                case 4: {
                    c = (Token)this.match((IntStream)this.input, 15, FOLLOW_GEQUAL_in_comparitorSymbol605);
                    value = c != null ? c.getText() : null;
                    break;
                }
                case 5: {
                    c = (Token)this.match((IntStream)this.input, 16, FOLLOW_LEQUAL_in_comparitorSymbol616);
                    value = c != null ? c.getText() : null;
                    break;
                }
                case 6: {
                    c = (Token)this.match((IntStream)this.input, 17, FOLLOW_NOTEQUAL_in_comparitorSymbol627);
                    value = c != null ? c.getText() : null;
                    break;
                }
                case 7: {
                    c = (Token)this.match((IntStream)this.input, 18, FOLLOW_EXACT_in_comparitorSymbol638);
                    value = c != null ? c.getText() : null;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String namedComparitor() throws RecognitionException {
        String value = null;
        identifier_return nc = null;
        try {
            this.pushFollow(FOLLOW_identifier_in_namedComparitor658);
            nc = this.identifier();
            --this.state._fsp;
            value = nc != null ? nc.value : null;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<String> modifierList() throws RecognitionException {
        ArrayList<String> ml;
        block12: {
            ml = null;
            String m = null;
            try {
                ml = new ArrayList<String>();
                int cnt11 = 0;
                while (true) {
                    int alt11 = 2;
                    switch (this.input.LA(1)) {
                        case 19: {
                            alt11 = 1;
                        }
                    }
                    switch (alt11) {
                        case 1: {
                            this.pushFollow(FOLLOW_modifier_in_modifierList683);
                            m = this.modifier();
                            --this.state._fsp;
                            ml.add(m);
                            break;
                        }
                        default: {
                            if (cnt11 < 1) {
                                EarlyExitException eee = new EarlyExitException(11, (IntStream)this.input);
                                throw eee;
                            }
                            break block12;
                        }
                    }
                    ++cnt11;
                }
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover((IntStream)this.input, re);
            }
        }
        return ml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String modifier() throws RecognitionException {
        String value = null;
        String n = null;
        String s = null;
        String m = null;
        try {
            this.match((IntStream)this.input, 19, FOLLOW_SLASH_in_modifier705);
            this.pushFollow(FOLLOW_modifierName_in_modifier711);
            n = this.modifierName();
            --this.state._fsp;
            value = n;
            int alt12 = 2;
            switch (this.input.LA(1)) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    alt12 = 1;
                }
            }
            switch (alt12) {
                case 1: {
                    this.pushFollow(FOLLOW_comparitorSymbol_in_modifier721);
                    s = this.comparitorSymbol();
                    --this.state._fsp;
                    this.pushFollow(FOLLOW_modifierValue_in_modifier727);
                    m = this.modifierValue();
                    --this.state._fsp;
                    value = value + s + m;
                    System.out.println("MOD: " + value);
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String prefix() throws RecognitionException {
        String value = null;
        term_return p = null;
        try {
            this.pushFollow(FOLLOW_term_in_prefix751);
            p = this.term();
            --this.state._fsp;
            value = p != null ? p.value : null;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String uri() throws RecognitionException {
        String value = null;
        term_return u = null;
        try {
            this.pushFollow(FOLLOW_term_in_uri771);
            u = this.term();
            --this.state._fsp;
            value = u != null ? u.value : null;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String modifierName() throws RecognitionException {
        String name = null;
        term_return mn = null;
        try {
            this.pushFollow(FOLLOW_term_in_modifierName792);
            mn = this.term();
            --this.state._fsp;
            name = mn != null ? mn.value : null;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String modifierValue() throws RecognitionException {
        String value = null;
        term_return mv = null;
        try {
            this.pushFollow(FOLLOW_term_in_modifierValue812);
            mv = this.term();
            --this.state._fsp;
            value = mv != null ? mv.value : null;
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String searchTerm() throws RecognitionException {
        String value = null;
        term_return st = null;
        try {
            this.pushFollow(FOLLOW_term_in_searchTerm832);
            st = this.term();
            --this.state._fsp;
            value = st != null ? st.value : null;
            logger.trace("searchTerm " + (st != null ? this.input.toString(st.start, st.stop) : null));
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String index() throws RecognitionException {
        String value = null;
        term_return t = null;
        try {
            this.pushFollow(FOLLOW_term_in_index853);
            t = this.term();
            --this.state._fsp;
            value = t != null ? t.value : null;
            logger.trace("index " + (t != null ? this.input.toString(t.start, t.stop) : null));
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final term_return term() throws RecognitionException {
        term_return retval = new term_return();
        retval.start = this.input.LT(1);
        identifier_return i = null;
        String n = null;
        try {
            int alt13 = 2;
            switch (this.input.LA(1)) {
                case 20: 
                case 21: {
                    alt13 = 1;
                    break;
                }
                case 28: 
                case 29: {
                    alt13 = 2;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 13, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt13) {
                case 1: {
                    this.pushFollow(FOLLOW_identifier_in_term874);
                    i = this.identifier();
                    --this.state._fsp;
                    retval.value = i != null ? i.value : null;
                    logger.trace("term " + (i != null ? this.input.toString(i.start, i.stop) : null));
                    break;
                }
                case 2: {
                    this.pushFollow(FOLLOW_num_in_term885);
                    n = this.num();
                    --this.state._fsp;
                    retval.value = n.toString();
                }
            }
            retval.stop = this.input.LT(-1);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final identifier_return identifier() throws RecognitionException {
        identifier_return retval = new identifier_return();
        retval.start = this.input.LT(1);
        Token i = null;
        try {
            i = this.input.LT(1);
            if (this.input.LA(1) < 20 || this.input.LA(1) > 21) {
                MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                throw mse;
            }
            this.input.consume();
            this.state.errorRecovery = false;
            retval.value = i != null ? i.getText() : null;
            logger.trace("identifier " + (i != null ? i.getText() : null));
            retval.stop = this.input.LT(-1);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String booleanOp() throws RecognitionException {
        String op = null;
        try {
            int alt14 = 4;
            switch (this.input.LA(1)) {
                case 22: {
                    alt14 = 1;
                    break;
                }
                case 23: {
                    alt14 = 2;
                    break;
                }
                case 24: {
                    alt14 = 3;
                    break;
                }
                case 25: {
                    alt14 = 4;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 14, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt14) {
                case 1: {
                    this.match((IntStream)this.input, 22, FOLLOW_AND_in_booleanOp932);
                    op = "AND";
                    break;
                }
                case 2: {
                    this.match((IntStream)this.input, 23, FOLLOW_OR_in_booleanOp940);
                    op = "OR";
                    break;
                }
                case 3: {
                    this.match((IntStream)this.input, 24, FOLLOW_NOT_in_booleanOp949);
                    op = "NOT";
                    break;
                }
                case 4: {
                    this.match((IntStream)this.input, 25, FOLLOW_PROX_in_booleanOp957);
                    op = "PROX";
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<Point> geoPointList() throws RecognitionException {
        ArrayList<Point> gps = null;
        Point g1 = null;
        Point g2 = null;
        try {
            this.match((IntStream)this.input, 26, FOLLOW_LBRACK_in_geoPointList974);
            this.pushFollow(FOLLOW_geoPoint_in_geoPointList980);
            g1 = this.geoPoint();
            --this.state._fsp;
            gps = new ArrayList<Point>();
            gps.add(g1);
            block10: while (true) {
                int alt15 = 2;
                switch (this.input.LA(1)) {
                    case 10: {
                        alt15 = 1;
                    }
                }
                switch (alt15) {
                    case 1: {
                        this.match((IntStream)this.input, 10, FOLLOW_COMMA_in_geoPointList995);
                        this.pushFollow(FOLLOW_geoPoint_in_geoPointList1001);
                        g2 = this.geoPoint();
                        --this.state._fsp;
                        gps.add(g2);
                        continue block10;
                    }
                }
                break;
            }
            this.match((IntStream)this.input, 27, FOLLOW_RBRACK_in_geoPointList1013);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return gps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Point geoPoint() throws RecognitionException {
        PointImpl gp = null;
        String lat = null;
        String lon = null;
        try {
            this.match((IntStream)this.input, 26, FOLLOW_LBRACK_in_geoPoint1028);
            this.pushFollow(FOLLOW_num_in_geoPoint1034);
            lat = this.num();
            --this.state._fsp;
            this.match((IntStream)this.input, 10, FOLLOW_COMMA_in_geoPoint1036);
            this.pushFollow(FOLLOW_num_in_geoPoint1042);
            lon = this.num();
            --this.state._fsp;
            this.match((IntStream)this.input, 27, FOLLOW_RBRACK_in_geoPoint1044);
            gp = new PointImpl(Double.parseDouble(lat), Double.parseDouble(lon), SpatialContext.GEO);
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return gp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String num() throws RecognitionException {
        String number = null;
        Token d = null;
        Token i = null;
        try {
            int alt16 = 2;
            switch (this.input.LA(1)) {
                case 28: {
                    alt16 = 1;
                    break;
                }
                case 29: {
                    alt16 = 2;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 16, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt16) {
                case 1: {
                    d = (Token)this.match((IntStream)this.input, 28, FOLLOW_DOUBLE_in_num1065);
                    number = d != null ? d.getText() : null;
                    break;
                }
                case 2: {
                    i = (Token)this.match((IntStream)this.input, 29, FOLLOW_INT_in_num1079);
                    number = i != null ? i.getText() : null;
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String order() throws RecognitionException {
        String value = null;
        try {
            int alt17 = 2;
            switch (this.input.LA(1)) {
                case 30: {
                    alt17 = 1;
                    break;
                }
                case 31: {
                    alt17 = 2;
                    break;
                }
                default: {
                    NoViableAltException nvae = new NoViableAltException("", 17, 0, (IntStream)this.input);
                    throw nvae;
                }
            }
            switch (alt17) {
                case 1: {
                    this.match((IntStream)this.input, 30, FOLLOW_ASC_in_order1103);
                    value = "ASC";
                    break;
                }
                case 2: {
                    this.match((IntStream)this.input, 31, FOLLOW_DESC_in_order1111);
                    value = "DESC";
                }
            }
        }
        catch (RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }
        return value;
    }

    public static class identifier_return
    extends ParserRuleReturnScope {
        public String value;
    }

    public static class term_return
    extends ParserRuleReturnScope {
        public String value;
    }
}

