package org.gcube.fulltextindexnode.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.fulltextindexnode.client.library.plugins.FullTextIndexNodeCLPlugin;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;
import org.gcube.fulltextindexnode.client.library.utils.FullTextIndexNodeCLConstants;

public class FullTextIndexNodeDSL {
	
	public static final FullTextIndexNodeCLPlugin ftin_plugin = new FullTextIndexNodeCLPlugin();
	
	
	public static StatefulQuery plugin(final String indexID) {
		
		StatefulQuery query = new StatefulQuery(ftin_plugin);
		query.addNamespace("ns1",URI.create(FullTextIndexNodeCLConstants.NAMESPACE))
		.addCondition("$resource/Data/tm:SourceId/text() eq '"+indexID+"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(ftin_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	/**
	 * Returns a {@link TReader} builder.
	 * @return the builder
	 */
	public static StatefulBuilder<FullTextIndexNodeCLProxyI> getFullTextIndexNodeProxyBuilder() {
		return new StatefulBuilderImpl<FullTextIndexNodeStub,FullTextIndexNodeCLProxyI>(ftin_plugin);
	}
	
}
