package org.gcube.fulltextindexnode.client.library.proxies;

import java.util.Arrays;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.beans.Types.SetCollections;
import org.gcube.fulltextindexnode.client.library.beans.Types.SetFields;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;
import org.gcube.common.clients.Call;

public class FullTextIndexNodeCLDefaultProxy implements FullTextIndexNodeCLProxyI {

	private final ProxyDelegate<FullTextIndexNodeStub> delegate;

	public FullTextIndexNodeCLDefaultProxy(ProxyDelegate<FullTextIndexNodeStub> config) {
		this.delegate = config;
	}

	@Override
	public Boolean feedLocator(final String feedLocator) {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.feedLocator(feedLocator);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public String query(final String query) {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			@Override
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public boolean shutdown(final String shutdown) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.shutdown(shutdown);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	@Override
	public boolean destroyNode() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.destroyNode();
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	@Override
	public boolean refresh() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.refresh();
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	@Override
	public boolean rebuildMetaIndex() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.rebuildMetaIndex();
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	@Override
	public GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, GetIndexInformationResponse> call = new Call<FullTextIndexNodeStub, GetIndexInformationResponse>() {

			@Override
			public GetIndexInformationResponse call(FullTextIndexNodeStub endpoint) throws Exception {

				return endpoint.getIndexInformation();
			}
		};
		try {
			GetIndexInformationResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public boolean setCollections(final String[] collections) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				SetCollections request = new SetCollections();
				request.setCollections = Arrays.asList(collections);
				return endpoint.setCollections(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	@Override
	public boolean setFields(final String[] fields) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				SetFields request = new SetFields();
				request.setFields = Arrays.asList(fields);
				return endpoint.setFields(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

}
