package org.gcube.fulltextindexnode.client.library.proxies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;


import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.fulltextindexnode.client.library.beans.Types.Destroy;
import org.gcube.fulltextindexnode.client.library.beans.Types.FeedLocator;
import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.beans.Types.QueryLimited;
import org.gcube.fulltextindexnode.client.library.beans.Types.Query;
import org.gcube.fulltextindexnode.client.library.beans.Types.StringArray;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;

public class FullTextIndexNodeCLDefaultProxy implements FullTextIndexNodeCLProxyI {

	private final ProxyDelegate<FullTextIndexNodeStub> delegate;

	public FullTextIndexNodeCLDefaultProxy(ProxyDelegate<FullTextIndexNodeStub> config) {
		this.delegate = config;
	}

//	public Boolean feedLocator(final String feedLocator) throws FullTextIndexNodeException {
//		final FeedLocator feedLocatorRequest = new FeedLocator();
//		feedLocatorRequest.resultSetLocation = feedLocator;
//		feedLocatorRequest.indexName = null;
//		feedLocatorRequest.activate = true;
//		feedLocatorRequest.sids.array = null;
//		
//		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
//			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
//				return endpoint.feedLocator(feedLocatorRequest);
//			}
//		};
//		try {
//			Boolean response = delegate.make(call);
//			return response;
//		} catch (Exception e) {
//			throw new FullTextIndexNodeException(e);
//		}
//	}
	
	public Boolean feedLocator(final String feedLocator, final String indexName, final Set<String> sids, final Boolean activate) throws FullTextIndexNodeException {
		final FeedLocator feedLocatorRequest = new FeedLocator();
		feedLocatorRequest.resultSetLocation = feedLocator;
		feedLocatorRequest.indexName = indexName;
		feedLocatorRequest.activate = activate;
		feedLocatorRequest.sids = new StringArray();
		if (sids != null)
			feedLocatorRequest.sids.array = new ArrayList<String>(sids);
		
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.feedLocator(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
//	public Boolean feedLocator(final String feedLocator, final String indexName) throws FullTextIndexNodeException {
//		final FeedLocator feedLocatorRequest = new FeedLocator();
//		feedLocatorRequest.resultSetLocation = feedLocator;
//		feedLocatorRequest.indexName = indexName;
//		feedLocatorRequest.activate = true;
//		feedLocatorRequest.sids.array = null;
//		
//		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
//			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
//				return endpoint.feedLocator(feedLocatorRequest);
//			}
//		};
//		try {
//			Boolean response = delegate.make(call);
//			return response;
//		} catch (Exception e) {
//			throw new FullTextIndexNodeException(e);
//		}
//	}
//	
//	public Boolean feedLocator(final String feedLocator, final String indexName, final Boolean activate) throws FullTextIndexNodeException {
//		final FeedLocator feedLocatorRequest = new FeedLocator();
//		feedLocatorRequest.resultSetLocation = feedLocator;
//		feedLocatorRequest.indexName = indexName;
//		feedLocatorRequest.activate = activate;
//		feedLocatorRequest.sids.array = null;
//		
//		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
//			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
//				return endpoint.feedLocator(feedLocatorRequest);
//			}
//		};
//		try {
//			Boolean response = delegate.make(call);
//			return response;
//		} catch (Exception e) {
//			throw new FullTextIndexNodeException(e);
//		}
//	}
	
	public Long collectionCount(final String collectionID) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Long> call = new Call<FullTextIndexNodeStub, Long>() {
			public Long call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.collectionCount(collectionID);
			}
		};
		try {
			Long response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public Boolean activateIndex(final String indexName) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.activateIndex(indexName);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public Boolean deleteIndex(final String indexName) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.deleteIndex(indexName);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public Boolean feedLocatorUnit(final String feedLocator) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.feedLocatorUnit(feedLocator);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public Boolean flush() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.flush(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public List<String> getCollectionsOfIndex(final String indexName)
			throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, StringArray> call = new Call<FullTextIndexNodeStub, StringArray>() {
			public StringArray call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.getCollectionsOfIndex(indexName);
			}
		};
		try {
			StringArray response = delegate.make(call);
			return response.array;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public List<String> getIndicesOfCollection(final String collectionID)
			throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, StringArray> call = new Call<FullTextIndexNodeStub, StringArray>() {
			public StringArray call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.getIndicesOfCollection(collectionID);
			}
		};
		try {
			StringArray response = delegate.make(call);
			return response.array;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public String query(final String queryString, final Set<String> sids) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				Query query = new Query();
				query.query = queryString;
				query.sids = new StringArray();
				if (sids != null)
					query.sids.array = new ArrayList<String>(sids);

				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public String query(final String queryString) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				Query query = new Query();
				query.query = queryString;
				query.sids = new StringArray();
				
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public String queryLimited(final String query, final Integer count, final Integer from, final Set<String> sids) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				QueryLimited queryLimited = new QueryLimited();
				queryLimited.query = query;
				queryLimited.count = count;
				queryLimited.from = from;
				queryLimited.sids = new StringArray();
				if (sids != null)
					queryLimited.sids.array = new ArrayList<String>(sids);
				
				return endpoint.queryLimited(queryLimited);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public String queryLimited(final String query, final Integer count, final Integer from) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				QueryLimited queryLimited = new QueryLimited();
				queryLimited.query = query;
				queryLimited.count = count;
				queryLimited.from = from;
				queryLimited.sids = new StringArray();
				
				return endpoint.queryLimited(queryLimited);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public boolean shutdown(final String shutdown) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.shutdown(shutdown);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	public boolean deleteCollection(final String collectionID) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.deleteCollection(collectionID);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public boolean destroyNode() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.destroyNode(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public boolean refresh() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.refresh(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public boolean rebuildMetaIndex() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.rebuildMetaIndex(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, GetIndexInformationResponse> call = new Call<FullTextIndexNodeStub, GetIndexInformationResponse>() {

			public GetIndexInformationResponse call(FullTextIndexNodeStub endpoint) throws Exception {

				return endpoint.getIndexInformation(new Empty());
			}
		};
		try {
			GetIndexInformationResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public boolean setCollections(final String[] collections) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(collections);
				return endpoint.setCollections(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public boolean setFields(final String[] fields) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(fields);
				return endpoint.setFields(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	public void destroy() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Empty> call = new Call<FullTextIndexNodeStub, Empty>() {
			public Empty call(FullTextIndexNodeStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}


}
