/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.rest.index.client.exceptions.IndexException;
import org.gcube.rest.index.client.helpers.ResponseUtils;
import org.gcube.rest.index.common.apis.IndexServiceAPI;
import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.entities.ClusterResponse;
import org.gcube.rest.index.common.helpers.ResultReader;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.rest.resourcemanager.harvester.ResourceHarvester;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexClient {
    private static Gson gson = new Gson();
    private String endpoint;
    private String resourceID;
    private final String scope;
    private final String clusterID;
    private final String indexID;
    private final String collectionID;
    private static final Logger logger = LoggerFactory.getLogger(IndexClient.class);

    public IndexClient(Builder builder) throws IndexException {
        this.indexID = builder.indexID;
        this.clusterID = builder.clusterID;
        this.endpoint = builder.endpoint;
        this.scope = builder.scope;
        this.resourceID = builder.resourceID;
        this.collectionID = builder.collectionID;
        Object indexDiscoverer = builder.indexDiscoverer != null ? builder.indexDiscoverer : new IndexDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl("FullTextIndexNode", "Index", "resteasy-servlet", this.scope), (IResourceHarvester)new ResourceHarvester(this.scope), this.scope);
        this.intialize((IndexDiscovererAPI<IndexResource>)indexDiscoverer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void intialize(IndexDiscovererAPI<IndexResource> indexDiscoverer) throws IndexException {
        boolean found = false;
        try {
            Map fulltextIndexNodes = indexDiscoverer.discoverFulltextIndexNodes(this.clusterID, this.indexID, this.collectionID);
            logger.info("running instances for index service : " + fulltextIndexNodes);
            ArrayList endpoints = Lists.newArrayList(fulltextIndexNodes.keySet());
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) throw new IndexException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            for (String endpoint : endpoints) {
                if (fulltextIndexNodes.get(endpoint) == null || ((Set)fulltextIndexNodes.get(endpoint)).size() <= 0) continue;
                ArrayList resources = Lists.newArrayList((Iterable)((Iterable)fulltextIndexNodes.get(endpoint)));
                if (this.resourceID != null) {
                    if (!resources.contains(this.resourceID)) throw new IndexException("could not initialize random client. given resourceID : " + this.resourceID + " found resourceIDs : " + resources);
                    resources = Lists.newArrayList((Object[])new String[]{this.resourceID});
                } else {
                    Collections.shuffle(resources);
                }
                this.resourceID = (String)resources.get(0);
                this.endpoint = endpoint;
                found = true;
                break;
            }
            logger.info("Initialized at : " + this.endpoint + " , " + this.resourceID);
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new IndexException("could not initialize random client", e);
        }
        if (found) return;
        throw new IndexException("could not initialize random client");
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getScope() {
        return this.scope;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public String getIndexID() {
        return this.indexID;
    }

    private static IndexServiceAPI getFullTextIndexServiceProxy(String endpoint) throws IndexException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        IndexServiceAPI simple = null;
        logger.info("getting proxy from index service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (IndexServiceAPI)target.proxy(IndexServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new IndexException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from index service...OK");
        return simple;
    }

    public boolean feedLocator(String resultSetLocation, String indexName, Boolean activate, Set<String> sids) throws IndexException {
        logger.info("calling feedLocator with parameters. resultSetLocation : " + resultSetLocation + ", indexName : " + indexName + ", activate : " + activate + ", sids : " + sids);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).feedLocator(this.scope, this.resourceID, resultSetLocation, indexName, activate, sids, Boolean.valueOf(false));
        logger.info("feedLocator returned");
        ResponseUtils.checkResponse(response, "feedLocator");
        return response.getStatus() == Response.Status.OK.getStatusCode();
    }

    public boolean feedLocatorSync(String resultSetLocation, String indexName, Boolean activate, Set<String> sids) throws IndexException {
        logger.info("calling feedLocatorSync with parameters. resultSetLocation : " + resultSetLocation + ", indexName : " + indexName + ", activate : " + activate + ", sids : " + sids);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).feedLocator(this.scope, this.resourceID, resultSetLocation, indexName, activate, sids, Boolean.valueOf(true));
        logger.info("feedLocatorSync returned");
        ResponseUtils.checkResponse(response, "feedLocatorSync");
        return response.getStatus() == Response.Status.OK.getStatusCode();
    }

    public boolean flush() throws IndexException {
        logger.info("calling flush");
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).flush(this.scope, this.resourceID);
        logger.info("flush returned");
        ResponseUtils.checkResponse(response, "flush");
        return response.getStatus() == Response.Status.OK.getStatusCode();
    }

    public List<ClusterResponse> clustering(String queryString, String queryHint) throws IndexException {
        return this.clustering(queryString, queryHint, null, 10, "ObjectID", Lists.newArrayList((Object[])new String[]{"title"}), Lists.newArrayList((Object[])new String[]{"description"}), Lists.newArrayList((Object[])new String[]{"gDocCollectionLang"}), null, null);
    }

    public List<ClusterResponse> clustering(String queryString, String queryHint, Set<String> sids, Integer numberOfClusters, String urlField, List<String> titleFields, List<String> contentFields, List<String> languageFields) throws IndexException {
        return this.clustering(queryString, queryHint, sids, numberOfClusters, urlField, titleFields, contentFields, languageFields, null, null);
    }

    public List<ClusterResponse> clustering(String queryString, String queryHint, Set<String> sids, Integer numberOfClusters, String urlField, List<String> titleFields, List<String> contentFields, List<String> languageFields, String algorithm, Integer searchHits) throws IndexException {
        logger.info("calling cluster with parameters. queryString : " + queryString + ", sids : " + sids + ", numberOfClusters : " + numberOfClusters + ", urlField : " + urlField + ", titleField : " + titleFields + ", contentField : " + contentFields + ", languageField : " + languageFields + ", algorithm : " + algorithm + ", searchHits : " + searchHits);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).clustering(this.scope, this.resourceID, queryString, queryHint, numberOfClusters, urlField, titleFields, contentFields, languageFields, algorithm, searchHits, sids, Boolean.valueOf(false), Boolean.valueOf(false));
        logger.info("cluster returned");
        ResponseUtils.checkResponse(response, "cluster");
        String json = (String)response.readEntity(String.class);
        response.close();
        List resp = (List)gson.fromJson(json, new TypeToken<List<ClusterResponse>>(){}.getType());
        return resp;
    }

    public Map<String, Integer> frequentTerms(String queryString, Set<String> sids) throws IndexException {
        return this.frequentTerms(queryString, sids, 10, true);
    }

    public Map<String, Integer> frequentTerms(String queryString, Set<String> sids, Boolean useRR) throws IndexException {
        return this.frequentTerms(queryString, sids, 10, useRR);
    }

    public Map<String, Integer> frequentTerms(String queryString, Set<String> sids, Integer maxTerms, Boolean useRR) throws IndexException {
        logger.info("calling frequentTerms with parameters. queryString : " + queryString + ", sids : " + sids + ", maxTerms : " + maxTerms + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).frequentTerms(this.scope, this.resourceID, queryString, maxTerms, sids, useRR, Boolean.valueOf(false));
        logger.info("frequentTerms returned");
        ResponseUtils.checkResponse(response, "frequentTerms");
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, Integer>>(){}.getType());
        return resp;
    }

    public String query(String queryString, Set<String> sids) throws IndexException {
        return this.query(queryString, sids, 0, -1, true);
    }

    public String query(String queryString, Set<String> sids, Boolean useRR) throws IndexException {
        return this.query(queryString, sids, 0, -1, useRR);
    }

    public String query(String queryString, Set<String> sids, Integer from, Integer count) throws IndexException {
        return this.query(queryString, sids, from, count, true);
    }

    public String query(String queryString, Set<String> sids, Integer from, Integer count, Boolean useRR) throws IndexException {
        logger.info("calling query with parameters. queryString : " + queryString + ", sids : " + sids + ", from : " + from + ", count : " + count + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).query(this.scope, this.resourceID, queryString, from, count, sids, useRR, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        logger.info("query returned");
        ResponseUtils.checkResponse(response, "query");
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        return (String)resp.get("grslocator");
    }

    public List<Map<String, String>> queryAndReadClientSide(String queryString, Set<String> sids) throws IndexException {
        return this.queryAndReadClientSide(queryString, sids, true);
    }

    public List<Map<String, String>> queryAndReadClientSide(String queryString, Set<String> sids, Boolean useRR) throws IndexException {
        return this.queryAndReadClientSide(queryString, sids, 0, -1, useRR);
    }

    public List<Map<String, String>> queryAndReadClientSide(String queryString, Set<String> sids, Integer from, Integer count) throws IndexException {
        return this.queryAndReadClientSide(queryString, sids, from, count, true);
    }

    public List<Map<String, String>> queryAndReadClientSide(String queryString, Set<String> sids, Integer from, Integer count, Boolean useRR) throws IndexException {
        logger.info("calling queryAndReadClientSide with parameters. queryString : " + queryString + ", sids : " + sids + ", from : " + from + ", count : " + count + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        String grsLocator = this.query(queryString, sids, from, count, useRR);
        logger.info("queryAndReadClientSide returned : " + grsLocator);
        try {
            List results = ResultReader.resultSetToRecords((String)grsLocator);
            return results;
        }
        catch (Exception e) {
            logger.error("could not read results from the grs2 locator : " + grsLocator, (Throwable)e);
            throw new IndexException("could not read results from the grs2 locator : " + grsLocator, e);
        }
    }

    public List<Map<String, String>> queryAndRead(String queryString, Set<String> sids, Boolean useRR) throws IndexException {
        return this.queryAndRead(queryString, sids, 0, -1, useRR);
    }

    public List<Map<String, String>> queryAndRead(String queryString, Set<String> sids) throws IndexException {
        return this.queryAndRead(queryString, sids, true);
    }

    public List<Map<String, String>> queryAndRead(String queryString, Set<String> sids, Integer from, Integer count) throws IndexException {
        return this.queryAndRead(queryString, sids, from, count, true);
    }

    public List<Map<String, String>> queryAndRead(String queryString, Set<String> sids, Integer from, Integer count, Boolean useRR) throws IndexException {
        logger.info("calling queryAndRead with parameters. queryString : " + queryString + ", sids : " + sids + ", from : " + from + ", count : " + count + ", useRR : " + useRR);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).query(this.scope, this.resourceID, queryString, from, count, sids, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        logger.info("queryAndRead returned");
        ResponseUtils.checkResponse(response, "queryAndRead");
        String json = (String)response.readEntity(String.class);
        response.close();
        try {
            List resp = (List)gson.fromJson(json, new TypeToken<List<Map<String, String>>>(){}.getType());
            return resp;
        }
        catch (Exception e) {
            logger.error("Unable to convert response to list of maps of strings : " + json);
            throw new IndexException("Unable to convert response to list of maps of strings " + json, e);
        }
    }

    public Boolean refresh() throws IndexException {
        logger.info("calling refresh");
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).refresh(this.scope, this.resourceID);
        logger.info("refresh returned");
        ResponseUtils.checkResponse(response, "refresh");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Boolean setCollectionsAndFields(List<String> collections, List<String> fields) throws IndexException {
        logger.info("calling setCollectionsAndFields with parameters. collections : " + collections + ", fields : " + fields);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).setCollectionsAndFields(this.scope, this.resourceID, collections, fields);
        logger.info("setCollectionsAndFields returned");
        ResponseUtils.checkResponse(response, "setCollectionsAndFields");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Boolean shutdown(Boolean delete) throws IndexException {
        logger.info("calling shutdown with parameters. delete : " + delete);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).shutdown(this.scope, this.resourceID, delete);
        logger.info("shutdown returned");
        ResponseUtils.checkResponse(response, "shutdown");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Boolean destroyCluster() throws IndexException {
        logger.info("calling destroyCluster");
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).destroyCluster(this.scope, this.resourceID);
        logger.info("destroyCluster returned");
        ResponseUtils.checkResponse(response, "destroyCluster");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Boolean destroy() throws IndexException {
        logger.info("calling destroy");
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).destroyResourceREST(this.scope, this.resourceID);
        logger.info("destroy returned");
        ResponseUtils.checkResponse(response, "destroy");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Boolean rebuildMetaIndex() throws IndexException {
        logger.info("calling rebuildMetaIndex");
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).rebuildMetaIndex(this.scope, this.resourceID);
        logger.info("rebuildMetaIndex returned");
        ResponseUtils.checkResponse(response, "rebuildMetaIndex");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Boolean deleteIndex(String indexName) throws IndexException {
        logger.info("calling deleteIndex with parameters. indexName : " + indexName);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).deleteIndex(this.scope, this.resourceID, indexName);
        logger.info("deleteIndex returned");
        ResponseUtils.checkResponse(response, "deleteIndex");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public Set<String> collectionsOfIndex(String indexName) throws IndexException {
        logger.info("calling collectionsOfIndex with parameters. indexName : " + indexName);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).collectionsOfIndex(this.scope, this.resourceID, indexName);
        logger.info("collectionsOfIndex returned");
        ResponseUtils.checkResponse(response, "collectionsOfIndex");
        String json = (String)response.readEntity(String.class);
        response.close();
        try {
            Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, Set<String>>>(){}.getType());
            return (Set)resp.get("response");
        }
        catch (Exception e) {
            logger.error("Unable to convert response to map strings : " + json);
            throw new IndexException("Unable to convert response to list of maps of strings " + json, e);
        }
    }

    public Set<String> indicesOfCollection(String collectionID) throws IndexException {
        logger.info("calling indicesOfCollection with parameters. collectionID : " + collectionID);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).indicesOfCollection(this.scope, this.resourceID, collectionID);
        logger.info("indicesOfCollection returned");
        ResponseUtils.checkResponse(response, "indicesOfCollection");
        String json = (String)response.readEntity(String.class);
        response.close();
        try {
            Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, Set<String>>>(){}.getType());
            return (Set)resp.get("response");
        }
        catch (Exception e) {
            logger.error("Unable to convert response to map strings : " + json);
            throw new IndexException("Unable to convert response to list of maps of strings " + json, e);
        }
    }

    public Integer collectionCount(String collectionID) throws IndexException {
        logger.info("calling collectionCount with parameters. collectionID : " + collectionID);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).collectionCount(this.scope, this.resourceID, collectionID);
        ResponseUtils.checkResponse(response, "collectionCount");
        logger.info("collectionCount returned");
        String json = (String)response.readEntity(String.class);
        response.close();
        try {
            Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, Integer>>(){}.getType());
            return (Integer)resp.get("response");
        }
        catch (Exception e) {
            logger.error("Unable to convert response to map strings : " + json);
            throw new IndexException("Unable to convert response to list of maps of strings " + json, e);
        }
    }

    public Boolean activateIndex(String indexName) throws IndexException {
        logger.info("calling activateIndex with parameters. indexName : " + indexName);
        logger.info(" ~> endpoint : " + this.endpoint + ", resourceID : " + this.resourceID + ", scope : " + this.scope);
        Response response = IndexClient.getFullTextIndexServiceProxy(this.endpoint).activateIndex(this.scope, this.resourceID, indexName);
        logger.info("activateIndex returned");
        ResponseUtils.checkResponse(response, "activateIndex");
        int status = response.getStatus();
        response.close();
        return status == Response.Status.OK.getStatusCode();
    }

    public static class Builder {
        private String endpoint;
        private String resourceID;
        private String scope;
        private String clusterID;
        private String indexID;
        private String collectionID;
        private final IndexDiscovererAPI<IndexResource> indexDiscoverer;

        @Inject
        public Builder(IndexDiscovererAPI<IndexResource> indexDiscoverer) {
            this.indexDiscoverer = indexDiscoverer;
        }

        public Builder() {
            this.indexDiscoverer = null;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder resourceID(String resourceID) {
            this.resourceID = resourceID;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder clusterID(String clusterID) {
            this.clusterID = clusterID;
            return this;
        }

        public Builder indexID(String indexID) {
            this.indexID = indexID;
            return this;
        }

        public Builder collectionID(String collectionID) {
            this.collectionID = collectionID;
            return this;
        }

        public IndexClient build() throws IndexException {
            return new IndexClient(this);
        }
    }
}

