package org.gcube.rest.index.client.inject;

import org.gcube.rest.commons.inject.EndpointKey;
import org.gcube.rest.commons.inject.GcubeScope;
import org.gcube.rest.commons.inject.ResourceClass;
import org.gcube.rest.commons.inject.ResourceNamePref;
import org.gcube.rest.commons.inject.ServiceClass;
import org.gcube.rest.commons.inject.ServiceName;
import org.gcube.rest.index.common.Constants;
import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.rest.resourcemanager.harvester.ResourceHarvester;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;

public class IndexClientModule implements Module {

	private String scope = "DEFAULT-SCOPE";

	public IndexClientModule(String scope) {
		this.scope = scope;
	}

	@Override
	public void configure(Binder binder) {
		binder.bind(String.class).annotatedWith(GcubeScope.class)
				.toInstance(this.scope);

		binder.bind(String.class).annotatedWith(ResourceClass.class)
				.toInstance(Constants.RESOURCE_CLASS);

		binder.bind(String.class).annotatedWith(ResourceNamePref.class)
				.toInstance(Constants.RESOURCE_CLASS);

		binder.bind(String.class).annotatedWith(EndpointKey.class)
				.toInstance(Constants.ENDPOINT_KEY);

		binder.bind(String.class).annotatedWith(ServiceClass.class)
				.toInstance(Constants.SERVICE_CLASS);

		binder.bind(String.class).annotatedWith(ServiceName.class)
				.toInstance(Constants.SERVICE_NAME);

		binder.bind(new TypeLiteral<IndexDiscovererAPI<IndexResource>>() {
		}).to(IndexDiscoverer.class).asEagerSingleton();

		binder.bind(RunningInstancesDiscoverer.class)
				.to(RIDiscovererISimpl.class).asEagerSingleton();

		binder.bind(new TypeLiteral<IResourceHarvester<IndexResource>>() {
		}).to(new TypeLiteral<ResourceHarvester<IndexResource>>() {
		}).asEagerSingleton();

	}

}
