/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.notifications.IsRegisteredCallback;
import org.gcube.indexmanagement.common.notifications.IsRegisteredNotificationRequest;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;
import org.gcube.indexmanagement.common.notifications.RegisterNotificationRequest;
import org.gcube.indexmanagement.common.notifications.UnregisterNotificationRequest;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.Topic;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleTopic;

public abstract class IndexWSResource
extends GCUBEWSResource {
    public static final String RP_INDEX_ID = "IndexID";
    public static final String RP_INDEX_TYPE_NAME = "IndexTypeName";
    public static final String RP_COLLECTION_ID = "CollectionID";
    public static final String RP_FIELDS = "Fields";
    public static final String RP_MODIFIED = "Modified";
    public static final String RP_CREATED = "Created";
    protected List<String> propNames;
    protected String namespace;
    protected boolean bInitializing = false;
    protected Object initLock = new Object();
    protected TopicRegistrar topicRegistrar;
    protected DestructionMode destructionMode;
    static GCUBELog logger = new GCUBELog(IndexWSResource.class);

    protected IndexWSResource() {
        this.propNames = new LinkedList<String>();
        this.topicRegistrar = new TopicRegistrar();
    }

    public void initialise(String namespace, String indexID, String indexTypeName, String[] collectionID) throws Exception {
        try {
            this.namespace = namespace;
            this.destructionMode = DestructionMode.FULL_DESTRUCTION;
            this.createProperty(RP_INDEX_ID);
            this.getResourcePropertySet().get(RP_INDEX_ID).clear();
            this.getResourcePropertySet().get(RP_INDEX_ID).add((Object)indexID);
            this.createProperty(RP_INDEX_TYPE_NAME);
            this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).clear();
            this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).add((Object)indexTypeName);
            this.createProperty(RP_COLLECTION_ID);
            int size = 0;
            if (collectionID != null) {
                size = collectionID.length;
            }
            this.getResourcePropertySet().get(RP_COLLECTION_ID).clear();
            for (int i = 0; i < size; ++i) {
                this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)collectionID[i]);
            }
            this.createProperty(RP_FIELDS);
            this.getResourcePropertySet().get(RP_FIELDS).clear();
            this.createProperty(RP_CREATED);
            this.getResourcePropertySet().get(RP_CREATED).clear();
            this.getResourcePropertySet().get(RP_CREATED).add((Object)Calendar.getInstance());
            this.createProperty(RP_MODIFIED);
            this.getResourcePropertySet().get(RP_MODIFIED).clear();
            this.getResourcePropertySet().get(RP_MODIFIED).add((Object)Calendar.getInstance());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialize index WS resource.", (Throwable)e);
            throw new Exception("Failed to initialize index WS resource.", e);
        }
    }

    protected void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        int i;
        this.getServiceContext().setScope(GCUBEScope.getScope((String)((String)this.getResourcePropertySet().getScope().get(0))));
        this.destructionMode = DestructionMode.FULL_DESTRUCTION;
        this.namespace = (String)ois.readObject();
        String indexID = (String)ois.readObject();
        this.createProperty(RP_INDEX_ID);
        this.getResourcePropertySet().get(RP_INDEX_ID).clear();
        this.getResourcePropertySet().get(RP_INDEX_ID).add((Object)indexID);
        String indexTypeName = (String)ois.readObject();
        this.createProperty(RP_INDEX_TYPE_NAME);
        this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).clear();
        this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).add((Object)indexTypeName);
        int size = ois.readInt();
        this.createProperty(RP_COLLECTION_ID);
        this.getResourcePropertySet().get(RP_COLLECTION_ID).clear();
        for (i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)((String)ois.readObject()));
        }
        size = ois.readInt();
        this.createProperty(RP_FIELDS);
        this.getResourcePropertySet().get(RP_FIELDS).clear();
        for (i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_FIELDS).add((Object)((String)ois.readObject()));
        }
        Calendar created = (Calendar)ois.readObject();
        this.createProperty(RP_CREATED);
        this.getResourcePropertySet().get(RP_CREATED).clear();
        this.getResourcePropertySet().get(RP_CREATED).add((Object)created);
        Calendar modified = (Calendar)ois.readObject();
        this.createProperty(RP_MODIFIED);
        this.getResourcePropertySet().get(RP_MODIFIED).clear();
        this.getResourcePropertySet().get(RP_MODIFIED).add((Object)modified);
    }

    protected void onStore(ObjectOutputStream oos) throws Exception {
        int i;
        oos.writeObject(this.namespace);
        oos.writeObject((String)this.getResourcePropertySet().get(RP_INDEX_ID).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).get(0));
        int size = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
        oos.writeInt(size);
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_COLLECTION_ID).get(i));
        }
        size = this.getResourcePropertySet().get(RP_FIELDS).size();
        oos.writeInt(size);
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_FIELDS).get(i));
        }
        oos.writeObject((Calendar)this.getResourcePropertySet().get(RP_CREATED).get(0));
        oos.writeObject((Calendar)this.getResourcePropertySet().get(RP_MODIFIED).get(0));
    }

    public void store() {
        if (!this.isInitializing()) {
            super.store();
        }
    }

    public ResourceProperty createProperty(String propName) throws Exception {
        ResourceProperty prop = this.getProperty(propName);
        this.getResourcePropertySet().add(prop);
        this.propNames.add(propName);
        return prop;
    }

    public ResourceProperty createProperty(String propName, String nameSpace) throws Exception {
        SimpleResourceProperty prop = new SimpleResourceProperty(new QName(nameSpace, propName));
        this.getResourcePropertySet().add((ResourceProperty)prop);
        this.propNames.add(propName);
        return prop;
    }

    public SimpleTopic createTopic(String topicName, String nameSpace) throws Exception {
        SimpleTopic topic = new SimpleTopic(new QName(nameSpace, topicName));
        this.topicRegistrar.addTopicToRegister(topic);
        return topic;
    }

    public SimpleTopic createTopic(String topicName) throws Exception {
        SimpleTopic topic = new SimpleTopic(new QName(this.getPorttypeContext().getNamespace(), topicName));
        this.topicRegistrar.addTopicToRegister(topic);
        return topic;
    }

    protected String[] getPropertyNames() {
        return this.propNames.toArray(new String[this.propNames.size()]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIndexID() {
        return (String)this.getResourcePropertySet().get(RP_INDEX_ID).get(0);
    }

    public void setIndexID(String indexID) {
        this.getResourcePropertySet().get(RP_INDEX_ID).clear();
        this.getResourcePropertySet().get(RP_INDEX_ID).add((Object)indexID);
    }

    public String[] getCollectionID() {
        int size = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
        String[] colIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            colIDs[i] = (String)this.getResourcePropertySet().get(RP_COLLECTION_ID).get(i);
        }
        return colIDs;
    }

    public String[] getFields() {
        int size = this.getResourcePropertySet().get(RP_FIELDS).size();
        String[] fields = new String[size];
        for (int i = 0; i < size; ++i) {
            fields[i] = (String)this.getResourcePropertySet().get(RP_FIELDS).get(i);
        }
        return fields;
    }

    public void setCollectionID(String[] collectionIDs) throws Exception {
        if (collectionIDs == null) {
            logger.warn((Object)"Null for the collectionIDs to be set");
            return;
        }
        int size = collectionIDs.length;
        this.getResourcePropertySet().get(RP_COLLECTION_ID).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)collectionIDs[i]);
        }
    }

    public void setFields(String[] fields) throws Exception {
        if (fields == null) {
            logger.warn((Object)"Null for the fields to be set");
            return;
        }
        int size = fields.length;
        this.getResourcePropertySet().get(RP_FIELDS).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_FIELDS).add((Object)fields[i]);
        }
    }

    public void addCollectionID(String collectionID) {
        String[] collections = this.getCollectionID();
        String[] newCollections = new String[collections.length + 1];
        for (int i = 0; i < collections.length; ++i) {
            newCollections[i] = collections[i];
            if (!collections[i].equals(collectionID)) continue;
            logger.warn((Object)("Info: ColID:" + collectionID + ", is already added"));
            return;
        }
        newCollections[collections.length] = collectionID;
        try {
            this.setCollectionID(newCollections);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to set CollectionID resource property.", (Throwable)e);
        }
    }

    public void addField(String field) {
        String[] fields = this.getFields();
        String[] newFields = new String[fields.length + 1];
        for (int i = 0; i < fields.length; ++i) {
            newFields[i] = fields[i];
            if (!fields[i].equals(field)) continue;
            logger.warn((Object)("Info: Field:" + field + ", is already added"));
            return;
        }
        newFields[fields.length] = field;
        try {
            this.setFields(newFields);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to set Fields resource property.", (Throwable)e);
        }
    }

    public String getIndexTypeName() {
        return (String)this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).get(0);
    }

    public void setIndexTypeName(String indexTypeName) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).clear();
            this.getResourcePropertySet().get(RP_INDEX_TYPE_NAME).add((Object)indexTypeName);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public Calendar getCreated() {
        return (Calendar)this.getResourcePropertySet().get(RP_CREATED).get(0);
    }

    public void setCreated(Calendar created) {
        this.getResourcePropertySet().get(RP_CREATED).clear();
        this.getResourcePropertySet().get(RP_CREATED).add((Object)created);
    }

    public Calendar getModified() {
        return (Calendar)this.getResourcePropertySet().get(RP_MODIFIED).get(0);
    }

    public void setModified(Calendar modified) {
        this.getResourcePropertySet().get(RP_MODIFIED).clear();
        this.getResourcePropertySet().get(RP_MODIFIED).add((Object)modified);
    }

    public boolean isInitializing() {
        return this.bInitializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsInitializing(boolean isInitializing) {
        Object object = this.initLock;
        synchronized (object) {
            this.bInitializing = isInitializing;
            if (!isInitializing) {
                this.initLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilInitialized() {
        Object object = this.initLock;
        synchronized (object) {
            while (this.isInitializing()) {
                try {
                    this.initLock.wait();
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Interrupted Exception while waiting for WS resource initialization: ", (Throwable)e);
                }
            }
        }
    }

    protected void filterFieldInfo(ArrayList<String> presentableFields, ArrayList<String> searchableFields) {
        presentableFields.clear();
        searchableFields.clear();
        HashSet<String> searchableSet = new HashSet<String>();
        HashSet<String> presentableSet = new HashSet<String>();
        for (String field : this.getFields()) {
            String fieldName = IndexWSResource.getFieldName(field, "p");
            if (fieldName != null) {
                if (!presentableSet.add(fieldName)) continue;
                logger.trace((Object)("added presentable field: " + fieldName));
                presentableFields.add(fieldName);
                continue;
            }
            fieldName = IndexWSResource.getFieldName(field, "s");
            if (!searchableSet.add(fieldName)) continue;
            logger.trace((Object)("added searchable field: " + fieldName));
            searchableFields.add(fieldName);
        }
    }

    private static String getFieldName(String field, String type) {
        int from = field.indexOf(":", field.indexOf(":") + 1) + 1;
        String t = field.substring(from, from + type.length());
        if (!t.equals(type)) {
            return null;
        }
        from = field.indexOf(":", from) + 1;
        return field.substring(from);
    }

    public DestructionMode getDestructionMode() {
        return this.destructionMode;
    }

    public void setDestructionMode(DestructionMode mode) {
        this.destructionMode = mode;
    }

    public void onResourceRemoval() {
    }

    public void publish(GCUBEScope ... scopes) throws ResourceException {
        super.publish(scopes);
        for (SimpleTopic t : this.topicRegistrar.getTopicsToBeRegistered()) {
            this.getTopicList().addTopic((Topic)t);
        }
        this.topicRegistrar.unregisterAndReregisterTopics();
    }

    public boolean isTopicRegistered(SimpleTopic topic) throws Exception {
        return this.topicRegistrar.isTopicRegistered(topic);
    }

    private class TopicRegistrar
    extends Thread {
        private LinkedList<SimpleTopic> topicsToBeRegistered;
        private LinkedList<SimpleTopic> registeredTopics;

        TopicRegistrar() {
            try {
                this.topicsToBeRegistered = new LinkedList();
                this.registeredTopics = new LinkedList();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        synchronized void addTopicToRegister(SimpleTopic topic) throws Exception {
            this.topicsToBeRegistered.add(topic);
            logger.debug((Object)("Topic added to the list of topics to be registered: " + topic.getName()));
        }

        void unregisterAndReregisterTopics() {
            if (this.topicsToBeRegistered.size() > 0) {
                this.start();
            }
        }

        List<SimpleTopic> getTopicsToBeRegistered() {
            return this.topicsToBeRegistered;
        }

        synchronized boolean isTopicRegistered(SimpleTopic topic) throws Exception {
            return this.registeredTopics.contains(topic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SimpleTopic t;
            IsRegisteredCallback callback1;
            LinkedList bRegistered;
            GCUBEServiceContext sctx = IndexWSResource.this.getServiceContext();
            GCUBEScope scope = sctx.getScope() != null ? sctx.getScope() : GCUBEScope.getScope((String)((String)IndexWSResource.this.getResourcePropertySet().getScope().get(0)));
            LinkedList<SimpleTopic> alreadyRegisteredTopics = new LinkedList<SimpleTopic>();
            LinkedList<SimpleTopic> topicsToBeRemoved = new LinkedList<SimpleTopic>();
            EndpointReferenceType myEpr = null;
            try {
                myEpr = IndexWSResource.this.getEPR();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get my own EPR!", (Throwable)e);
                return;
            }
            LinkedList<ISNotifier.TopicData> l = new LinkedList<ISNotifier.TopicData>();
            for (SimpleTopic t2 : this.topicsToBeRegistered) {
                l.add(new ISNotifier.TopicData(t2.getName(), myEpr));
            }
            final Object monitor = new Object();
            final LinkedList bIsAlreadyRegistered = new LinkedList();
            IsRegisteredCallback callback = new IsRegisteredCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void isRegisteredResponse(boolean[] response) {
                    for (boolean b : response) {
                        bIsAlreadyRegistered.add(b);
                    }
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                }
            };
            Object object = monitor;
            synchronized (object) {
                NotifierRequestQueue.getInstance().add(new IsRegisteredNotificationRequest(l, sctx, scope, callback));
                while (true) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            logger.info((Object)"Old registrations test done.");
            for (int i = 0; i < bIsAlreadyRegistered.size(); ++i) {
                if (!((Boolean)bIsAlreadyRegistered.get(i)).booleanValue()) continue;
                alreadyRegisteredTopics.add(this.topicsToBeRegistered.get(i));
            }
            if (!alreadyRegisteredTopics.isEmpty()) {
                logger.debug((Object)"Starting removal of old topic registrations...");
                NotifierRequestQueue.getInstance().add(new UnregisterNotificationRequest(myEpr, alreadyRegisteredTopics, sctx, scope));
                while (true) {
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    l.clear();
                    for (SimpleTopic t3 : alreadyRegisteredTopics) {
                        l.add(new ISNotifier.TopicData(t3.getName(), myEpr));
                    }
                    final Object monitor1 = new Object();
                    bRegistered = new LinkedList();
                    callback1 = new IsRegisteredCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void isRegisteredResponse(boolean[] response) {
                            for (boolean b : response) {
                                bRegistered.add(b);
                            }
                            Object object = monitor1;
                            synchronized (object) {
                                monitor1.notify();
                            }
                        }
                    };
                    Object object2 = monitor1;
                    synchronized (object2) {
                        NotifierRequestQueue.getInstance().add(new IsRegisteredNotificationRequest(l, sctx, scope, callback1));
                        while (true) {
                            try {
                                monitor1.wait();
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            break;
                        }
                    }
                    for (int i = 0; i < bRegistered.size(); ++i) {
                        if (((Boolean)bRegistered.get(i)).booleanValue()) continue;
                        t = alreadyRegisteredTopics.get(i);
                        topicsToBeRemoved.add(t);
                        logger.debug((Object)("Topic unregistration completed: " + t.getName()));
                    }
                    TopicRegistrar i = this;
                    synchronized (i) {
                        if (topicsToBeRemoved.size() > 0) {
                            alreadyRegisteredTopics.removeAll(topicsToBeRemoved);
                            if (alreadyRegisteredTopics.isEmpty()) {
                                logger.info((Object)"All old topic registrations removed.");
                                break;
                            }
                            topicsToBeRemoved.clear();
                        }
                    }
                    logger.info((Object)("Still waiting for " + alreadyRegisteredTopics.size() + " old topic registrations to be removed."));
                }
            }
            try {
                logger.debug((Object)"Starting registration of new topics...");
                NotifierRequestQueue.getInstance().add(new RegisterNotificationRequest(myEpr, this.topicsToBeRegistered, sctx, scope));
                logger.debug((Object)"Topic registration started.");
            }
            catch (Exception e) {
                logger.error((Object)"Error while registering topics.");
            }
            while (true) {
                try {
                    Thread.sleep(20000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                l.clear();
                topicsToBeRemoved.clear();
                for (SimpleTopic t3 : this.topicsToBeRegistered) {
                    l.add(new ISNotifier.TopicData(t3.getName(), myEpr));
                }
                final Object monitor1 = new Object();
                bRegistered = new LinkedList();
                callback1 = new IsRegisteredCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void isRegisteredResponse(boolean[] response) {
                        for (boolean b : response) {
                            bRegistered.add(b);
                        }
                        Object object = monitor1;
                        synchronized (object) {
                            monitor1.notify();
                        }
                    }
                };
                Object i = monitor1;
                synchronized (i) {
                    NotifierRequestQueue.getInstance().add(new IsRegisteredNotificationRequest(l, sctx, scope, callback1));
                    while (true) {
                        try {
                            monitor1.wait();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        break;
                    }
                }
                for (int i2 = 0; i2 < bRegistered.size(); ++i2) {
                    if (!((Boolean)bRegistered.get(i2)).booleanValue()) continue;
                    t = this.topicsToBeRegistered.get(i2);
                    topicsToBeRemoved.add(t);
                    TopicRegistrar topicRegistrar = this;
                    synchronized (topicRegistrar) {
                        this.registeredTopics.add(t);
                    }
                    logger.debug((Object)("Topic registration completed: " + t.getName()));
                }
                if (topicsToBeRemoved.size() <= 0) continue;
                this.topicsToBeRegistered.removeAll(topicsToBeRemoved);
                if (this.topicsToBeRegistered.isEmpty()) break;
            }
            logger.info((Object)"All topic registrations completed!");
        }
    }

    public static enum DestructionMode {
        FULL_DESTRUCTION,
        REMOVAL_ONLY;

    }
}

