/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.ArrayList;
import java.util.Collections;
import org.gcube.indexmanagement.featureindexlibrary.commons.NormalizeResults;
import org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.SortAscRankedResultComparator;

public class LookupBuffer {
    private ArrayList<RankedResultElement> buffer = null;
    private int k = 0;
    private boolean normalized = false;

    public LookupBuffer(int k) {
        this.buffer = new ArrayList(k);
        this.k = k;
    }

    public ArrayList<RankedResultElement> getResults(String indexName) {
        if (!this.normalized) {
            NormalizeResults.normalize(this.buffer, indexName);
            this.normalized = true;
        }
        return this.buffer;
    }

    public float process(RankedResultElement element) {
        if (this.buffer.size() < this.k) {
            this.addToBuffer(element);
            return Float.MAX_VALUE;
        }
        this.replaceInBuffer(element);
        return this.buffer.get(this.buffer.size() - 1).getRank();
    }

    private void addToBuffer(RankedResultElement element) {
        this.buffer.add(element);
        Collections.sort(this.buffer, new SortAscRankedResultComparator());
    }

    private void replaceInBuffer(RankedResultElement element) {
        this.addToBuffer(element);
        this.buffer.remove(this.buffer.size() - 1);
    }
}

