/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo.ranking;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Comparator;
import org.gcube.indexmanagement.geo.DataWrapper;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.InclusionType;
import org.gcube.indexmanagement.geo.ranking.RankEvaluatorInitializationException;
import org.gcube.indexmanagement.geo.shape.Polygon;
import org.gcube.indexmanagement.geo.shape.Rectangle;

public abstract class RankEvaluator
implements Comparator<DataWrapper> {
    protected Polygon polygon;
    protected Envelope query;
    protected GeoIndexType indexType = null;
    protected InclusionType containmentMethod;
    protected boolean reverseSort;

    @Override
    public final int compare(DataWrapper data1, DataWrapper data2) {
        if (!this.reverseSort) {
            return new Double(this.rank(data2)).compareTo(new Double(this.rank(data1)));
        }
        return new Double(this.rank(data1)).compareTo(new Double(this.rank(data2)));
    }

    public final void init(Polygon polygon, InclusionType containmentMethod, Boolean reverseSort, GeoIndexType indexType, String[] args) throws RankEvaluatorInitializationException {
        this.polygon = polygon;
        Rectangle rect = polygon.getBoundingBox();
        this.query = new Envelope((double)rect.getMinX(), (double)rect.getMaxX(), (double)rect.getMinY(), (double)rect.getMaxY());
        this.containmentMethod = containmentMethod;
        if (reverseSort == null) {
            reverseSort = false;
        }
        this.reverseSort = reverseSort;
        this.indexType = indexType;
        if (args == null) {
            args = new String[]{};
        }
        this.initialize(args);
    }

    protected abstract void initialize(String[] var1) throws RankEvaluatorInitializationException;

    public abstract boolean isIndexTypeCompatible(GeoIndexType var1);

    public abstract double rank(DataWrapper var1);
}

