/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.indexmanagement.common.IndexNotificationConsumer;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;
import org.gcube.indexmanagement.common.notifications.SubscribeToNotificationRequest;
import org.gcube.indexmanagement.common.notifications.UnsubscribeFromNotificationRequest;
import org.globus.wsrf.Topic;
import org.w3c.dom.Element;

public abstract class IndexLookupWSResource
extends IndexWSResource {
    public static final String RP_CONNECTION_ID = "ConnectionID";
    public static final String RP_DOCCOUNT = "DocumentCount";
    public static final String RP_SUPPORTED_RELATIONS = "SupportedRelations";
    private static final String STATE_CHANGE_TOPIC_NAME = "SharedStateChange";
    private static final String INDEX_UPDATE_TOPIC_NAME = "UpdateNotification";
    protected QName sharedStateChangeTopicName;
    protected Topic indexChangeTopic;
    private String managementServiceNamespace;
    private String dataDir;

    public void initialise(String namespace, String managementServiceNamespace, String indexID, String indexTypeName, String[] collectionID, String dataDir, String[] supportedRelations) throws Exception {
        super.initialise(namespace, indexID, indexTypeName, collectionID);
        this.managementServiceNamespace = managementServiceNamespace;
        this.dataDir = dataDir;
        this.createProperty(RP_CONNECTION_ID);
        this.createProperty(RP_DOCCOUNT);
        this.getResourcePropertySet().get(RP_DOCCOUNT).clear();
        this.getResourcePropertySet().get(RP_DOCCOUNT).add((Object)new Integer(0));
        this.createProperty(RP_SUPPORTED_RELATIONS);
        int size = supportedRelations.length;
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)supportedRelations[i]);
        }
        this.sharedStateChangeTopicName = new QName(managementServiceNamespace + "/" + indexID, STATE_CHANGE_TOPIC_NAME);
        ArrayList<QName> topicSubscriptions = new ArrayList<QName>();
        topicSubscriptions.add(this.sharedStateChangeTopicName);
        GCUBEScope scope = this.getServiceContext().getScope();
        NotifierRequestQueue.getInstance().add(new SubscribeToNotificationRequest(topicSubscriptions, new ConsumerNotification(scope), this.getServiceContext(), scope));
        logger.debug((Object)("Consumer subscribed for notification on topic: " + this.sharedStateChangeTopicName));
        this.indexChangeTopic = this.createTopic(INDEX_UPDATE_TOPIC_NAME, namespace + "/" + indexID);
    }

    @Override
    protected void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        super.onLoad(ois, firstLoad);
        this.createProperty(RP_CONNECTION_ID);
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_CONNECTION_ID).add((Object)ois.readInt());
        }
        Integer docCount = ois.readInt();
        this.createProperty(RP_DOCCOUNT);
        this.getResourcePropertySet().get(RP_DOCCOUNT).clear();
        this.getResourcePropertySet().get(RP_DOCCOUNT).add((Object)docCount);
        this.managementServiceNamespace = (String)ois.readObject();
        this.dataDir = (String)ois.readObject();
        size = ois.readInt();
        this.createProperty(RP_SUPPORTED_RELATIONS);
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)((String)ois.readObject()));
        }
        if (firstLoad) {
            this.sharedStateChangeTopicName = new QName(this.managementServiceNamespace + "/" + this.getIndexID(), STATE_CHANGE_TOPIC_NAME);
            ArrayList<QName> topicSubscriptions = new ArrayList<QName>();
            topicSubscriptions.add(this.sharedStateChangeTopicName);
            GCUBEScope scope = GCUBEScope.getScope((String)((String)this.getResourcePropertySet().getScope().get(0)));
            NotifierRequestQueue.getInstance().add(new SubscribeToNotificationRequest(topicSubscriptions, new ConsumerNotification(scope), this.getServiceContext(), scope));
            logger.debug((Object)("Consumer subscribed for notification on topic: " + this.sharedStateChangeTopicName));
        }
        this.indexChangeTopic = this.createTopic(INDEX_UPDATE_TOPIC_NAME, this.namespace + "/" + this.getIndexID());
    }

    @Override
    protected void onStore(ObjectOutputStream oos) throws Exception {
        int i;
        super.onStore(oos);
        int size = this.getResourcePropertySet().get(RP_CONNECTION_ID).size();
        oos.writeInt(size);
        for (i = 0; i < size; ++i) {
            oos.writeInt((Integer)this.getResourcePropertySet().get(RP_CONNECTION_ID).get(i));
        }
        oos.writeInt((Integer)this.getResourcePropertySet().get(RP_DOCCOUNT).get(0));
        oos.writeObject(this.managementServiceNamespace);
        oos.writeObject(this.dataDir);
        size = this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).size();
        oos.writeInt(size);
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).get(i));
        }
    }

    public void sendIndexChangeNotification(Object message) {
        try {
            this.indexChangeTopic.notify(message);
            logger.debug((Object)("Index update notification sent on topic: " + this.indexChangeTopic.getName()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to send index update notification.", (Throwable)e);
        }
    }

    public int getConnectionID() {
        return (Integer)this.getResourcePropertySet().get(RP_CONNECTION_ID).get(0);
    }

    public void setConnectionID(int connectionID) {
        this.getResourcePropertySet().get(RP_CONNECTION_ID).clear();
        this.getResourcePropertySet().get(RP_CONNECTION_ID).add((Object)connectionID);
    }

    public void addConnectionID(Integer connectionID) {
        this.getResourcePropertySet().get(RP_CONNECTION_ID).add((Object)connectionID);
    }

    public void setDocumentCount(int documentCount) {
        this.getResourcePropertySet().get(RP_DOCCOUNT).clear();
        this.getResourcePropertySet().get(RP_DOCCOUNT).add((Object)new Integer(documentCount));
    }

    public int getDocumentCount() {
        return (Integer)this.getResourcePropertySet().get(RP_DOCCOUNT).get(0);
    }

    public String[] getSupportedRelations() {
        int size = this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).size();
        String[] relations = new String[size];
        for (int i = 0; i < size; ++i) {
            relations[i] = (String)this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).get(i);
        }
        return relations;
    }

    public void setSupportedRelations(String[] relations) throws Exception {
        int size = relations.length;
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)relations[i]);
        }
    }

    public void changeDocumentCount(int change) {
        this.setDocumentCount(this.getDocumentCount() + change);
    }

    public String getIndexDataDirectory() {
        return this.dataDir;
    }

    public String getManagementResourceNamespace() {
        return this.managementServiceNamespace;
    }

    @Override
    public void onResourceRemoval() {
        super.onResourceRemoval();
        try {
            ArrayList<QName> topicSubscriptions = new ArrayList<QName>();
            topicSubscriptions.add(this.sharedStateChangeTopicName);
            NotifierRequestQueue.getInstance().add(new UnsubscribeFromNotificationRequest(topicSubscriptions, this.getServiceContext(), GCUBEScope.getScope((String)((String)this.getResourcePropertySet().getScope().get(0)))));
            logger.debug((Object)("Consumer unsubscribed from notification on topic: " + this.sharedStateChangeTopicName + " for index: " + this.getIndexID()));
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to unregister notification topics from the IS.", (Throwable)e);
        }
    }

    public abstract void onLookupNotificationReceived(Element var1);

    public class ConsumerNotification
    extends IndexNotificationConsumer {
        public ConsumerNotification(GCUBEScope scope) {
            super(IndexLookupWSResource.this, scope);
        }

        @Override
        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            logger.debug((Object)"Index notification consumer received notification message.");
            Element message = null;
            try {
                message = (Element)((ISNotifier.NotificationMessage)event.getPayload()).getMessageObject();
                IndexLookupWSResource.this.onLookupNotificationReceived(message);
            }
            catch (Exception e) {
                logger.debug((Object)"Error in onNotificationReceived.", (Throwable)e);
            }
        }
    }
}

