/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.fullscan;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.fullscan.FullScanParams;

public class FullScanReader {
    private static Logger log = Logger.getLogger(FullScanReader.class);
    private FileInputStream fis = null;
    private BufferedInputStream bis = null;
    private DataInputStream ds = null;

    private String getString() throws Exception {
        int count = this.ds.readInt();
        char[] charA = new char[count];
        for (int i = 0; i < count; ++i) {
            charA[i] = this.ds.readChar();
        }
        String ret = new String(charA);
        if (ret.startsWith("-")) {
            return "";
        }
        return ret;
    }

    private float[] getVector() throws Exception {
        int count = this.ds.readInt();
        float[] vector = new float[count];
        for (int i = 0; i < count; ++i) {
            vector[i] = this.ds.readFloat();
        }
        return vector;
    }

    public FullScanReader(String file) throws Exception {
        try {
            this.fis = new FileInputStream(file);
            this.bis = new BufferedInputStream(this.fis);
            this.ds = new DataInputStream(this.bis);
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize reader. thrpowing exception", (Throwable)e);
            throw new Exception("Could not initialize reader");
        }
    }

    public FullScanParams getCharacteristics() throws Exception {
        try {
            long elementCount = this.ds.readLong();
            String distanceMeasure = this.getString();
            String featureName = this.getString();
            String indexID = this.getString();
            String indexName = this.getString();
            String storage = this.getString();
            FullScanParams charact = new FullScanParams(featureName, FIEnums.DistanceTypes.valueOf(distanceMeasure));
            charact.setElementCount(elementCount);
            charact.setIndexID(indexID);
            charact.setIndexName(indexName);
            charact.setStorage(storage);
            return charact;
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve charachteristics. thrpowing exception", (Throwable)e);
            throw new Exception("Could not retrieve charachteristics");
        }
    }

    public FeatureVectorElement getElement() {
        try {
            float[] vector;
            String id;
            do {
                id = this.getString();
                vector = this.getVector();
            } while (id.length() == 0);
            return new FeatureVectorElement(id, vector);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read element. assuming eof", (Throwable)e);
            return null;
        }
    }

    public void close() throws Exception {
        try {
            this.fis.close();
            this.bis.close();
            this.ds.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close reader. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close reader");
        }
    }
}

