/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.merger;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureFactoryStatsContainer;
import org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.SortDescMergedResultComparator;
import org.gcube.indexmanagement.featureindexlibrary.merger.MergedResultElement;
import org.gcube.indexmanagement.featureindexlibrary.merger.RankedMergeElement;

public class ResultMerger {
    private int k = 0;
    private FeatureFactoryStatsContainer stats = null;

    public ResultMerger(int k, FeatureFactoryStatsContainer stats) {
        this.k = k;
        this.stats = stats;
    }

    public List<MergedResultElement> merge(RankedMergeElement[] results) {
        long start = Calendar.getInstance().getTimeInMillis();
        ArrayList<MergedResultElement> res = new ArrayList<MergedResultElement>(this.k);
        Hashtable[] hashes = new Hashtable[results.length];
        float[] minRank = new float[results.length];
        float bestScore = 0.0f;
        for (int i = 0; i < results.length; ++i) {
            bestScore += results[i].getWeight();
        }
        HashSet<String> oids = new HashSet<String>();
        for (int i = 0; i < results.length; ++i) {
            hashes[i] = new Hashtable(results[i].getResults().size());
            minRank[i] = results[i].getResults().get(results[i].getResults().size() - 1).getRank();
            for (int q = 0; q < results[i].getResults().size(); ++q) {
                oids.add(results[i].getResults().get(q).getId());
                hashes[i].put(results[i].getResults().get(q).getId(), results[i].getResults().get(q));
            }
        }
        for (String oid : oids) {
            float rank = 0.0f;
            MergedResultElement mres = new MergedResultElement(oid);
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < hashes.length; ++i) {
                RankedResultElement elem = (RankedResultElement)hashes[i].get(oid);
                if (elem == null) {
                    rank += results[i].getWeight() * minRank[i];
                    continue;
                }
                rank += results[i].getWeight() * elem.getRank();
                names.add(elem.getIndexName());
            }
            mres.setRank(rank /= bestScore);
            mres.setIndexNames(names);
            res.add(mres);
        }
        Collections.sort(res, new SortDescMergedResultComparator());
        this.stats.mergeTime(Calendar.getInstance().getTimeInMillis() - start);
        this.stats.mergeResults(res.size());
        return res.subList(0, this.k);
    }
}

