/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.IOHelper;

public class VectorFileRandomAccess {
    private static Logger log = Logger.getLogger(VectorFileRandomAccess.class);
    private VAFileParams params = null;
    private RandomAccessFile rand = null;
    private IOHelper helper = null;
    private long startOffset = 0L;

    public VectorFileRandomAccess(VAFileParams params) throws Exception {
        this.params = params;
        this.helper = new IOHelper();
        this.helper.setIDLength(params.getIDLength());
        this.helper.setVectorLength(params.getVectorLength());
    }

    public void open() throws Exception {
        try {
            this.rand = new RandomAccessFile(FileHelper.getVAFVectorFile(this.params.getStorage(), this.params.getIndexID()), "rw");
            this.helper.skipHeader(this.rand);
            this.startOffset = this.rand.getFilePointer();
        }
        catch (Exception e) {
            log.error((Object)"Could not create reader, Throwing Exception", (Throwable)e);
            throw new Exception("Could not create reader");
        }
    }

    public void moveTo(long recNum) throws Exception {
        try {
            this.rand.seek(this.startOffset + recNum * this.params.getVectorEntryLength());
        }
        catch (Exception e) {
            log.error((Object)("Could not seek to record " + recNum + ". Throwing Exception"), (Throwable)e);
            throw new Exception("Could not seek to record " + recNum);
        }
    }

    public void write(VectorFileEntry entry) throws Exception {
        if (entry.getVector().length != this.params.getVectorLength() || entry.getId().length() != this.params.getIDLength()) {
            throw new Exception("new entry dimentions don't match");
        }
        try {
            this.helper.writeRecord(entry, this.rand);
        }
        catch (Exception e) {
            log.error((Object)"Could not write record. Throwing Exception", (Throwable)e);
            throw new Exception("Could not write record");
        }
    }

    public VectorFileEntry read() throws Exception {
        try {
            return this.helper.readRecord(this.rand);
        }
        catch (Exception e) {
            log.error((Object)"Could not read record. Throwing Exception", (Throwable)e);
            throw new Exception("Could not read record");
        }
    }

    public void close() throws Exception {
        try {
            this.rand.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close reader. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close reader");
        }
    }
}

