/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.gcube.indexmanagement.gcqlwrapper.GcqlProcessor;
import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;
import org.gcube.indexmanagement.lucenewrapper.LuceneGcqlQueryContainer;
import org.gcube.indexmanagement.lucenewrapper.LuceneSearcher;
import org.gcube.indexmanagement.lucenewrapper.QuerySnippetTermsPair;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class LuceneGcqlProcessor
extends GcqlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LuceneGcqlProcessor.class);
    private static final String DISTINCT = "distinct";
    private boolean distinct = false;
    private static final String LUCENE_AND = " AND ";
    private static final String LUCENE_OR = " OR ";
    private static final String LUCENE_NOT = " NOT ";
    private LinkedHashMap<String, String> projectedFields = new LinkedHashMap();
    private HashMap<String, ArrayList<String>> snippetTerm = new HashMap();

    public static void main(String[] args) {
        ArrayList<String> presentable = new ArrayList<String>();
        ArrayList<String> searchable = new ArrayList<String>();
        presentable.add("title");
        presentable.add("author");
        presentable.add("year");
        presentable.add("code");
        searchable.add("title");
        searchable.add("author");
        searchable.add("year");
        searchable.add("description");
        searchable.add("anotations");
        String query = "((((gDocCollectionID == \"14c1decd-347f-4783-81be-53119af7acf1\") and (title == \"*\"))) and (allIndexes = a*)) project *";
        query = "((title == \"*\") and ((gDocCollectionID == \"5b268db0-9d63-11de-8d8f-a04a2d1ca936\") and (title > 2))) project title sortby title/distinct";
        try {
            QuerySnippetTermsPair luceneQuery = ((LuceneGcqlQueryContainer)new LuceneGcqlProcessor().processQuery(presentable, searchable, query, null)).getLuceneQuery();
            System.out.println("*" + luceneQuery.query + "*");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public GcqlQueryContainer processQuery(ArrayList<String> presentableFields, ArrayList<String> searchableFields, String gCQLQuery, RRadaptor adaptor) throws Exception {
        this.presentableFields = presentableFields;
        this.searchableFields = searchableFields;
        this.adaptor = adaptor;
        logger.trace("Number of Presentable Fields: " + this.presentableFields.size() + ", Number of Searchable Fields: " + this.searchableFields.size());
        logger.trace("Presentable Fields: " + this.presentableFields + ", Searchable Fields: " + this.searchableFields);
        logger.trace("CQL query: " + gCQLQuery);
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)gCQLQuery);
        QuerySnippetTermsPair querySnippetTerms = this.processNode(head);
        logger.trace("Processed Lucene query: " + querySnippetTerms.query);
        logger.trace("Processed snippet Terms: " + querySnippetTerms.snippetTerms.toString());
        return new LuceneGcqlQueryContainer(querySnippetTerms, this.projectedFields, this.distinct);
    }

    private QuerySnippetTermsPair processNode(GCQLNode node) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    private QuerySnippetTermsPair processNode(GCQLProjectNode node) throws Exception {
        Vector projections = node.getProjectIndexes();
        for (ModifierSet projection : projections) {
            if (projection.getModifiers().size() > 0 && ((Modifier)projection.getModifiers().get(0)).getType().equalsIgnoreCase(DISTINCT)) {
                this.distinct = true;
            }
            if (projection.getBase().equals("*")) {
                this.distinct = false;
                this.projectedFields.clear();
                this.projectedFields.put("*", "*");
                return this.processNode(node.subtree);
            }
            String fieldLabel = null;
            fieldLabel = this.adaptor != null ? this.adaptor.getFieldNameById(projection.getBase()) : projection.getBase();
            String projField = this.findPresentable(fieldLabel);
            if (projField == null) {
                logger.error("Projection: " + fieldLabel + ", " + projection.getBase() + "is not part of the presentable fields : " + this.presentableFields);
                continue;
            }
            this.projectedFields.put(projection.getBase(), projField);
        }
        return this.processNode(node.subtree);
    }

    private QuerySnippetTermsPair processNode(GCQLAndNode node) throws Exception {
        QuerySnippetTermsPair left = this.processNode(node.left);
        QuerySnippetTermsPair right = this.processNode(node.right);
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        result.snippetTerms = this.mergeSnippetTerms(left.snippetTerms, right.snippetTerms);
        result.snippetNotTerms = this.mergeSnippetTerms(left.snippetNotTerms, right.snippetNotTerms);
        if (left.query == null && right.query == null) {
            return null;
        }
        result.query = "( ";
        if (left.query != null) {
            result.query = result.query + left.query;
        }
        if (left.query != null && right.query != null) {
            result.query = result.query + LUCENE_AND;
        }
        if (right.query != null) {
            result.query = result.query + right.query;
        }
        result.query = result.query + " )";
        return result;
    }

    private HashMap<String, ArrayList<String>> mergeSnippetTerms(HashMap<String, ArrayList<String>> left, HashMap<String, ArrayList<String>> right) {
        for (Map.Entry<String, ArrayList<String>> current : right.entrySet()) {
            ArrayList<String> terms = left.get(current.getKey());
            if (terms == null) {
                left.put(current.getKey(), current.getValue());
                continue;
            }
            terms.addAll((Collection<String>)current.getValue());
        }
        return left;
    }

    private QuerySnippetTermsPair processNode(GCQLOrNode node) throws Exception {
        QuerySnippetTermsPair left = this.processNode(node.left);
        QuerySnippetTermsPair right = this.processNode(node.right);
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        result.snippetTerms = this.mergeSnippetTerms(left.snippetTerms, right.snippetTerms);
        result.snippetNotTerms = this.mergeSnippetTerms(left.snippetNotTerms, right.snippetNotTerms);
        if (left.query == null && right.query == null) {
            return null;
        }
        result.query = "( ";
        if (left.query != null) {
            result.query = result.query + left.query;
        }
        if (left.query != null && right.query != null) {
            result.query = result.query + LUCENE_OR;
        }
        if (right.query != null) {
            result.query = result.query + right.query;
        }
        result.query = result.query + " )";
        return result;
    }

    private QuerySnippetTermsPair processNode(GCQLNotNode node) throws Exception {
        QuerySnippetTermsPair left = this.processNode(node.left);
        QuerySnippetTermsPair right = this.processNode(node.right);
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        result.snippetTerms = this.mergeSnippetTerms(left.snippetTerms, right.snippetNotTerms);
        result.snippetNotTerms = this.mergeSnippetTerms(left.snippetNotTerms, right.snippetTerms);
        if (left.query == null && right.query == null) {
            return null;
        }
        result.query = "( ";
        if (left.query != null) {
            result.query = result.query + left.query;
        }
        if (left.query != null && right.query != null) {
            result.query = result.query + LUCENE_NOT;
        }
        if (right.query != null) {
            result.query = result.query + right.query;
        }
        result.query = result.query + " )";
        return result;
    }

    private QuerySnippetTermsPair processNode(GCQLTermNode node) throws Exception {
        boolean found = false;
        boolean allFields = false;
        String index = null;
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        if (node.getIndex().equals("gDocCollectionID") || node.getIndex().equals("gDocCollectionLang")) {
            node.getRelation().setBase(LuceneSearcher.SupportedRelations.adj.toString());
            index = node.getIndex();
            found = true;
        } else {
            String fieldLabel = null;
            fieldLabel = this.adaptor != null ? this.adaptor.getFieldNameById(node.getIndex()) : node.getIndex();
            if (fieldLabel.equalsIgnoreCase("allIndexes")) {
                allFields = true;
                found = true;
            } else {
                for (String field : this.searchableFields) {
                    if (!fieldLabel.equalsIgnoreCase(field)) continue;
                    index = field;
                    found = true;
                    break;
                }
            }
        }
        if (!found) {
            throw new Exception("Field: " + node.getIndex() + ", is not part of the searchable fields");
        }
        if (node.getRelation().getBase().equals("=")) {
            node.getRelation().setBase(LuceneSearcher.SupportedRelations.adj.toString());
        }
        StringBuffer luceneBuf = new StringBuffer();
        String processedTerm = null;
        ArrayList<String> snippetTerms = new ArrayList<String>();
        found = false;
        String relation = node.getRelation().getBase();
        LuceneSearcher.SupportedRelations rel = null;
        if (relation.equalsIgnoreCase("==")) {
            return new QuerySnippetTermsPair();
        }
        if (relation.equalsIgnoreCase("=") || relation.equalsIgnoreCase(LuceneSearcher.SupportedRelations.adj.toString())) {
            rel = LuceneSearcher.SupportedRelations.adj;
        } else if (relation.equalsIgnoreCase("within")) {
            rel = LuceneSearcher.SupportedRelations.within;
        } else if (relation.equalsIgnoreCase("fuzzy")) {
            rel = LuceneSearcher.SupportedRelations.fuzzy;
        } else if (relation.equalsIgnoreCase("proximity")) {
            rel = LuceneSearcher.SupportedRelations.proximity;
        } else if (relation.equalsIgnoreCase("=")) {
            rel = LuceneSearcher.SupportedRelations.eq;
        } else if (relation.equalsIgnoreCase(">")) {
            rel = LuceneSearcher.SupportedRelations.gt;
        } else if (relation.equalsIgnoreCase(">=")) {
            rel = LuceneSearcher.SupportedRelations.ge;
        } else if (relation.equalsIgnoreCase("<")) {
            rel = LuceneSearcher.SupportedRelations.lt;
        } else if (relation.equalsIgnoreCase("<=")) {
            rel = LuceneSearcher.SupportedRelations.le;
        } else {
            throw new Exception("Relation: " + node.getRelation().getBase() + " is not supported");
        }
        switch (rel) {
            case adj: {
                processedTerm = node.getTerm();
                snippetTerms.add(processedTerm);
                break;
            }
            case fuzzy: {
                String[] terms = LuceneGcqlProcessor.splitTerms(node.getTerm());
                if (terms.length > 1) {
                    throw new Exception("The fuzzy relation must have only one term. Received: " + node.getTerm());
                }
                processedTerm = terms[0].trim() + "~";
                snippetTerms.add(terms[0].trim());
                break;
            }
            case proximity: {
                String[] terms = LuceneGcqlProcessor.splitTerms(node.getTerm());
                if (terms.length < 3) {
                    throw new Exception("The proximity relation must have at least three terms. Received: " + node.getTerm());
                }
                int distance = 0;
                try {
                    distance = Integer.parseInt(terms[0]);
                }
                catch (NumberFormatException e) {
                    throw new Exception("Wrong syntax for proximity relation. Term 0 was: " + terms[0], e);
                }
                StringBuffer buf = new StringBuffer();
                for (int i = 1; i < terms.length; ++i) {
                    buf.append(terms[i] + " ");
                    snippetTerms.add(terms[i]);
                }
                processedTerm = "\"" + buf.toString().trim() + "\"~" + distance;
                break;
            }
            case within: {
                String[] terms = LuceneGcqlProcessor.splitTerms(node.getTerm());
                if (terms.length != 2) {
                    throw new Exception("The within relation must have exact two terms. Received: " + node.getTerm());
                }
                processedTerm = "[" + terms[0] + " TO " + terms[1] + "]";
                snippetTerms.add(terms[0]);
                snippetTerms.add(terms[1]);
                break;
            }
            case gt: {
                processedTerm = ">" + node.getTerm();
                snippetTerms.add(processedTerm);
                break;
            }
            case ge: {
                processedTerm = ">=" + node.getTerm();
                snippetTerms.add(processedTerm);
                break;
            }
            case lt: {
                processedTerm = "<" + node.getTerm();
                snippetTerms.add(processedTerm);
                break;
            }
            case le: {
                processedTerm = ">=" + node.getTerm();
                snippetTerms.add(processedTerm);
                break;
            }
            default: {
                throw new Exception("Possible bug. Relation: " + relation + " is reported to be supported but it is not handled here");
            }
        }
        if (allFields) {
            boolean first = true;
            luceneBuf.append(processedTerm);
            for (String field : this.searchableFields) {
                if (field.equals("gDocCollectionID") || field.equals("gDocCollectionLang") || field.equals("ObjectID") || field.equals("allIndexes")) continue;
                result.snippetTerms.put(field, (ArrayList)snippetTerms.clone());
            }
            snippetTerms = null;
        } else {
            luceneBuf.append(index + ":" + processedTerm);
            if (!index.equals("gDocCollectionID") && !index.equals("gDocCollectionLang")) {
                result.snippetTerms.put(index, snippetTerms);
            }
        }
        logger.debug("Term Node result: " + luceneBuf.toString());
        result.query = "( " + luceneBuf.toString() + " )";
        return result;
    }
}

