/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.semantic.annotator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.SMARTFISH_EntityCollection;
import org.gcube.textextractor.helpers.ExtractorHelper;

public class FLOD_EntityCollection {
    private static FLOD_EntityCollection instance;
    private static Model m;
    public static final String flodsparql = "http://www.fao.org/figis/flod/endpoint/flod";
    private final Node flodGnode = NodeFactory.createURI((String)"http://www.fao.org/figis/flod/entities");
    static String prefixes;

    public static FLOD_EntityCollection getInstance() {
        if (instance == null) {
            instance = new FLOD_EntityCollection();
        }
        return instance;
    }

    private FLOD_EntityCollection() {
        DatasetGraphAccessorHTTP kbAccessor = new DatasetGraphAccessorHTTP("http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/data");
        Graph flodGraph = kbAccessor.httpGet(this.flodGnode);
        m.add(ModelUtils.triplesToStatements((Iterator)GraphUtil.findAll((Graph)flodGraph), (Model)m));
    }

    private void loadList() throws FileNotFoundException {
        String construct = " construct ";
        String constructPattern = "";
        constructPattern = constructPattern + " ?flagstateCode a <http://www.fao.org/figis/flod/onto/flagstate.owl#FlagStateCode> . ?flagstate <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?flagstateCode . ?flagstate <http://www.w3.org/2000/01/rdf-schema#label> ?flagstateName . ";
        constructPattern = constructPattern + " ?speciesCode a <http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode> . ?species <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?speciesCode . ?species <http://www.w3.org/2000/01/rdf-schema#label> ?speciesName . ";
        constructPattern = constructPattern + " ?vesselCode a <http://www.fao.org/figis/flod/onto/vessel.owl#VesselCode> . ?vessel <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?vesselCode . ?vessel <http://www.w3.org/2000/01/rdf-schema#label> ?vesselName .";
        constructPattern = constructPattern + " ?gearCode a <http://www.fao.org/figis/flod/onto/gear.owl#GearCode> . ?gear <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?gearCode .  ?gear <http://www.w3.org/2000/01/rdf-schema#label> ?gearName . ";
        String where = " where ";
        String pattern = "";
        pattern = pattern + "{ ?speciesCode a <http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode> . ?species <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?speciesCode. ?species <http://www.w3.org/2000/01/rdf-schema#label> ?speciesName}";
        pattern = pattern + "union { ?vesselCode a <http://www.fao.org/figis/flod/onto/vessel.owl#VesselCode> .  ?vessel <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?vesselCode . ?vessel <http://www.w3.org/2000/01/rdf-schema#label> ?vesselName}";
        pattern = pattern + "union { ?gearCode a <http://www.fao.org/figis/flod/onto/gear.owl#GearCode> . ?gear <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?gearCode . ?gear <http://www.w3.org/2000/01/rdf-schema#label> ?gearName}";
        pattern = pattern + "union { ?flagstateCode a <http://www.fao.org/figis/flod/onto/flagstate.owl#FlagStateCode> . ?flagstate <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#isClassfiedByCode> ?flagstateCode . ?flagstate <http://www.w3.org/2000/01/rdf-schema#label> ?flagstateName }";
        String query = construct + "{ " + constructPattern + " } " + where + "{ " + pattern + " }";
        Query q = QueryFactory.create((String)query);
        System.out.println(q.serialize());
        m = QueryExecutionFactory.sparqlService((String)flodsparql, (Query)q).execConstruct();
        File f = new File("flod_entity_collection.nt");
        RDFDataMgr.write((OutputStream)new FileOutputStream(f), (Model)m, (Lang)Lang.NT);
    }

    private ResultSet label4uri(String uri, String lang) {
        String filter = "";
        String select = " select distinct ?uri ?label_str ?lang";
        String where = " where ";
        String gbpattern = "BIND (IRI('" + uri + "') as ?uri) " + " ?uri rdfs:label ?label_lang . " + "BIND (str(?label_lang) as ?label_str) " + "BIND (lang(?label_lang) as ?lang) ";
        filter = !"".equals(lang) ? filter + "filter(?lang = '" + lang + "')" : filter + "filter(?lang = 'en' || ?lang = 'fr' || ?lang = 'la')";
        return QueryExecutionFactory.create((String)(prefixes + select + where + "{" + gbpattern + filter + "}"), (Model)m).execSelect();
    }

    private boolean isOfType(String entityURI, String typeURI) {
        String query = "  ASK  {<" + entityURI + "> ce_cls:isClassfiedByCode  ?code ." + "?code rdf:type ?<" + typeURI + "> ." + "}";
        return QueryExecutionFactory.create((String)(prefixes + query), (Model)m).execAsk();
    }

    private ResultSet ce4name(String name, String resType) {
        name = this.sanitize(name);
        String where = "{?code rdf:type <" + resType + "> ." + "?uri ce_cls:isClassfiedByCode  ?code ." + "?uri rdfs:label ?label . " + "filter(str(?label) = '" + name + "') " + "?uri rdfs:label ?label_lang . " + "BIND (str(?label_lang) as ?label_str) " + "BIND (lang(?label_lang) as ?lang) " + "filter(?lang = 'en' || ?lang = 'fr' || ?lang = 'la')" + "}";
        String querySelect = "  SELECT distinct ?uri ?label_str ?lang WHERE " + where;
        return QueryExecutionFactory.create((String)(prefixes + querySelect), (Model)m).execSelect();
    }

    private List<Triple> describe(String entityURI, String lang, boolean remote, TripleMatchFilter filter) {
        Iterator describe = QueryExecutionFactory.sparqlService((String)flodsparql, (String)("describe <" + entityURI + ">")).execDescribeTriples();
        return filter.filterKeep(describe).toList();
    }

    private JsonObject triplesToJsonObject(Iterator<Triple> triples) {
        JsonObject jo = new JsonObject();
        while (triples.hasNext()) {
            String obj;
            Triple triple = triples.next();
            String sbj = triple.getSubject().getURI();
            String p = triple.getPredicate().getLocalName();
            Node objNode = triple.getObject();
            if (objNode.isLiteral()) {
                p = objNode.getLiteral().language().isEmpty() ? p : p + "_" + objNode.getLiteral().language();
                obj = objNode.getLiteralValue().toString();
            } else {
                obj = objNode.getURI();
            }
            if (obj.isEmpty()) continue;
            jo.addProperty(p, obj);
        }
        return jo;
    }

    public String describeEntity(String entityURI, String lang, boolean remote, TripleMatchFilter filter) {
        if (filter == null) {
            filter = new TripleMatchFilter(Triple.ANY);
        }
        List<Triple> triples = this.describe(entityURI, lang, remote, filter);
        return this.triplesToJsonObject(triples.iterator()).toString();
    }

    public String describeEntity(List<String> entityURI, String lang, boolean remote, TripleMatchFilter filter) {
        JsonArray ja = new JsonArray();
        if (filter == null) {
            filter = new TripleMatchFilter(Triple.ANY);
        }
        for (String uri : entityURI) {
            ja.add((JsonElement)this.triplesToJsonObject(this.describe(uri, lang, remote, filter).iterator()));
        }
        return ja.toString();
    }

    public String infobox(String entityURI, String lang) {
        Node entityNode = NodeFactory.createURI((String)entityURI);
        TripleMatchFilter filter = new TripleMatchFilter(Triple.create((Node)entityNode, (Node)RDFS.label.asNode(), (Node)Node.ANY));
        List<Triple> describe = this.describe(entityURI, lang, true, filter);
        String entityType = this.isSpecies(entityURI) ? "species" : "country";
        describe.add(Triple.create((Node)entityNode, (Node)NodeFactory.createURI((String)"http://temp#entity_type"), (Node)NodeFactory.createLiteral((String)String.valueOf(entityType))));
        int sizeInFIRMS = AnnotationBase.getInstance().listDocumentsInFIRMS(entityURI).size();
        int sizeInStatBase = AnnotationBase.getInstance().listDocumentsInSTATBASE(entityURI).size();
        int sizeWIOFISH = AnnotationBase.getInstance().listDocumentsInWIOFISH(entityURI).size();
        describe.add(Triple.create((Node)entityNode, (Node)NodeFactory.createURI((String)"http://temp#wiofish_size"), (Node)NodeFactory.createLiteral((String)String.valueOf(sizeWIOFISH))));
        describe.add(Triple.create((Node)entityNode, (Node)NodeFactory.createURI((String)"http://temp#statbase_size"), (Node)NodeFactory.createLiteral((String)String.valueOf(sizeInStatBase))));
        describe.add(Triple.create((Node)entityNode, (Node)NodeFactory.createURI((String)"http://temp#firms_size"), (Node)NodeFactory.createLiteral((String)String.valueOf(sizeInFIRMS))));
        List<String> metaLayers = AnnotationBase.getInstance().getMetaLayerSource(entityURI);
        for (String uri : metaLayers) {
            describe.add(Triple.create((Node)entityNode, (Node)NodeFactory.createURI((String)"http://temp#matalayer"), (Node)NodeFactory.createURI((String)uri)));
        }
        return this.triplesToJsonObject(describe.iterator()).toString();
    }

    public String getURI(String name, String resType) {
        ResultSet rs = this.getURIrs(name, resType);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rs);
        return bos.toString();
    }

    private ResultSet getURIrs(String name, String resType) {
        ResultSet rs = this.ce4name(name, resType);
        if (rs.getRowNumber() <= 0) {
            return SMARTFISH_EntityCollection.getInstance().getURIrs(name, resType);
        }
        return rs;
    }

    public String getURI(String[] names, String resType) {
        ResultSet[] rsList = new ResultSet[names.length];
        ResultSetMem rsm = new ResultSetMem();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            rsList[i] = this.getURIrs(name, resType);
        }
        if (rsList.length > 0) {
            rsm = (ResultSetMem)ResultSetUtils.union((ResultSet[])rsList);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rsm);
        return bos.toString();
    }

    public String getLabel(String uri, String lang) {
        ResultSet rs = this.label4uri(uri, lang);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rs);
        return bos.toString();
    }

    public boolean isSpecies(String uri) {
        return this.isOfType(uri, "http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode");
    }

    public String getLabel(List<String> entitiesURIs, String lang) {
        ResultSet[] rsList = new ResultSet[entitiesURIs.size()];
        ResultSetMem rsm = new ResultSetMem();
        for (int i = 0; i < entitiesURIs.size(); ++i) {
            String uri = entitiesURIs.get(i);
            ResultSet rs = this.label4uri(uri, lang);
            if (uri.contains("smartfish.d4science.org")) {
                String labelResult = SMARTFISH_EntityCollection.getInstance().getLabel(uri, lang);
                rs = ResultSetFactory.fromJSON((InputStream)new ByteArrayInputStream(labelResult.getBytes()));
            }
            rsList[i] = rs;
        }
        if (rsList.length > 0) {
            rsm = (ResultSetMem)ResultSetUtils.union((ResultSet[])rsList);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rsm);
        return bos.toString();
    }

    public static String getValueFromJson(String sparqlJson, String varName) {
        try {
            return ExtractorHelper.parseJsonRequest((String)sparqlJson).get((int)0).uri;
        }
        catch (Exception ex) {
            Logger.getLogger(FLOD_EntityCollection.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public static void main(String[] args) {
        String entityURI = "http://www.fao.org/figis/flod/entities/codedentity/c1688b54-2973-468c-8fda-df39c53d609e";
        String describe = FLOD_EntityCollection.getInstance().infobox(entityURI, "");
        System.out.println(describe);
    }

    private String sanitize(String name) {
        name = StringUtils.remove((String)name, (String)"/");
        name = StringEscapeUtils.escapeJavaScript((String)name.toLowerCase().trim());
        return name;
    }

    static {
        m = ModelFactory.createDefaultModel();
        prefixes = "PREFIX rdf:        <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs:\t  <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl:        <http://www.w3.org/2002/07/owl#> PREFIX xsd:        <http://www.w3.org/2001/XMLSchema#> PREFIX csv:        <http://www.fao.org/figis/flod/csv/> PREFIX fn:         <http://www.w3.org/2005/xpath-functions#> PREFIX afn:        <http://jena.hpl.hp.com/ARQ/function#> PREFIX dc:         <http://purl.org/dc/elements/1.1/>PREFIX xsd:        <http://www.w3.org/2001/XMLSchema#>PREFIX sys:        <http://www.fao.org/figis/flod/onto/codedentitycollection.owl#>PREFIX rfb:        <http://www.fao.org/figis/flod/onto/rfb.owl#>PREFIX dbp:        <http://dbpedia.org/property/>PREFIX dcterms:    <http://purl.org/dc/terms/>PREFIX dwc:        <http://rs.tdwg.org/dwc/terms/>PREFIX cls:        <http://www.ontologydesignpatterns.org/cp/owl/classification.owl#> PREFIX ce_cls:     <http://www.fao.org/figis/flod/onto/codedentityclassification.owl#> ";
    }
}

