/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.semantic.annotator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.riot.RiotWriter;
import org.apache.jena.web.DatasetGraphAccessorHTTP;

public class AnnotationBase {
    private static AnnotationBase instance;
    public static String FIRMS_annotation_file_name;
    public static String STATBASE_annotation_file_name;
    public static String WIOFISH_annotation_file_name;
    private final DatasetGraph annotationStore = DatasetGraphFactory.createMem();
    private final DatasetGraph annotations = DatasetGraphFactory.createMem();
    private static final Model unionModel;
    private ArrayList<String> documentURIs = new ArrayList();

    public static AnnotationBase getInstance() {
        if (instance == null) {
            instance = new AnnotationBase();
        }
        return instance;
    }

    private AnnotationBase() {
        DatasetGraphAccessorHTTP annotationStore_accessor = new DatasetGraphAccessorHTTP("http://dl051.madgik.di.uoa.gr:3030/chimaera_annotation_update/data");
        this.annotations.addGraph(Quad.unionGraph, annotationStore_accessor.httpGet(Quad.unionGraph));
        this.annotations.addGraph(NodeFactory.createURI((String)"http://smartfish.graph/wiofish"), annotationStore_accessor.httpGet(Quad.unionGraph));
        this.annotations.addGraph(NodeFactory.createURI((String)"http://smartfish.graph/statbase"), annotationStore_accessor.httpGet(Quad.unionGraph));
        this.annotations.addGraph(NodeFactory.createURI((String)"http://smartfish.graph/firms"), annotationStore_accessor.httpGet(Quad.unionGraph));
        Iterator find = this.annotations.find(Quad.unionGraph, Node.ANY, Node.ANY, Node.ANY);
        while (find.hasNext()) {
            Quad quad = (Quad)find.next();
            unionModel.add(ModelUtils.tripleToStatement((Model)unionModel, (Triple)quad.asTriple()));
        }
    }

    private void addAnnotation(String docURI, String entity_uri, String annotation_property, String collection_name) {
        Node graphNode = NodeFactory.createURI((String)("http://smartfish.graph/" + collection_name.toLowerCase()));
        Node collection_node = NodeFactory.createURI((String)("http://smartfish.collection/" + collection_name.toLowerCase()));
        Node doc_node = NodeFactory.createURI((String)docURI);
        Node entity_node = NodeFactory.createURI((String)entity_uri);
        this.annotationStore.add(graphNode, collection_node, RDF.type.asNode(), NodeFactory.createURI((String)"http://purl.org/ontology/bibo/Collection"));
        this.annotationStore.add(graphNode, doc_node, RDF.type.asNode(), NodeFactory.createURI((String)"http://purl.org/ontology/bibo/Document"));
        this.annotationStore.add(graphNode, doc_node, NodeFactory.createURI((String)annotation_property), entity_node);
        this.annotationStore.add(graphNode, doc_node, DCTerms.subject.asNode(), entity_node);
        this.annotationStore.add(graphNode, doc_node, NodeFactory.createURI((String)"http://dbpedia.org/property/collection"), collection_node);
    }

    public AnnotationBase WIOFISH_targetSpecies(String docID, String speciesURI) {
        String collection = "wiofish";
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#target", collection);
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#incatch", collection);
        this.addAnnotationSpecies(docID, speciesURI, collection);
        return instance;
    }

    public AnnotationBase WIOFISH_bycatchSpecies(String docID, String speciesURI) {
        String collection = "wiofish";
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#bycatch", collection);
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#incatch", collection);
        this.addAnnotationSpecies(docID, speciesURI, collection);
        return instance;
    }

    public AnnotationBase WIOFISH_discardSpecies(String docID, String speciesURI) {
        String collection = "wiofish";
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#discard", collection);
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#incatch", collection);
        this.addAnnotationSpecies(docID, speciesURI, collection);
        return instance;
    }

    public AnnotationBase WIOFISH_thretenedSpecies(String docID, String speciesURI) {
        String collection = "wiofish";
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#thretened", collection);
        this.addAnnotation(docID, speciesURI, "http://www.fao.org/figis/onto/smartfish/annotation.owl#incatch", collection);
        this.addAnnotationSpecies(docID, speciesURI, collection);
        return instance;
    }

    public AnnotationBase WIOFISH_gear(String docID, String gearURI) {
        this.addAnnotationGear(docID, gearURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_status(String docID, String statusURI) {
        this.addAnnotationStatus(docID, statusURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_sector(String docID, String sectorURI) {
        this.addAnnotationSector(docID, sectorURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_seasonality(String docID, String seasonalityURI) {
        seasonalityURI = "http://smartfish.d4science.org/time/" + seasonalityURI.toLowerCase();
        this.addAnnotationSeasonality(docID, seasonalityURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_management(String docID, String managemetURI) {
        this.addAnnotationManagement(docID, managemetURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_access_control(String docID, String access_control_uri) {
        this.addAnnotationMeasure(docID, access_control_uri, "wiofish");
        this.addAnnotationControl(docID, access_control_uri, "wiofish");
        this.addAnnotationAccessControl(docID, access_control_uri, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_fishing_control(String docID, String fishing_control_uri) {
        this.addAnnotationMeasure(docID, fishing_control_uri, "wiofish");
        this.addAnnotationControl(docID, fishing_control_uri, "wiofish");
        this.addAnnotationFishingControl(docID, fishing_control_uri, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_enforcement_method(String docID, String enforcement_method_uri) {
        this.addAnnotationMeasure(docID, enforcement_method_uri, "wiofish");
        this.addAnnotationMethod(docID, enforcement_method_uri, "wiofish");
        this.addAnnotationEnforcementMethod(docID, enforcement_method_uri, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_authority(String docID, String authorityURI) {
        this.addAnnotationAuthority(docID, authorityURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_vessel(String docID, String vesselURI) {
        this.addAnnotationVessel(docID, vesselURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_country(String docID, String countryURI) {
        this.addAnnotationCountry(docID, countryURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_financingManagement(String docID, String authorityURI) {
        this.addAnnotationFinancingManagement(docID, authorityURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_managementIndicator(String docID, String indicatorURI) {
        this.addAnnotationManagementIndicator(docID, indicatorURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_representativesInDecisionMaking(String docID, String authorityURI) {
        this.addAnnotationRepresentativeInDecisionMaking(docID, authorityURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_postHarvestProcessing(String docID, String processingURI) {
        this.addAnnotationPostHarvestProcessing(docID, processingURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_market(String docID, String marketURI) {
        this.addAnnotationMarket(docID, marketURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_alternativeIncomeSource(String docID, String incomeSourceURI) {
        this.addAnnotationAlternativeIncomeSource(docID, incomeSourceURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_ownershipOfAccessRight(String docID, String legalEntityURI) {
        this.addAnnotationOwnershipOfAccessRight(docID, legalEntityURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_accessRightApplicant(String docID, String legalEntityURI) {
        this.addAnnotationAccessRightApplicant(docID, legalEntityURI, "wiofish");
        return instance;
    }

    public AnnotationBase WIOFISH_technologiesInUse(String docID, String technologyURI) {
        this.addAnnotationTechnologyInUse(docID, technologyURI, "wiofish");
        return instance;
    }

    public AnnotationBase FIRMS_gear(String docID, String gearURI) {
        this.addAnnotationGear(docID, gearURI, "firms");
        return instance;
    }

    public AnnotationBase FIRMS_species(String docID, String speciesURI) {
        this.addAnnotationSpecies(docID, speciesURI, "firms");
        return instance;
    }

    public AnnotationBase FIRMS_country(String docID, String countryURI) {
        this.addAnnotationCountry(docID, countryURI, "firms");
        return instance;
    }

    public AnnotationBase FIRMS_management(String docID, String managementURI) {
        this.addAnnotationManagement(docID, managementURI, "firms");
        return instance;
    }

    public AnnotationBase FIRMS_status(String docID, String statusURI) {
        this.addAnnotationStatus(docID, statusURI, "firms");
        return instance;
    }

    public AnnotationBase STATBASE_gear(String docID, String gearURI) {
        this.addAnnotationGear(docID, gearURI, "statbase");
        return instance;
    }

    public AnnotationBase STATBASE_species(String docID, String speciesURI) {
        this.addAnnotationSpecies(docID, speciesURI, "statbase");
        return instance;
    }

    public AnnotationBase STATBASE_country(String docID, String countryURI) {
        this.addAnnotationCountry(docID, countryURI, "statbase");
        return instance;
    }

    public AnnotationBase STATBASE_vessel(String docID, String vesselURI) {
        this.addAnnotationVessel(docID, vesselURI, "statbase");
        return instance;
    }

    public AnnotationBase STATBASE_water_area(String docID, String waterAreaURI) {
        this.addAnnotationWaterArea(docID, waterAreaURI, "statbase");
        return instance;
    }

    public AnnotationBase STATBASE_land_area(String docID, String landAreaURI) {
        this.addAnnotationLandArea(docID, landAreaURI, "statbase");
        return instance;
    }

    private void addAnnotationCountry(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#country", collection);
    }

    private void addAnnotationGear(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#gear", collection);
    }

    private void addAnnotationVessel(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel", collection);
    }

    private void addAnnotationSpecies(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#species", collection);
    }

    private void addAnnotationStatus(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#status", collection);
    }

    private void addAnnotationSector(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#sector", collection);
    }

    private void addAnnotationSeasonality(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#seasonality", collection);
    }

    private void addAnnotationManagement(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#management", collection);
    }

    private void addAnnotationAccessControl(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#access_control", collection);
    }

    private void addAnnotationFishingControl(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#fishing_control", collection);
    }

    private void addAnnotationEnforcementMethod(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#enforcement_method", collection);
    }

    private void addAnnotationAuthority(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#authority", collection);
    }

    private void addAnnotationMeasure(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#measure", collection);
    }

    private void addAnnotationControl(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#control", collection);
    }

    private void addAnnotationMethod(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#method", collection);
    }

    private void addAnnotationFinancingManagement(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#finance_mgmt_authority", collection);
    }

    private void addAnnotationManagementIndicator(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#management_indicator", collection);
    }

    private void addAnnotationRepresentativeInDecisionMaking(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#decision_maker", collection);
    }

    private void addAnnotationPostHarvestProcessing(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#post_processing_method", collection);
    }

    private void addAnnotationMarket(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#market", collection);
    }

    private void addAnnotationAlternativeIncomeSource(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#other_income_source", collection);
    }

    private void addAnnotationOwnershipOfAccessRight(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#owner_of_access_right", collection);
    }

    private void addAnnotationAccessRightApplicant(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#applicant_for_access_right", collection);
    }

    private void addAnnotationTechnologyInUse(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#technology", collection);
    }

    private void addAnnotationWaterArea(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#water_area", collection);
    }

    private void addAnnotationLandArea(String docID, String uri, String collection) {
        this.addAnnotation(docID, uri, "http://www.fao.org/figis/onto/smartfish/annotation.owl#land_area", collection);
    }

    public File toFile(File f) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write((OutputStream)fos, this.annotationStore, null, null, this.annotationStore.getContext());
        return f;
    }

    public File dump(String filename) throws FileNotFoundException {
        File f = new File(filename);
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write((OutputStream)fos, this.annotationStore, null, null, this.annotationStore.getContext());
        this.annotationStore.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        return f;
    }

    public String statPublicationPerAnnotation(String target, String lang) {
        List<String> properties = this.listAnnotationProperties();
        JsonArray ja = new JsonArray();
        for (String p_uri : properties) {
            JsonObject jo = new JsonObject();
            List<String> entities = this.listEntitiesOfProperty(p_uri);
            jo.addProperty("uri", p_uri);
            jo.addProperty("size", (Number)entities.size());
            jo.addProperty("name", StringUtils.capitalize((String)p_uri.split("#")[1].replace("_", " ")));
            ja.add((JsonElement)jo);
        }
        return ja.toString();
    }

    public List<String> listAnnotationProperties() {
        String annotation_NS = "http://www.fao.org/figis/onto/smartfish/annotation.owl#";
        String prefixes = "prefix afn:  <http://jena.hpl.hp.com/ARQ/function#>";
        String query = "";
        String select = " select distinct ?annotation_property";
        String where = " where ";
        String gbp = " ?doc ?annotation_property ?tagging_entity .filter(afn:namespace(?annotation_property) = '" + annotation_NS + "') ";
        query = prefixes + select + where + "{" + gbp + "}";
        ResultSet rs = QueryExecutionFactory.create((String)query, (Model)unionModel).execSelect();
        return ResultSetUtils.resultSetToStringList((ResultSet)rs, (String)"annotation_property", (String)"Resource");
    }

    public List<String> listDocuments(String forThisEntityUri) {
        return this.listDocuments(forThisEntityUri, Node.ANY);
    }

    private List<String> listDocuments(String forThisEntityUri, Node inThisCollection) {
        this.documentURIs.clear();
        if (inThisCollection == null) {
            inThisCollection = Node.ANY;
        }
        Iterator quads_it = this.annotations.find(inThisCollection, Node.ANY, DCTerms.subject.asNode(), NodeFactory.createURI((String)forThisEntityUri));
        while (quads_it.hasNext()) {
            Quad quad = (Quad)quads_it.next();
            this.documentURIs.add(quad.getSubject().getURI());
        }
        return this.documentURIs;
    }

    public List<String> listDocumentsInWIOFISH(String forThisEntityUri) {
        return this.listDocuments(forThisEntityUri, NodeFactory.createURI((String)"wiofish"));
    }

    public List<String> listDocumentsInSTATBASE(String forThisEntityUri) {
        return this.listDocuments(forThisEntityUri, NodeFactory.createURI((String)"statbase"));
    }

    public List<String> listDocumentsInFIRMS(String forThisEntityUri) {
        return this.listDocuments(forThisEntityUri, NodeFactory.createURI((String)"firms"));
    }

    public List<String> listDocumentsWithCoOccuringEntities(String referenceURI, String[] coOccurringEntitiesURIs) {
        ArrayList<String> docURIs = new ArrayList<String>();
        String query = "";
        String select = " select distinct ?doc";
        String where = " where ";
        String gbp = "";
        for (int i = 0; i < coOccurringEntitiesURIs.length; ++i) {
            String coOccurEntUri = coOccurringEntitiesURIs[i];
            gbp = gbp + "{ ?doc <http://www.fao.org/figis/onto/smartfish/annotation.owl#country> <" + referenceURI + "> .  ?doc <" + "http://www.fao.org/figis/onto/smartfish/annotation.owl#species" + "> <" + coOccurEntUri + "> } ";
            if (i == coOccurringEntitiesURIs.length - 1) continue;
            gbp = gbp + " UNION ";
        }
        query = select + where + "{" + gbp + "}";
        Query q = QueryFactory.create((String)query);
        System.out.println(q.serialize());
        ResultSet rs = QueryExecutionFactory.create((String)query, (Model)unionModel).execSelect();
        docURIs.addAll(ResultSetUtils.resultSetToStringList((ResultSet)rs, (String)"doc", (String)"Resource"));
        return docURIs;
    }

    public List<String> listDocuments(String[] forThisEntityUris) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < forThisEntityUris.length; ++i) {
            String uri = forThisEntityUris[i];
            List<String> listDocuments = this.listDocuments(uri);
            this.addIfnotThere(result, listDocuments);
        }
        return result;
    }

    public List<String> listEntitiesOfProperty(String propertyUri) {
        ArrayList<String> entitiesURIs = new ArrayList<String>();
        Iterator quads_it = this.annotations.find(Node.ANY, Node.ANY, NodeFactory.createURI((String)propertyUri), Node.ANY);
        while (quads_it.hasNext()) {
            Quad quad = (Quad)quads_it.next();
            entitiesURIs.add(quad.getObject().getURI());
        }
        return entitiesURIs;
    }

    public List<String> listEntitiesOfDocument(String documentURI, String annotationProperty) {
        ArrayList<String> entitiesURIs = new ArrayList<String>();
        Iterator quads_it = this.annotations.find(Node.ANY, NodeFactory.createURI((String)documentURI), NodeFactory.createURI((String)annotationProperty), Node.ANY);
        while (quads_it.hasNext()) {
            Quad quad = (Quad)quads_it.next();
            entitiesURIs.add(quad.getObject().getURI());
        }
        return entitiesURIs;
    }

    public List<String> listSpeciesInCountry(String countryURI) {
        ArrayList<String> entitiesURIs = new ArrayList<String>();
        String query = "";
        String select = " select distinct ?species";
        String where = " where ";
        String gbp = "?doc <http://www.fao.org/figis/onto/smartfish/annotation.owl#country> <" + countryURI + "> . " + "?doc <" + "http://www.fao.org/figis/onto/smartfish/annotation.owl#species" + "> ?species ";
        query = select + where + "{" + gbp + "}";
        ResultSet rs = QueryExecutionFactory.create((String)query, (Model)unionModel).execSelect();
        entitiesURIs.addAll(ResultSetUtils.resultSetToStringList((ResultSet)rs, (String)"species", (String)"Resource"));
        return entitiesURIs;
    }

    public List<String> getMetaLayer(String entityURI) {
        ArrayList<String> entitiesURIs = new ArrayList<String>();
        String query = "";
        String select = " select distinct ?gisEntity";
        String where = " where ";
        String gbp = "<" + entityURI + "> <http://www.fao.org/figis/flod/onto/distribution.owl#faodistribution> ?gisEntity . ";
        query = select + where + "{" + gbp + "}";
        ResultSet rs = QueryExecutionFactory.sparqlService((String)"http://www.fao.org/figis/flod/endpoint/flod", (String)query).execSelect();
        entitiesURIs.addAll(ResultSetUtils.resultSetToStringList((ResultSet)rs, (String)"gisEntity", (String)"Resource"));
        return entitiesURIs;
    }

    public List<String> getMetaLayerSource(String entityURI) {
        ArrayList<String> entitiesURIs = new ArrayList<String>();
        String query = "";
        String select = " select distinct ?gisEntity";
        String where = " where ";
        String gbp = "<" + entityURI + "> <http://www.fao.org/figis/flod/onto/distribution.owl#faodistribution> ?gisEntity . ?gisEntity <http://purl.org/dc/terms/source> ?source ";
        query = select + where + "{" + gbp + "}";
        ResultSet rs = QueryExecutionFactory.sparqlService((String)"http://www.fao.org/figis/flod/endpoint/flod", (String)query).execSelect();
        entitiesURIs.clear();
        entitiesURIs.addAll(ResultSetUtils.resultSetToStringList((ResultSet)rs, (String)"gisEntity", (String)"Resource"));
        return entitiesURIs;
    }

    private void addIfnotThere(ArrayList<String> entitiesURIs, List<String> response) {
        for (String newUri : response) {
            if (entitiesURIs.contains(newUri)) continue;
            entitiesURIs.add(newUri);
        }
    }

    public static void main(String[] args) {
        String e_uri = "http://www.fao.org/figis/flod/entities/codedentity/f527d0db-0255-4893-b266-cf8a18b6e9ca";
        String[] species = new String[]{"http://www.fao.org/figis/flod/entities/codedentity/778517e8-eda6-458d-8029-dbb02f0e2dd2", "http://www.fao.org/figis/flod/entities/codedentity/b2ef129b-2d86-446a-83b9-e731915394c9"};
        String[] species_list = new String[]{"http://www.fao.org/figis/flod/entities/codedentity/7be56ab6-09d2-4b94-9718-ccf97d4ae495"};
        String country = "http://www.fao.org/figis/flod/entities/codedentity/f527d0db-0255-4893-b266-cf8a18b6e9ca";
        String doc = "http://smartfish.collection/wiofish/189";
        System.out.println("List Annotation Properties");
        System.out.println(AnnotationBase.getInstance().listAnnotationProperties());
        System.out.println("List Documents");
        System.out.println(AnnotationBase.getInstance().listDocuments(species));
        System.out.println("List Documents");
        System.out.println(AnnotationBase.getInstance().listDocuments(species_list));
        System.out.println("List Documents");
        System.out.println(AnnotationBase.getInstance().listDocuments(e_uri, NodeFactory.createURI((String)"http://smartfish.graph/wiofish")));
        System.out.println("List document with entities");
        System.out.println(AnnotationBase.getInstance().listDocumentsWithCoOccuringEntities("http://www.fao.org/figis/flod/entities/codedentity/f527d0db-0255-4893-b266-cf8a18b6e9ca", species));
        System.out.println("List document with entities");
        System.out.println(AnnotationBase.getInstance().listDocumentsWithCoOccuringEntities("http://www.fao.org/figis/flod/entities/codedentity/f527d0db-0255-4893-b266-cf8a18b6e9ca", species));
        System.out.println("List Species in Country");
        System.out.println(AnnotationBase.getInstance().listSpeciesInCountry(country));
        System.out.println("List Entities of Document");
        System.out.println(AnnotationBase.getInstance().listEntitiesOfDocument(doc, "http://www.fao.org/figis/onto/smartfish/annotation.owl#species"));
        System.out.println("List Entities of Property");
        System.out.println(AnnotationBase.getInstance().listEntitiesOfProperty("http://www.fao.org/figis/onto/smartfish/annotation.owl#bycatch"));
        try {
            AnnotationBase.getInstance().toFile(new File("annotations.nq"));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(AnnotationBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        FIRMS_annotation_file_name = "annotation_collection_firms.nq";
        STATBASE_annotation_file_name = "annotation_collection_statbase.nq";
        WIOFISH_annotation_file_name = "annotation_collection_wiofish.nq";
        unionModel = ModelFactory.createDefaultModel();
    }
}

