/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.semantic.annotator.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Generator {
    private static String convertToHexString(byte[] toConvert) {
        assert (toConvert.length == 16) : "Result length (in bytes) should be 16 instead of " + toConvert.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < toConvert.length; ++i) {
            result.append(Integer.toString((toConvert[i] & 0xFF) + 256, 16).substring(1));
        }
        assert (result.length() == 32) : "Converted result length should be 32 instead of " + result.length();
        return result.toString();
    }

    public static String getMD5Sum(byte[] content) throws NoSuchAlgorithmException {
        MessageDigest complete = MessageDigest.getInstance("MD5");
        complete.update(content);
        return MD5Generator.convertToHexString(complete.digest());
    }

    public static String getMD5Sum(String content) throws NoSuchAlgorithmException {
        return MD5Generator.getMD5Sum(content.getBytes());
    }

    public static final void main(String[] args) throws Throwable {
        String test = "sardinella sp";
        System.out.println("Java hashcode: " + test.hashCode());
        System.out.println("MD5  hashcode: " + MD5Generator.getMD5Sum(test));
    }
}

