/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.storagehandling;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexNotificationConsumer;
import org.gcube.indexmanagement.common.notifications.NotifierRequest;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;
import org.gcube.indexmanagement.common.notifications.SubscribeToNotificationRequest;
import org.gcube.indexmanagement.common.notifications.UnsubscribeFromNotificationRequest;
import org.gcube.indexmanagement.storagehandling.DeltaListManagementWrapper;
import org.gcube.indexmanagement.storagehandling.ServiceContext;
import org.gcube.indexmanagement.storagehandling.exceptions.NoIndexManagerFoundException;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectLookup;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectUpdater;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectUpdaterResponse;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaListManagementProviderPortType;
import org.gcube.indexmanagement.storagehandling.stubs.GetDeltaCollectionID;
import org.gcube.indexmanagement.storagehandling.stubs.GetDeltaFileList;
import org.gcube.indexmanagement.storagehandling.stubs.service.DeltaListManagementProviderServiceAddressingLocator;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.oasis.wsn.PauseFailedFaultType;
import org.oasis.wsn.PauseSubscription;
import org.oasis.wsn.PauseSubscriptionResponse;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.ResumeFailedFaultType;
import org.oasis.wsn.ResumeSubscription;
import org.oasis.wsn.ResumeSubscriptionResponse;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.DestroyResponse;
import org.oasis.wsrf.lifetime.ResourceNotDestroyedFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.TerminationTimeChangeRejectedFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;

public class RemoteDeltaListManager
implements DeltaListManagementWrapper {
    private static final int MAX_ATTEMPTS = 5;
    private static final long WAIT_ATTEMPT = 10000L;
    static GCUBELog logger = new GCUBELog(RemoteDeltaListManager.class);
    private DeltaListManagementProviderPortType indexManager;
    private EndpointReferenceType managerEPR;
    private String indexManagementID;
    private GCUBEServiceContext sctx;
    private String managementServiceNamespace = null;

    public RemoteDeltaListManager(String indexManagementID, GCUBEServiceContext sctx, String managementServiceNamespace) throws Exception {
        logger.info((Object)"Creating a RemoteDeltaListManager with no explicit manager EPR declaration.");
        try {
            this.sctx = sctx;
            this.managementServiceNamespace = managementServiceNamespace;
            this.indexManagementID = indexManagementID;
            EndpointReferenceType managerEPR = this.findManagementEPR(indexManagementID, managementServiceNamespace);
            logger.debug((Object)("Found index management EPR:\n" + managerEPR));
            this.setIndexManagerEPR(managerEPR);
        }
        catch (NoIndexManagerFoundException e) {
            this.indexManager = null;
            this.managerEPR = null;
            logger.info((Object)("No manager found for the indexID: " + indexManagementID));
        }
        catch (Exception e1) {
            logger.error((Object)"Failed to construct RemoteDeltaListManager.", (Throwable)e1);
            throw new Exception(e1.getMessage());
        }
    }

    public RemoteDeltaListManager(String indexManagementID, EndpointReferenceType indexManagerEPR, GCUBEServiceContext sctx) throws Exception {
        logger.info((Object)"Creating a RemoteDeltaListManager using the given manager EPR.");
        try {
            this.sctx = sctx;
            this.indexManagementID = indexManagementID;
            this.setIndexManagerEPR(indexManagerEPR);
        }
        catch (Exception e1) {
            logger.error((Object)"Failed to construct RemoteDeltaListManager.", (Throwable)e1);
            throw new Exception(e1.getMessage());
        }
    }

    @Override
    public String getDeltaCollectionID() throws Exception {
        try {
            if (this.indexManager == null) {
                if (this.managementServiceNamespace == null) {
                    logger.error((Object)"there is not managementServiceNamespace ");
                    return null;
                }
                EndpointReferenceType managerEPR = this.findManagementEPR(this.indexManagementID, this.managementServiceNamespace);
                logger.debug((Object)("Found index management EPR:\n" + managerEPR));
                this.setIndexManagerEPR(managerEPR);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not retrieve a portType to the Manager, for Index ID : " + this.indexManagementID), (Throwable)e);
            return null;
        }
        String colID = this.indexManager.getDeltaCollectionID(new GetDeltaCollectionID());
        logger.trace((Object)("retrieved delta collection id: " + colID));
        return colID;
    }

    private EndpointReferenceType findManagementEPR(String indexID, String managementServiceNamespace) throws Exception {
        List<EndpointReferenceType> result = null;
        EndpointReferenceType epr = null;
        try {
            int attempts;
            for (attempts = 0; (result == null || result.size() == 0) && attempts < 5; ++attempts) {
                LinkedList<String[]> props = new LinkedList<String[]>();
                props.add(new String[]{"IndexID", indexID});
                result = this.getWSResourceEPRsFromPropValuesAndNamespace(props, managementServiceNamespace, this.sctx.getScope());
                if (result != null && result.size() != 0) continue;
                Thread.sleep(10000L);
            }
            logger.trace((Object)("number of attempts : " + attempts + " for indexID: " + indexID));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to retrieve the management resource EPR: " + e.getMessage()));
            throw new Exception("Failed to retrieve the management resource EPR: " + e.getMessage());
        }
        if (result == null || result.size() == 0) {
            logger.error((Object)"Unable to find management epr in IS");
            throw new NoIndexManagerFoundException();
        }
        epr = (EndpointReferenceType)result.get(0);
        logger.info((Object)("Got the EPR for the index [" + indexID + "]"));
        return epr;
    }

    private List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
        String filter = "$result/child::*[local-name()='" + properties.get(0)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(0)[1].trim() + "'";
        for (int i = 1; i < properties.size(); ++i) {
            filter = filter + " and $result/child::*[local-name()='" + properties.get(i)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(i)[1].trim() + "'";
        }
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        gquery.addGenericCondition(filter);
        LinkedList<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
        for (RPDocument d : client.execute((ISQuery)gquery, scope)) {
            ret.add(d.getEndpoint());
        }
        return ret;
    }

    @Override
    public void setIndexManagerEPR(EndpointReferenceType managerEPR) throws Exception {
        try {
            this.managerEPR = managerEPR;
            DeltaListManagementProviderServiceAddressingLocator managerLocator = new DeltaListManagementProviderServiceAddressingLocator();
            this.indexManager = managerLocator.getDeltaListManagementProviderPortTypePort(managerEPR);
            ServiceContext.getContext().prepareCall((Remote)this.indexManager, ServiceContext.getContext().getServiceClass(), ServiceContext.getContext().getName(), new GCUBEScope[]{this.sctx.getScope()});
            ServiceContext.getContext().setSecurity((Remote)this.indexManager, GCUBESecurityManager.AuthMode.BOTH, GCUBESecurityManager.DelegationMode.FULL);
        }
        catch (Exception e) {
            this.indexManager = null;
            this.managerEPR = null;
            logger.error((Object)"Failed to get the remote delta list manager's porttype. Setting RemoteDeltaListManager's state to 'empty'.", (Throwable)e);
        }
    }

    @Override
    public EndpointReferenceType getIndexManagerEPR() {
        return this.managerEPR;
    }

    @Override
    public boolean isEmpty() {
        return this.indexManager == null;
    }

    @Override
    public ConnectUpdaterResponse connectUpdater() throws Exception {
        if (this.isEmpty()) {
            throw new Exception("The remote delta list manager is not currently connected to a delta list manager.");
        }
        return this.indexManager.connectUpdater(new ConnectUpdater());
    }

    @Override
    public int connectLookup() throws Exception {
        if (this.isEmpty()) {
            throw new Exception("The remote delta list manager is not currently connected to a delta list manager.");
        }
        return this.indexManager.connectLookup(new ConnectLookup());
    }

    @Override
    public void disconnectUpdater(int updaterID) throws Exception {
        if (this.isEmpty()) {
            throw new Exception("The remote delta list manager is not currently connected to a delta list manager.");
        }
        this.indexManager.disconnectUpdater(updaterID);
    }

    @Override
    public DeltaFileInfoType getDeltaFileInfo(int idx) throws Exception {
        if (this.isEmpty()) {
            throw new Exception("The remote delta list manager is not currently connected to a delta list manager.");
        }
        String str = new String();
        for (DeltaFileInfoType d : this.getDeltaFileList()) {
            str = str + d.getDeltaFileID();
        }
        logger.info((Object)("DeltasInfoTypes : " + str));
        return this.indexManager.getDeltaFileInfo(idx);
    }

    @Override
    public DeltaFileInfoType[] getDeltaFileList() throws Exception {
        if (this.isEmpty()) {
            throw new Exception("The remote delta list manager is not currently connected to a delta list manager.");
        }
        DeltaFileInfoType[] list = this.indexManager.getDeltaFileList(new GetDeltaFileList()).getDeltaFiles();
        if (list == null) {
            return new DeltaFileInfoType[0];
        }
        return list;
    }

    @Override
    public void mergeDeltaFile(DeltaFileInfoType deltaInfo) throws Exception {
        if (this.isEmpty()) {
            throw new Exception("The remote delta list manager is not currently connected to a delta list manager.");
        }
        this.indexManager.mergeDeltaFile(deltaInfo);
    }

    @Override
    public SubscriptionManager subscribeForAdditions(IndexNotificationConsumer consumer) throws Exception {
        QName topic = new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider/" + this.indexManagementID, "AddDelta");
        logger.debug((Object)("Subscribing for topic: " + topic));
        return new RemoteSubscriptionManager(topic, consumer);
    }

    @Override
    public SubscriptionManager subscribeForDeletions(IndexNotificationConsumer consumer) throws Exception {
        QName topic = new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider/" + this.indexManagementID, "DeleteDelta");
        logger.debug((Object)("Subscribing for topic: " + topic));
        return new RemoteSubscriptionManager(topic, consumer);
    }

    @Override
    public SubscriptionManager subscribeForIndexRemoval(IndexNotificationConsumer consumer) throws Exception {
        QName topic = new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider/" + this.indexManagementID, "IndexRemoved");
        logger.debug((Object)("Subscribing for topic: " + topic));
        return new RemoteSubscriptionManager(topic, consumer);
    }

    @Override
    public SubscriptionManager subscribeForManagerCreation(IndexNotificationConsumer consumer) throws Exception {
        QName topic = new QName("http://gcube-system.org/namespaces/indexmanagement/DeltaListManagementProvider/" + this.indexManagementID, "IndexManagerCreated");
        logger.debug((Object)("Subscribing for topic: " + topic));
        return new RemoteSubscriptionManager(topic, consumer);
    }

    private class RemoteSubscriptionManager
    implements SubscriptionManager {
        private IndexNotificationConsumer consumer;
        private ArrayList<QName> topicList;

        public RemoteSubscriptionManager(QName topic, IndexNotificationConsumer consumer) throws IndexException {
            try {
                this.topicList = new ArrayList();
                if (topic != null) {
                    this.topicList.add(topic);
                }
                NotifierRequestQueue.getInstance().add((NotifierRequest)new SubscribeToNotificationRequest(this.topicList, (ISNotifier.BaseNotificationConsumer)consumer, RemoteDeltaListManager.this.sctx, RemoteDeltaListManager.this.sctx.getScope()));
            }
            catch (Exception e) {
                throw new IndexException(e.getMessage());
            }
        }

        public DestroyResponse destroy(Destroy arg0) throws RemoteException, ResourceNotDestroyedFaultType, org.oasis.wsrf.lifetime.ResourceUnknownFaultType {
            try {
                NotifierRequestQueue.getInstance().add((NotifierRequest)new UnsubscribeFromNotificationRequest(this.topicList, RemoteDeltaListManager.this.sctx, RemoteDeltaListManager.this.sctx.getScope()));
                return new DestroyResponse();
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage());
            }
        }

        public GetResourcePropertyResponse getResourceProperty(QName arg0) throws RemoteException, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType {
            return new GetResourcePropertyResponse();
        }

        public PauseSubscriptionResponse pauseSubscription(PauseSubscription arg0) throws RemoteException, PauseFailedFaultType, ResourceUnknownFaultType {
            try {
                if (this.topicList.size() != 0) {
                    NotifierRequestQueue.getInstance().add((NotifierRequest)new UnsubscribeFromNotificationRequest(this.topicList, RemoteDeltaListManager.this.sctx, RemoteDeltaListManager.this.sctx.getScope()));
                }
                return new PauseSubscriptionResponse();
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage());
            }
        }

        public ResumeSubscriptionResponse resumeSubscription(ResumeSubscription arg0) throws RemoteException, ResumeFailedFaultType, ResourceUnknownFaultType {
            try {
                NotifierRequestQueue.getInstance().add((NotifierRequest)new SubscribeToNotificationRequest(this.topicList, (ISNotifier.BaseNotificationConsumer)this.consumer, RemoteDeltaListManager.this.sctx, RemoteDeltaListManager.this.sctx.getScope()));
                return new ResumeSubscriptionResponse();
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage());
            }
        }

        public SetTerminationTimeResponse setTerminationTime(SetTerminationTime arg0) throws RemoteException, UnableToSetTerminationTimeFaultType, org.oasis.wsrf.lifetime.ResourceUnknownFaultType, TerminationTimeChangeRejectedFaultType {
            return new SetTerminationTimeResponse();
        }
    }
}

