package org.gcube.informationsystem.resourceregistry.api.exceptions.relations;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;

/**
 * The Class RelationAlreadyPresentException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class RelationAlreadyPresentException extends AlreadyPresentException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -4331648416224535719L;

	/**
	 * Instantiates a new relation already present exception.
	 *
	 * @param message the message
	 */
	public RelationAlreadyPresentException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new relation already present exception.
	 *
	 * @param cause the cause
	 */
	public RelationAlreadyPresentException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new relation already present exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public RelationAlreadyPresentException(String message, Throwable cause) {
		super(message, cause);
	}

}
