/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.ws.EndpointReference;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.ER;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.proxy.Direction;
import org.gcube.informationsystem.resourceregistry.client.proxy.JaxRSEndpointReference;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryQuery;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    private final AsyncProxyDelegate<EndpointReference> delegate;
    public static final String PATH_SEPARATOR = "/";

    public ResourceRegistryClientImpl(ProxyDelegate<EndpointReference> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    @Override
    public <ERType extends ER> ERType getInstance(Class<ERType> clazz, UUID uuid) throws ERNotFoundException, ResourceRegistryException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to get {} with UUID {}", (Object)type, (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, null);
            ResourceRegistryClientCall<ERType> call = new ResourceRegistryClientCall<ERType>(clazz, httpInputs);
            ER erType = (ER)this.delegate.make(call);
            logger.info("Got {} with UUID {} is {}", new Object[]{type, uuid, erType});
            return (ERType)erType;
        }
        catch (Exception e) {
            logger.error("Error while getting {} with UUID {}", new Object[]{type, uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public List<? extends Entity> getInstances(String type, Boolean polymorphic) throws ERNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            ArrayList<Map.Entry<String, String>> parameters = new ArrayList<Map.Entry<String, String>>();
            parameters.add(new RREntry<String, String>("polymorphic", polymorphic.toString()));
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, parameters);
            ResourceRegistryClientCall<String> call = new ResourceRegistryClientCall<String>(String.class, httpInputs);
            String ret = (String)this.delegate.make(call);
            logger.info("Got instances of {} are {}", (Object)type, (Object)ret);
            return ISMapper.unmarshalList(Entity.class, (String)ret);
        }
        catch (Exception e) {
            logger.error("Error while getting {} instances", (Object)type, (Object)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public List<Resource> getInstancesFromEntity(String relationType, Boolean polymorphic, UUID reference, Direction direction) throws ERException, SchemaException, ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} from/to {}", (Object)relationType, (Object)reference.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(relationType);
            ArrayList<Map.Entry<String, String>> parameters = new ArrayList<Map.Entry<String, String>>();
            parameters.add(new RREntry<String, String>("polymorphic", polymorphic.toString()));
            parameters.add(new RREntry<String, String>("reference", reference.toString()));
            parameters.add(new RREntry<String, String>("direction", direction.toString()));
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, parameters);
            ResourceRegistryClientCall<String> call = new ResourceRegistryClientCall<String>(String.class, httpInputs);
            String ret = (String)this.delegate.make(call);
            logger.info("Got instances of {} from/to {} are {}", new Object[]{relationType, reference.toString(), ret});
            return ISMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            logger.error("Error while getting instances of {} from/to {}", (Object)relationType, (Object)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> getSchema(Class<ISM> clazz, Boolean polymorphic) throws SchemaNotFoundException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to get {} schema", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("schema");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            ArrayList<Map.Entry<String, String>> parameters = new ArrayList<Map.Entry<String, String>>();
            parameters.add(new RREntry<String, String>("polymorphic", polymorphic.toString()));
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, parameters);
            ResourceRegistryClientCall<String> call = new ResourceRegistryClientCall<String>(String.class, httpInputs);
            String schema = (String)this.delegate.make(call);
            logger.info("Got schema for {} is {}", (Object)type, (Object)schema);
            return TypeBinder.deserializeTypeDefinitions((String)schema);
        }
        catch (Exception e) {
            logger.error("Error while getting {}schema for {}", new Object[]{polymorphic != false ? "polymorphic " : "", type, e});
            throw new SchemaNotFoundException((Throwable)e);
        }
    }

    @Override
    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException {
        ResourceRegistryQuery rrq = new ResourceRegistryQuery((ProxyDelegate<EndpointReference>)this.delegate);
        return rrq.query(query, limit, fetchPlan);
    }

    class ResourceRegistryClientCall<C>
    implements Call<EndpointReference, C> {
        protected final Class<C> clazz;
        protected final HTTPInputs httpInputs;

        public ResourceRegistryClientCall(Class<C> clazz, HTTPInputs httpInputs) {
            this.clazz = clazz;
            this.httpInputs = httpInputs;
        }

        protected String getURLStringFromEndpointReference(EndpointReference endpoint) throws IOException {
            JaxRSEndpointReference jaxRSEndpointReference = new JaxRSEndpointReference(endpoint);
            return jaxRSEndpointReference.toString();
        }

        protected HttpURLConnection getConnection(URL url, HTTPMETHOD method) throws Exception {
            url = new URL(url + "?" + this.httpInputs.getUrlParameters());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (SecurityTokenProvider.instance.get() == null) {
                if (ScopeProvider.instance.get() == null) {
                    throw new RuntimeException("Null Token and Scope. Please set your token first.");
                }
                connection.setRequestProperty("gcube-scope", ScopeProvider.instance.get());
            } else {
                connection.setRequestProperty("gcube-token", SecurityTokenProvider.instance.get());
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "application/json");
            connection.setRequestProperty("User-Agent", ResourceRegistryClient.class.getSimpleName());
            connection.setRequestMethod(method.toString());
            return connection;
        }

        public C call(EndpointReference endpoint) throws Exception {
            String urlFromEndpointReference = this.getURLStringFromEndpointReference(endpoint);
            StringBuilder callUrl = new StringBuilder(urlFromEndpointReference);
            callUrl.append(this.httpInputs.getPath());
            URL url = new URL(callUrl.toString());
            HttpURLConnection connection = this.getConnection(url, this.httpInputs.method);
            logger.debug("Response code for {} is {} : {}", new Object[]{connection.getURL(), connection.getResponseCode(), connection.getResponseMessage()});
            if (connection.getResponseCode() != 200) {
                throw new Exception("Error Contacting Resource Registry Service");
            }
            StringBuilder result = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
            String res = result.toString();
            logger.trace("Server returned content : {}", (Object)res);
            if (Boolean.class.isAssignableFrom(this.clazz)) {
                return (C)Boolean.valueOf(res);
            }
            if (ISManageable.class.isAssignableFrom(this.clazz)) {
                return (C)ISMapper.unmarshal(this.clazz, (String)res);
            }
            return (C)res;
        }
    }

    class HTTPInputs {
        public static final String PARAM_STARTER = "?";
        public static final String PARAM_EQUALS = "=";
        public static final String PARAM_SEPARATOR = "&";
        public static final String UTF8 = "UTF-8";
        protected final String path;
        protected final HTTPMETHOD method;
        protected final String urlParameters;

        protected String getParametersDataString(List<Map.Entry<String, String>> parameters) throws UnsupportedEncodingException {
            if (parameters == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    result.append(PARAM_SEPARATOR);
                }
                result.append(URLEncoder.encode(entry.getKey(), UTF8));
                result.append(PARAM_EQUALS);
                result.append(URLEncoder.encode(entry.getValue(), UTF8));
            }
            return result.toString();
        }

        public HTTPInputs(String path, HTTPMETHOD method, List<Map.Entry<String, String>> parameters) throws UnsupportedEncodingException {
            this.path = path;
            this.method = method;
            this.urlParameters = this.getParametersDataString(parameters);
        }

        public String getPath() {
            return this.path;
        }

        public HTTPMETHOD getMethod() {
            return this.method;
        }

        public String getUrlParameters() {
            return this.urlParameters;
        }
    }

    protected static enum HTTPMETHOD {
        GET,
        POST,
        PUT,
        DELETE;


        public String toString() {
            return this.name();
        }
    }

    public final class RREntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public RREntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

