/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import java.net.HttpURLConnection;
import java.util.List;
import java.util.UUID;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClient;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientImpl
implements ResourceRegistryContextClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientImpl.class);
    protected final String address;

    public ResourceRegistryContextClientImpl(String address) {
        this.address = address;
    }

    protected String internalCreate(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Header header = context.getHeader();
            if (header == null) {
                header = new HeaderImpl(UUID.randomUUID());
                context.setHeader(header);
            }
            UUID uuid = context.getHeader().getUUID();
            String contextString = ElementMapper.marshal((Element)context);
            logger.trace("Going to create {}", (Object)contextString);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(contextString);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context create(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            String res = this.internalCreate(context);
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            return this.internalCreate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context read(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.read(context.getHeader().getUUID());
    }

    @Override
    public Context read(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String res = this.read(uuid.toString());
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} is {}", (Object)"Context", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String internalUpdate(Context context) throws ResourceRegistryException {
        try {
            String contextString = ElementMapper.marshal((Element)context);
            logger.trace("Going to update {}", (Object)contextString);
            UUID uuid = context.getHeader().getUUID();
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(contextString);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context update(Context context) throws ResourceRegistryException {
        try {
            String res = this.internalUpdate(context);
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String context) throws ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            return this.internalUpdate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(context.getHeader().getUUID());
    }

    @Override
    public boolean delete(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(uuid.toString());
    }

    @Override
    public boolean delete(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with UUID {} {}", new Object[]{"Context", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> all() throws ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String all = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got contexts are {}", (Object)"Context", (Object)all);
            return ElementMapper.unmarshalList(Context.class, (String)all);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

