package org.gcube.informationsystem.resourceregistry.schema;

import org.gcube.informationsystem.resourceregistry.api.Constants;
import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceRegistrySchemaClientFactory {
	
	private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientFactory.class);

	/**
	 * Gets the Resource Registry service URL using the current context.
	 * 
	 * @return The complete URL for the Resource Registry service
	 */
	public static String getResourceRegistryURL() {
		String address = "%s/%s".formatted(ServiceInstance.getServiceURL(), Constants.SERVICE_NAME);
		return address;
	}
	
	/**
	 * Gets the Resource Registry service URL for a specific context.
	 * 
	 * @param context The context to use for determining the service URL
	 * @return The complete URL for the Resource Registry service in the specified context
	 */
	public static String getResourceRegistryURL(String context) {
		String address = "%s/%s".formatted(ServiceInstance.getServiceURL(context), Constants.SERVICE_NAME);
		return address;
	}
	
	/**
	 * Creates a new ResourceRegistrySchemaClient instance using the current context.
	 * 
	 * @return A new ResourceRegistrySchemaClient instance configured for the current context
	 */
	public static ResourceRegistrySchemaClient create() {
		String address = getResourceRegistryURL();
		logger.trace("The {} will be contacted at {}", Constants.SERVICE_NAME, address);
		return new ResourceRegistrySchemaClientImpl(address);
	}

	/**
	 * Creates a new ResourceRegistrySchemaClient instance for a specific context.
	 * 
	 * @param context The context to use for the ResourceRegistrySchemaClient instance
	 * @return A new ResourceRegistrySchemaClient instance configured for the specified context
	 */
	public static ResourceRegistrySchemaClient create(String context) {
		String address = getResourceRegistryURL(context);
		logger.trace("The {} will be contacted at {}", Constants.SERVICE_NAME, address);
		return new ResourceRegistrySchemaClientImpl(address);
	}
	
}
