/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.embedded.ValueSchema;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.dbinitialization.ReflectionUtility;
import org.gcube.informationsystem.resourceregistry.dbinitialization.Tree;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaInitializator {
    private static Logger logger = LoggerFactory.getLogger(SchemaInitializator.class);
    private static Set<Package> packages;
    private static final Comparator<Class<Entity>> entityComparator;
    private static final Comparator<Class<Relation>> relationComparator;
    private static final Comparator<Class<Embedded>> embeddedComparator;
    private static boolean DRY_RUN;

    protected static void addPackage(Package p) {
        packages.add(p);
    }

    protected static void analizeVertex(Map<Class<Entity>, Tree.Node<Class<Entity>>> visitedVertex, Class<Entity> clz) {
        Iterator i$;
        logger.trace(" --- Analizyng Entity {}", (Object)clz.getCanonicalName());
        if (visitedVertex.containsKey(clz)) {
            logger.trace(" --------- discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        ArrayList interfaceList = new ArrayList();
        for (Class<?> interfaceClass : interfaces) {
            if (!Entity.class.isAssignableFrom(interfaceClass)) {
                logger.trace(" --------- discarding {} because is not a {}", interfaceClass, (Object)Entity.class.getSimpleName());
                continue;
            }
            Class<?> v = interfaceClass;
            if (visitedVertex.containsKey(v)) {
                Tree.Node<Class<Entity>> root = visitedVertex.get(v);
                logger.trace(" --------- Adding {} to {}", clz, root);
                Tree.Node node = root.addChild(clz);
                visitedVertex.put(clz, (Tree.Node<Class<Entity>>)node);
                break;
            }
            interfaceList.add(interfaceClass);
        }
        if (!visitedVertex.containsKey(clz) && (i$ = interfaceList.iterator()).hasNext()) {
            Class interfaceClass = (Class)i$.next();
            SchemaInitializator.analizeVertex(visitedVertex, (Class)interfaceClass);
            Class v = interfaceClass;
            Tree.Node<Class<Entity>> root = visitedVertex.get(v);
            logger.trace(" --------- Adding {} to {}", clz, root);
            Tree.Node node = root.addChild(clz);
            visitedVertex.put(clz, (Tree.Node<Class<Entity>>)node);
        }
        logger.trace("{}", (Object[])interfaces);
    }

    protected static void analizeEmbedded(Map<Class<Embedded>, Tree.Node<Class<Embedded>>> visitedEmbedded, Class<Embedded> clz) {
        Iterator i$;
        logger.trace(" --- Analizyng Embedded {}", (Object)clz.getCanonicalName());
        if (visitedEmbedded.containsKey(clz)) {
            logger.trace(" --------- discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        ArrayList interfaceList = new ArrayList();
        for (Class<?> interfaceClass : interfaces) {
            if (!Embedded.class.isAssignableFrom(interfaceClass)) {
                logger.trace(" --------- discarding {} because is not a {}", interfaceClass, (Object)Embedded.class.getSimpleName());
                continue;
            }
            Class<?> v = interfaceClass;
            if (visitedEmbedded.containsKey(v)) {
                Tree.Node<Class<Embedded>> root = visitedEmbedded.get(v);
                logger.trace(" --------- Adding {} to {}", clz, root);
                Tree.Node node = root.addChild(clz);
                visitedEmbedded.put(clz, (Tree.Node<Class<Embedded>>)node);
                break;
            }
            interfaceList.add(interfaceClass);
        }
        if (!visitedEmbedded.containsKey(clz) && (i$ = interfaceList.iterator()).hasNext()) {
            Class interfaceClass = (Class)i$.next();
            SchemaInitializator.analizeEmbedded(visitedEmbedded, (Class)interfaceClass);
            Class v = interfaceClass;
            Tree.Node<Class<Embedded>> root = visitedEmbedded.get(v);
            logger.trace(" --------- Adding {} to {}", clz, root);
            Tree.Node node = root.addChild(clz);
            visitedEmbedded.put(clz, (Tree.Node<Class<Embedded>>)node);
        }
        logger.trace("{}", (Object[])interfaces);
    }

    protected static void analizeEdge(Map<Class<Relation>, Tree.Node<Class<Relation>>> visitedEdge, Class<Relation> clz) {
        Iterator i$;
        logger.trace(" --- Analizyng Relation {}", (Object)clz.getCanonicalName());
        if (visitedEdge.containsKey(clz)) {
            logger.trace(" --------- discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        ArrayList interfaceList = new ArrayList();
        for (Class<?> interfaceClass : interfaces) {
            if (!Relation.class.isAssignableFrom(interfaceClass)) {
                logger.trace(" --------- discarding {} because is not a {}", interfaceClass, (Object)Relation.class.getSimpleName());
                continue;
            }
            Class<?> v = interfaceClass;
            if (visitedEdge.containsKey(v)) {
                Tree.Node<Class<Relation>> root = visitedEdge.get(v);
                logger.trace(" --------- Adding {} to {}", clz, root);
                Tree.Node node = root.addChild(clz);
                visitedEdge.put(clz, (Tree.Node<Class<Relation>>)node);
                break;
            }
            interfaceList.add(interfaceClass);
        }
        if (!visitedEdge.containsKey(clz) && (i$ = interfaceList.iterator()).hasNext()) {
            Class interfaceClass = (Class)i$.next();
            SchemaInitializator.analizeEdge(visitedEdge, (Class)interfaceClass);
            Class v = interfaceClass;
            Tree.Node<Class<Relation>> root = visitedEdge.get(v);
            logger.trace(" --------- Adding {} to {}", clz, root);
            Tree.Node node = root.addChild(clz);
            visitedEdge.put(clz, (Tree.Node<Class<Relation>>)node);
        }
        logger.trace("{}", (Object[])interfaces);
    }

    protected static <T> Tree.NodeVisitor<Class<T>> printNodeVisitor(Class<T> t) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected static <T> void createEmbedded(Tree.Node<Class<T>> node) {
        Class clz = (Class)node.getValue();
        if (clz == Embedded.class) {
            logger.trace("Discarding {} because is just a convenient interface", (Object)clz);
            return;
        }
        if (ValueSchema.class.isAssignableFrom(clz)) {
            logger.trace("Discarding {} because was programmatically already created", (Object)clz);
            return;
        }
        try {
            String json = TypeBinder.serializeType((Class)clz);
            logger.trace(json);
            if (!DRY_RUN) {
                new SchemaManagementImpl().registerEmbeddedTypeSchema(json);
            }
        }
        catch (Exception e) {
            logger.error("error serializing schema", (Throwable)e);
        }
    }

    protected static <T> void createVertex(Tree.Node<Class<T>> node) {
        Class clz = (Class)node.getValue();
        try {
            String json = TypeBinder.serializeType((Class)clz);
            logger.trace(json);
            if (!DRY_RUN) {
                if (Facet.class.isAssignableFrom(clz)) {
                    new SchemaManagementImpl().registerFacetSchema(json);
                } else if (Resource.class.isAssignableFrom(clz)) {
                    new SchemaManagementImpl().registerResourceSchema(json);
                } else {
                    new SchemaManagementImpl().registerEntitySchema(json);
                }
            }
        }
        catch (Exception e) {
            logger.error("error serializing schema", (Throwable)e);
        }
    }

    protected static <T> void createEdge(Tree.Node<Class<T>> node) {
        Class clz = (Class)node.getValue();
        try {
            String json = TypeBinder.serializeType((Class)clz);
            logger.trace(json);
            if (!DRY_RUN) {
                if (ConsistsOf.class.isAssignableFrom(clz)) {
                    new SchemaManagementImpl().registerConsistOfSchema(json);
                } else if (IsRelatedTo.class.isAssignableFrom(clz)) {
                    new SchemaManagementImpl().registerRelatedToSchema(json);
                } else {
                    new SchemaManagementImpl().registerRelationSchema(json);
                }
            }
        }
        catch (Exception e) {
            logger.error("error serializing schema", (Throwable)e);
        }
    }

    protected static <T> Tree.NodeVisitor<Class<T>> getNodeVisitor(Class<T> t) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void createTypes() throws Exception {
        Tree embeddeds = new Tree(embeddedComparator);
        Tree vertexes = new Tree(entityComparator);
        Tree edges = new Tree(relationComparator);
        TreeMap<Class<Embedded>, Tree.Node> addedEmbedded = new TreeMap<Class<Embedded>, Tree.Node>(embeddedComparator);
        TreeMap<Class<Entity>, Tree.Node> addedVertex = new TreeMap<Class<Entity>, Tree.Node>(entityComparator);
        TreeMap<Class<Relation>, Tree.Node> addedEdge = new TreeMap<Class<Relation>, Tree.Node>(relationComparator);
        Tree.Node rootEmbedded = embeddeds.getRootElement();
        rootEmbedded.setValue(Embedded.class);
        addedEmbedded.put(Embedded.class, rootEmbedded);
        Tree.Node rootVertex = vertexes.getRootElement();
        rootVertex.setValue(Entity.class);
        addedVertex.put(Entity.class, rootVertex);
        Tree.Node rootEdge = edges.getRootElement();
        rootEdge.setValue(Relation.class);
        addedEdge.put(Relation.class, rootEdge);
        for (Package p : packages) {
            logger.trace("Analyzing {}", (Object)p);
            try {
                List classes = ReflectionUtility.getClassesForPackage((Package)p);
                for (Class clz : classes) {
                    if (!clz.isInterface()) {
                        logger.trace("Discarding {} that is not an interface", (Object)clz);
                        continue;
                    }
                    if (Embedded.class.isAssignableFrom(clz)) {
                        SchemaInitializator.analizeEmbedded(addedEmbedded, (Class)clz);
                    }
                    if (Entity.class.isAssignableFrom(clz)) {
                        SchemaInitializator.analizeVertex(addedVertex, (Class)clz);
                    }
                    if (!Relation.class.isAssignableFrom(clz)) continue;
                    SchemaInitializator.analizeEdge(addedEdge, (Class)clz);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Error discovering classes inside package {}", (Object)p.getName(), (Object)e);
                throw e;
            }
        }
        try {
            String json = TypeBinder.serializeType(ValueSchema.class);
            logger.trace(json);
            if (!DRY_RUN) {
                new SchemaManagementImpl().registerEmbeddedTypeSchema(json);
            }
        }
        catch (Exception e) {
            logger.error("error serializing schema", (Throwable)e);
        }
        SchemaInitializator.createEmbedded((Tree.Node)((Tree.Node)addedEmbedded.get(ValueSchema.class)));
        Tree.NodeVisitor embeddedNodeVisitor = SchemaInitializator.getNodeVisitor(Embedded.class);
        embeddeds.visitNodes(embeddedNodeVisitor);
        Tree.NodeVisitor vertexNodeVisitor = SchemaInitializator.getNodeVisitor(Entity.class);
        vertexes.visitNodes(vertexNodeVisitor);
        Tree.NodeVisitor edgeNodeVisitor = SchemaInitializator.getNodeVisitor(Relation.class);
        edges.visitNodes(edgeNodeVisitor);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static {
        DRY_RUN = false;
        packages = new HashSet();
        entityComparator = new /* Unavailable Anonymous Inner Class!! */;
        relationComparator = new /* Unavailable Anonymous Inner Class!! */;
        embeddedComparator = new /* Unavailable Anonymous Inner Class!! */;
    }
}

