/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.util.HashMap;
import java.util.Map;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseIntializator;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SecurityContextMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SecurityContextMapper {
    private static Logger logger = LoggerFactory.getLogger(SecurityContextMapper.class);
    public static final String MANAGEMENT_SECURITY_CONTEXT = "ManagementSecurityContext";
    private static final Map<PermissionMode, Map<String, OrientGraphFactory>> securityContextFactories;

    public static OrientGraphFactory getSecurityContextFactory(String contextID, PermissionMode permissionMode) {
        OrientGraphFactory factory = null;
        Map permissionSecurityContextFactories = (Map)securityContextFactories.get(permissionMode);
        factory = (OrientGraphFactory)permissionSecurityContextFactories.get(contextID);
        if (factory == null) {
            String username = SecurityContextMapper.getSecurityRoleOrUserName((PermissionMode)permissionMode, (SecurityType)SecurityType.USER, (String)contextID);
            String password = (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode);
            factory = new OrientGraphFactory(DatabaseEnvironment.URI_DB, username, password).setupPool(1, 10);
            permissionSecurityContextFactories.put(contextID, factory);
        }
        return factory;
    }

    public static String getSecurityRoleOrUserName(PermissionMode permissionMode, SecurityType securityType, String contextID) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(permissionMode);
        stringBuilder.append(securityType);
        stringBuilder.append("_");
        stringBuilder.append(contextID);
        return stringBuilder.toString();
    }

    static {
        try {
            boolean created = DatabaseIntializator.initGraphDB();
            logger.trace("Creating factory for {} connecting as {}", (Object)DatabaseEnvironment.URI_DB, (Object)DatabaseEnvironment.DEFAULT_ADMIN_USERNAME);
            securityContextFactories = new HashMap();
            OrientGraphFactory factory = new OrientGraphFactory(DatabaseEnvironment.URI_DB, DatabaseEnvironment.DEFAULT_ADMIN_USERNAME, DatabaseEnvironment.CHANGED_ADMIN_PASSWORD).setupPool(1, 10);
            for (PermissionMode p : PermissionMode.values()) {
                HashMap<Object, OrientGraphFactory> map = new HashMap<Object, OrientGraphFactory>();
                map.put(null, factory);
                securityContextFactories.put(p, map);
                map.put(null, factory);
            }
            if (created) {
                SecurityContext.createSecurityContext((OrientGraph)factory.getTx(), (String)"ManagementSecurityContext");
                SecurityContextMapper.getSecurityContextFactory((String)"ManagementSecurityContext", (PermissionMode)PermissionMode.READER);
                SecurityContextMapper.getSecurityContextFactory((String)"ManagementSecurityContext", (PermissionMode)PermissionMode.WRITER);
                DatabaseIntializator.createEntitiesAndRelations();
            }
        }
        catch (Exception e) {
            logger.error("Error initializing database connection", (Throwable)e);
            throw new RuntimeException("Error initializing database connection", e);
        }
    }
}

