/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.utils.ContextUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagementImpl
implements EntityManagement {
    private static Logger logger = LoggerFactory.getLogger(EntityManagementImpl.class);

    public Vertex getEntity(OrientGraph orientGraph, String uuid, String entityType, Class<? extends Entity> entityClass) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            if (entityType == null || entityType.compareTo("") == 0) {
                if (Facet.class.isAssignableFrom(entityClass)) {
                    entityType = Facet.NAME;
                }
                if (Resource.class.isAssignableFrom(entityClass)) {
                    entityType = Resource.NAME;
                }
            }
            return Utility.getEntityByUUID((OrientGraph)orientGraph, (String)entityType, (String)uuid);
        }
        catch (ResourceRegistryException e) {
            if (Facet.class.isAssignableFrom(entityClass)) {
                throw new FacetNotFoundException(e.getMessage());
            }
            if (Resource.class.isAssignableFrom(entityClass)) {
                throw new ResourceNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    public Edge getRelation(OrientGraph orientGraph, String uuid, String relationType, Class<? extends Relation> relationClass) throws ResourceRegistryException {
        try {
            if (relationType == null || relationType.compareTo("") == 0) {
                if (IsRelatedTo.class.isAssignableFrom(relationClass)) {
                    relationType = IsRelatedTo.NAME;
                }
                if (ConsistsOf.class.isAssignableFrom(relationClass)) {
                    relationType = ConsistsOf.NAME;
                }
            }
            return Utility.getRelationByUUID((OrientGraph)orientGraph, (String)relationType, (String)uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String createVertexEntity(String entityType, Class<? extends Entity> entity, String jsonRepresentation) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(entityType, entity.getSimpleName());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            OrientVertex entityVertex = orientGraph.addVertex((Object)("class:" + entityType));
            if (!Resource.class.isAssignableFrom(entity)) {
                Iterator iterator = jsonNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    JsonNode value = (JsonNode)entry.getValue();
                    entityVertex.setProperty((String)entry.getKey(), (Object)value.asText());
                }
            }
            HeaderUtility.addHeader((Vertex)entityVertex, null);
            ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)entityVertex);
            entityVertex.save();
            orientGraph.commit();
            String string = Utility.orientVertexToJsonString((OrientVertex)entityVertex);
            return string;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Creating " + entityType + " with " + jsonRepresentation, e.getCause());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String createEdgeRelation(String sourceUUID, Class<? extends Entity> sourceClass, String targetUUID, Class<? extends Entity> targetClass, String relationType, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String createFacet(String facetType, String jsonRepresentation) throws ResourceRegistryException {
        return this.createVertexEntity(facetType, Facet.class, jsonRepresentation);
    }

    public String readFacet(String uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.readFacet(uuid, Facet.NAME);
    }

    public String readFacet(String uuid, String facetType) throws FacetNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex facet = this.getEntity(orientGraph, uuid, facetType, Facet.class);
            String string = Utility.orientVertexToJsonString((OrientVertex)((OrientVertex)facet));
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception e) {
            throw new ResourceRegistryException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String updateFacet(String uuid, String jsonRepresentation) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex facet = this.getEntity(orientGraph, uuid, Facet.NAME, Facet.class);
            Set oldKeys = facet.getPropertyKeys();
            Iterator iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String key = (String)entry.getKey();
                if (key.startsWith("_")) {
                    oldKeys.remove(key);
                    continue;
                }
                if (key.compareTo("header") == 0) {
                    oldKeys.remove(key);
                    continue;
                }
                JsonNode value = (JsonNode)entry.getValue();
                facet.setProperty(key, (Object)value.asText());
                oldKeys.remove(key);
            }
            for (String key : oldKeys) {
                if (key.startsWith("_")) continue;
                facet.removeProperty(key);
            }
            ((OrientVertex)facet).save();
            orientGraph.commit();
            String string = Utility.orientVertexToJsonString((OrientVertex)((OrientVertex)facet));
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Updating Facet", e.getCause());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteFacet(String uuid) throws FacetNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex facet = this.getEntity(orientGraph, uuid, Facet.NAME, Facet.class);
            facet.remove();
            orientGraph.commit();
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachFacet(String resourceUUID, String facetUUID, String consistOfType, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        return this.createEdgeRelation(resourceUUID, Resource.class, facetUUID, Facet.class, consistOfType, jsonProperties);
    }

    public boolean detachFacet(String consistOfUUID) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, consistOfUUID, ConsistsOf.NAME, ConsistsOf.class);
            edge.remove();
            orientGraph.commit();
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachResource(String sourceResourceUuid, String targetResourceUuid, String relatedToType, String jsonProperties) throws ResourceNotFoundException, ResourceRegistryException {
        return this.createEdgeRelation(sourceResourceUuid, Resource.class, targetResourceUuid, Resource.class, relatedToType, jsonProperties);
    }

    public boolean detachResource(String relatedToUUID) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, relatedToUUID, IsRelatedTo.NAME, IsRelatedTo.class);
            edge.remove();
            orientGraph.commit();
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String createResource(String resourceType, String jsonRepresentation) throws ResourceRegistryException {
        return this.createVertexEntity(resourceType, Resource.class, jsonRepresentation);
    }

    public String readResource(String uuid) throws ResourceNotFoundException {
        return this.readResource(uuid, Resource.NAME);
    }

    public String readResource(String uuid, String resourceType) throws ResourceNotFoundException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex resource = this.getEntity(orientGraph, uuid, resourceType, Resource.class);
            String string = Utility.orientVertexToJsonString((OrientVertex)((OrientVertex)resource));
            return string;
        }
        catch (ResourceNotFoundException rnfe) {
            throw rnfe;
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteResource(String uuid) throws ResourceNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.getEntity(orientGraph, uuid, null, Resource.class);
            resource.remove();
            orientGraph.commit();
        }
        catch (ResourceNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }
}

