/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaManagementImpl
implements SchemaManagement {
    private static Logger logger = LoggerFactory.getLogger(SchemaManagementImpl.class);

    protected static OClass getEntityOClass(OrientGraphNoTx orientGraphNoTx, String entityType) throws SchemaException {
        OMetadataDefault oMetadata = orientGraphNoTx.getRawGraph().getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        return oSchema.getClass(entityType);
    }

    protected OClass getTypeSchema(String type, String baseType) throws SchemaNotFoundException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            logger.debug("Getting {} Type {} schema", (Object)(baseType != null ? baseType : ""), (Object)type);
            orientGraphNoTx = orientGraphFactory.getNoTx();
            OClass oClass = SchemaManagementImpl.getEntityOClass((OrientGraphNoTx)orientGraphNoTx, (String)type);
            if (baseType != null && !oClass.isSubClassOf(baseType)) {
                throw new SchemaException("The requested type is not a " + baseType);
            }
            return oClass;
        }
        catch (SchemaNotFoundException snfe) {
            throw snfe;
        }
        catch (Exception e) {
            throw new SchemaNotFoundException(e.getMessage());
        }
    }

    protected static String serializeOClass(OClass oClass) {
        ODocument oDocument = ((OClassImpl)oClass).toStream();
        String json = oDocument.toJSON();
        logger.trace("Requested type serialization is {}", (Object)json);
        return json;
    }

    protected List<OClass> getSuperclassesAndCheckCompliancy(OrientGraphNoTx orientGraphNoTx, TypeBinder.TypeDefinition typeDefinition, String baseType) throws SchemaException {
        Set superClasses = typeDefinition.getSuperclasses();
        if (baseType != null && (superClasses == null || superClasses.size() == 0)) {
            throw new RuntimeException(String.format("No Superclass found in schema %s. The Type Definition must extend %s", typeDefinition, baseType));
        }
        ArrayList<OClass> oSuperclasses = new ArrayList<OClass>();
        for (String superClass : superClasses) {
            OClass oSuperClass = SchemaManagementImpl.getEntityOClass((OrientGraphNoTx)orientGraphNoTx, (String)superClass);
            if (baseType != null && typeDefinition.getName().compareTo(baseType) != 0 && !oSuperClass.isSubClassOf(baseType)) {
                throw new RuntimeException(superClass + " is not a subsclass of " + baseType + ". Each Superclass MUST be a subclass of " + baseType);
            }
            oSuperclasses.add(oSuperClass);
        }
        return oSuperclasses;
    }

    protected String getTypeSchemaAsString(String type, String baseType) throws SchemaNotFoundException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            orientGraphNoTx = orientGraphFactory.getNoTx();
            OClass oClass = this.getTypeSchema(type, baseType);
            String string = SchemaManagementImpl.serializeOClass((OClass)oClass);
            return string;
        }
        catch (Exception e) {
            throw new SchemaNotFoundException((Throwable)e);
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    protected String registerVertexTypeSchema(String jsonSchema, Class<?> baseType) throws SchemaException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            logger.trace("Trying to register {} {}", baseType, (Object)jsonSchema);
            ObjectMapper mapper = new ObjectMapper();
            TypeBinder.TypeDefinition typeDefinition = (TypeBinder.TypeDefinition)mapper.readValue(jsonSchema, TypeBinder.TypeDefinition.class);
            orientGraphNoTx = orientGraphFactory.getNoTx();
            OrientVertexType ovt = orientGraphNoTx.createVertexType(typeDefinition.getName());
            ovt.setDescription(typeDefinition.getDescription());
            ovt.setAbstract(typeDefinition.isAbstractType());
            List oSuperclasses = this.getSuperclassesAndCheckCompliancy(orientGraphNoTx, typeDefinition, baseType.getSimpleName());
            ovt.setSuperClasses(oSuperclasses);
            if (Resource.class.isAssignableFrom(baseType)) {
                Set properties = typeDefinition.getProperties();
                if (properties != null && properties.size() > 0) {
                    throw new Exception("A Resource cannot contains any properties.");
                }
            } else {
                for (TypeBinder.Property property : typeDefinition.getProperties()) {
                    OrientVertexType.OrientVertexProperty ovp = ovt.createProperty(property.getName(), OType.getById((byte)property.getType().byteValue()));
                    ovp.setDescription(property.getDescription());
                    ovp.setMandatory(false);
                    ovp.setNotNull(false);
                    ovp.setReadonly(property.isReadonly());
                    ovp.setRegexp(property.getRegexpr());
                    if (property.getLinkedClass() != null) {
                        OClass linkedClass = SchemaManagementImpl.getEntityOClass((OrientGraphNoTx)orientGraphNoTx, (String)property.getLinkedClass());
                        if (linkedClass == null) {
                            logger.trace("class {} not found in schema", (Object)property.getLinkedClass());
                            throw new Exception("class " + property.getLinkedClass() + " not found in schema");
                        }
                        if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                            throw new Exception("An Embedded Field cannot be an Entity or a Relation");
                        }
                        ovp.setLinkedClass(linkedClass);
                        continue;
                    }
                    if (property.getLinkedType() == null) continue;
                    ovp.setLinkedType(OType.getById((byte)property.getLinkedType().byteValue()));
                }
            }
            orientGraphNoTx.commit();
            OClass oClass = this.getTypeSchema(typeDefinition.getName(), null);
            String string = SchemaManagementImpl.serializeOClass((OClass)oClass);
            return string;
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    protected String registerEdgeTypeSchema(String jsonSchema, String baseType) throws SchemaException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            logger.trace("Trying to register {} {}", (Object)baseType, (Object)jsonSchema);
            ObjectMapper mapper = new ObjectMapper();
            TypeBinder.TypeDefinition typeDefinition = (TypeBinder.TypeDefinition)mapper.readValue(jsonSchema, TypeBinder.TypeDefinition.class);
            orientGraphNoTx = orientGraphFactory.getNoTx();
            OrientEdgeType oet = orientGraphNoTx.createEdgeType(typeDefinition.getName());
            oet.setDescription(typeDefinition.getDescription());
            oet.setAbstract(typeDefinition.isAbstractType());
            List oSuperclasses = this.getSuperclassesAndCheckCompliancy(orientGraphNoTx, typeDefinition, baseType);
            oet.setSuperClasses(oSuperclasses);
            for (TypeBinder.Property property : typeDefinition.getProperties()) {
                OProperty op = oet.createProperty(property.getName(), OType.getById((byte)property.getType().byteValue()));
                op.setDescription(property.getDescription());
                op.setMandatory(false);
                op.setNotNull(false);
                op.setReadonly(property.isReadonly());
                op.setRegexp(property.getRegexpr());
                if (property.getLinkedClass() == null) continue;
                OClass linkedClass = SchemaManagementImpl.getEntityOClass((OrientGraphNoTx)orientGraphNoTx, (String)property.getLinkedClass());
                if (linkedClass == null) {
                    logger.trace("class {} not found in schema", (Object)property.getLinkedClass());
                    throw new Exception("class " + property.getLinkedClass() + " not found in schema");
                }
                if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                    throw new Exception("An Embedded Field cannot be an Entity or a Relation");
                }
                op.setLinkedClass(linkedClass);
            }
            orientGraphNoTx.commit();
            OClass oClass = this.getTypeSchema(typeDefinition.getName(), null);
            String string = SchemaManagementImpl.serializeOClass((OClass)oClass);
            return string;
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    public String registerDocumentSchema(String jsonSchema) throws SchemaException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            logger.trace("Trying to register {}", (Object)jsonSchema);
            ObjectMapper mapper = new ObjectMapper();
            TypeBinder.TypeDefinition typeDefinition = (TypeBinder.TypeDefinition)mapper.readValue(jsonSchema, TypeBinder.TypeDefinition.class);
            orientGraphNoTx = orientGraphFactory.getNoTx();
            ODatabaseDocumentTx oDatabaseDocumentTx = orientGraphNoTx.getRawGraph();
            OMetadataDefault oMetadata = oDatabaseDocumentTx.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass oClass = oSchema.createClass(typeDefinition.getName());
            oClass.setDescription(typeDefinition.getDescription());
            oClass.setAbstract(typeDefinition.isAbstractType());
            List oSuperclasses = this.getSuperclassesAndCheckCompliancy(orientGraphNoTx, typeDefinition, null);
            oClass.setSuperClasses(oSuperclasses);
            oDatabaseDocumentTx.commit();
            for (TypeBinder.Property property : typeDefinition.getProperties()) {
                OProperty ovp = oClass.createProperty(property.getName(), OType.getById((byte)property.getType().byteValue()));
                ovp.setDescription(property.getDescription());
                ovp.setMandatory(false);
                ovp.setNotNull(false);
                ovp.setReadonly(property.isReadonly());
                ovp.setRegexp(property.getRegexpr());
                if (property.getLinkedClass() == null) continue;
                OClass linkedClass = SchemaManagementImpl.getEntityOClass((OrientGraphNoTx)orientGraphNoTx, (String)property.getLinkedClass());
                if (linkedClass == null) {
                    logger.trace("class {} not found in schema", (Object)property.getLinkedClass());
                    throw new Exception("class " + property.getLinkedClass() + " not found in schema");
                }
                if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                    throw new Exception("An Embedded Field cannot be an Entity or a Relation");
                }
                ovp.setLinkedClass(linkedClass);
            }
            orientGraphNoTx.commit();
            String string = SchemaManagementImpl.serializeOClass((OClass)oClass);
            return string;
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    public String registerEntitySchema(String jsonSchema) throws SchemaException {
        return this.registerVertexTypeSchema(jsonSchema, Entity.class);
    }

    public String getEntitySchema(String entityType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(entityType, "Entity");
    }

    public String updateEntitySchema(String entityType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteEntitySchema(String entityType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerFacetSchema(String jsonSchema) throws SchemaException {
        return this.registerVertexTypeSchema(jsonSchema, Facet.class);
    }

    public String getFacetSchema(String facetType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(facetType, "Facet");
    }

    public String updateFacetSchema(String facetType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteFacetSchema(String facetType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerResourceSchema(String jsonSchema) throws SchemaException {
        return this.registerVertexTypeSchema(jsonSchema, Resource.class);
    }

    public String getResourceSchema(String resourceType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(resourceType, "Resource");
    }

    public String updateResourceSchema(String resourceType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteResourceSchema(String resourceType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerEmbeddedTypeSchema(String jsonSchema) throws SchemaException {
        return this.registerDocumentSchema(jsonSchema);
    }

    public String getEmbeddedTypeSchema(String embeddedType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(embeddedType, null);
    }

    public String updateEmbeddedTypeSchema(String embeddedType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteEmbeddedTypeSchema(String embeddedType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerRelationSchema(String jsonSchema) throws SchemaException {
        return this.registerEdgeTypeSchema(jsonSchema, "Relation");
    }

    public String getRelationSchema(String relationType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(relationType, "Relation");
    }

    public String updateRelationSchema(String relationType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteRelationSchema(String relationType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerConsistOfSchema(String jsonSchema) throws SchemaException {
        return this.registerEdgeTypeSchema(jsonSchema, "ConsistsOf");
    }

    public String getConsistOfSchema(String consistOfType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(consistOfType, "ConsistsOf");
    }

    public String updateConsistOfSchema(String consistOfType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteConsistOfSchema(String consistOfType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerRelatedToSchema(String jsonSchema) throws SchemaException {
        return this.registerEdgeTypeSchema(jsonSchema, "IsRelatedTo");
    }

    public String getRelatedToSchema(String relatedToType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(relatedToType, "IsRelatedTo");
    }

    public String updateRelatedToSchema(String relatedToType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteRelatedToSchema(String relatedToType) throws SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }
}

