/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.ContextManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InternalException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContext;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagementImpl
implements ContextManagement {
    private static Logger logger = LoggerFactory.getLogger(ContextManagementImpl.class);

    protected Vertex checkContext(OrientGraph orientGraph, UUID parentContext, String contextName) throws ContextNotFoundException, ContextException {
        Vertex parent = null;
        if (parentContext != null) {
            parent = this.getContext(orientGraph, parentContext);
            String select = "SELECT FROM (TRAVERSE out(IsParentOf) FROM " + parent.getId() + " MAXDEPTH 1) WHERE " + "name" + "=\"" + contextName + "\" AND " + "header" + "." + "uuid" + "<>\"" + parentContext.toString() + "\"";
            logger.trace(select);
            String message = "A context with the same name (" + contextName + ") has been already created as child of " + parentContext.toString() + "(name=" + parent.getProperty("name").toString() + ")";
            logger.trace("Checking if {} -> {}", (Object)message, (Object)select);
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
            Iterable vertexes = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            if (vertexes != null && vertexes.iterator().hasNext()) {
                throw new ContextException(message);
            }
        } else {
            String select = "SELECT FROM Context WHERE name = \"" + contextName + "\"" + " AND in(\"" + "IsParentOf" + "\").size() = 0";
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
            Iterable vertexes = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            if (vertexes != null && vertexes.iterator().hasNext()) {
                throw new ContextException("A root context with the same name (" + contextName + ") already exist");
            }
        }
        return parent;
    }

    public Vertex getContext(OrientGraph orientGraph, UUID context) throws ContextNotFoundException {
        try {
            return Utility.getEntityByUUID((OrientGraph)orientGraph, (String)"Context", (UUID)context);
        }
        catch (ResourceRegistryException e) {
            throw new ContextNotFoundException(e.getMessage());
        }
    }

    public String create(UUID parentContext, String name) throws ContextCreationException, InternalException {
        OrientGraph orientGraph = null;
        UUID uuid = UUID.randomUUID();
        try {
            Vertex parent;
            logger.info("Trying to create {} with name {} and parent {} UUID {}", new Object[]{"Context", name, "Context", parentContext});
            orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            try {
                parent = this.checkContext(orientGraph, parentContext, name);
            }
            catch (ContextException e) {
                throw new ContextCreationException(e.getMessage());
            }
            SecurityContext.createSecurityContext((OrientGraph)orientGraph, (UUID)uuid);
            OrientVertex context = orientGraph.addVertex((Object)"class:Context");
            context.setProperty("name", (Object)name);
            context.save();
            HeaderUtility.addHeader((Vertex)context, (UUID)uuid);
            if (parentContext != null) {
                OrientEdge edge = orientGraph.addEdge(null, parent, (Vertex)context, "IsParentOf");
                HeaderUtility.addHeader((Edge)edge, null);
                edge.save();
            }
            SecurityContext.addToSecurityContext((OrientGraph)orientGraph, (Vertex)context, (UUID)uuid);
            logger.trace("Creating {}", (Object)Utility.toJsonString((OrientElement)context, (boolean)true));
            orientGraph.commit();
            Vertex readContext = this.getContext(orientGraph, uuid);
            logger.info("Context created {}", (Object)Utility.toJsonString((OrientElement)((OrientVertex)readContext), (boolean)true));
            String string = Utility.toJsonString((OrientElement)((OrientVertex)readContext), (boolean)false);
            return string;
        }
        catch (ContextCreationException e) {
            throw e;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
                SecurityContext.deleteSecurityContext(orientGraph, (UUID)uuid, (boolean)true);
            }
            throw new InternalException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String read(UUID contextUUID) throws ContextNotFoundException, ContextException {
        OrientGraph orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER).getTx();
        Vertex context = this.getContext(orientGraph, contextUUID);
        return Utility.toJsonString((OrientElement)((OrientVertex)context), (boolean)false);
    }

    public String rename(UUID contextUUID, String newName) throws ContextNotFoundException, ContextException {
        OrientGraph orientGraph = null;
        try {
            logger.info("Trying to rename {} with UUID {} to {}", new Object[]{"Context", contextUUID, newName});
            orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            Vertex context = this.getContext(orientGraph, contextUUID);
            UUID parentUUID = null;
            Iterable edges = context.getEdges(Direction.IN, new String[]{"IsParentOf"});
            if (edges != null && edges.iterator().hasNext()) {
                Iterator iteratorEdge = edges.iterator();
                Edge edge = (Edge)iteratorEdge.next();
                if (iteratorEdge.hasNext()) {
                    throw new ContextException("");
                }
                Vertex parent = edge.getVertex(Direction.OUT);
                parentUUID = UUID.fromString((String)parent.getProperty("header.uuid"));
            }
            this.checkContext(orientGraph, parentUUID, newName);
            context.setProperty("name", (Object)newName);
            orientGraph.commit();
            String contextJsonString = Utility.toJsonString((Element)context, (boolean)true);
            logger.info("Context renamed {}", (Object)contextJsonString);
            String string = Utility.toJsonString((OrientElement)((OrientVertex)context), (boolean)false);
            return string;
        }
        catch (ContextException ce) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw ce;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ContextException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String move(UUID newParentUUID, UUID contextToMoveUUID) throws ContextNotFoundException, ContextException {
        OrientGraph orientGraph = null;
        try {
            Edge edge;
            logger.info("Trying to move {} with UUID {} as child of {} with UUID {}", new Object[]{"Context", contextToMoveUUID, "Context", newParentUUID});
            orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            Vertex context = this.getContext(orientGraph, contextToMoveUUID);
            logger.trace("Context to move {}", (Object)Utility.toJsonString((Element)context, (boolean)true));
            this.checkContext(orientGraph, newParentUUID, context.getProperty("name").toString());
            Iterable edges = context.getEdges(Direction.IN, new String[]{"IsParentOf"});
            if (edges != null && edges.iterator().hasNext()) {
                Iterator edgeIterator = edges.iterator();
                edge = (Edge)edgeIterator.next();
                logger.trace("Removing {} {}", (Object)Edge.class.getSimpleName(), (Object)edge);
                edge.remove();
            }
            if (newParentUUID != null) {
                Vertex parent = this.getContext(orientGraph, newParentUUID);
                logger.trace("New Parent Context {}", (Object)Utility.toJsonString((Element)parent, (boolean)true));
                edge = orientGraph.addEdge(null, parent, context, "IsParentOf");
                HeaderUtility.addHeader((Edge)edge, null);
                edge.save();
            }
            orientGraph.commit();
            context = this.getContext(orientGraph, contextToMoveUUID);
            String contextJsonString = Utility.toJsonString((Element)context, (boolean)true);
            logger.info("Context moved {}", (Object)contextJsonString);
            String string = Utility.toJsonString((OrientElement)((OrientVertex)context), (boolean)false);
            return string;
        }
        catch (ContextException ce) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw ce;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ContextException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean delete(UUID uuid) throws ContextNotFoundException, ContextException {
        OrientGraph orientGraph = null;
        try {
            logger.info("Trying to remove {} with UUID {}", (Object)"Context", (Object)uuid);
            orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            Vertex context = this.getContext(orientGraph, uuid);
            logger.trace("Context to be delete {}", (Object)Utility.toJsonString((Element)context, (boolean)true));
            Iterable edges = context.getEdges(Direction.OUT, new String[]{"IsParentOf"});
            if (edges != null && edges.iterator().hasNext()) {
                throw new ContextException("Only context with no children can be deleted");
            }
            SecurityContext.deleteSecurityContext((OrientGraph)orientGraph, (UUID)uuid, (boolean)false);
            context.remove();
            orientGraph.commit();
            logger.info("{} with UUID {} successfully removed", (Object)"Context", (Object)uuid);
            boolean bl = true;
            return bl;
        }
        catch (ContextException ce) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw ce;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ContextException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }
}

