/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextManagement;
import org.gcube.informationsystem.resourceregistry.context.ContextManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="context")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);
    public static final String ID_PATH_PARAM = "id";
    protected ContextManagement contextManager = new ContextManagementImpl();

    @PUT
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(@QueryParam(value="parentContextId") @DefaultValue(value="") String parentUUID, @QueryParam(value="name") String name) throws ContextCreationException, ResourceRegistryException {
        logger.info("Requested to create {} with name : {} ", (Object)"Context", (Object)name);
        UUID parent = null;
        if (parentUUID != null && parentUUID.compareTo("") != 0) {
            parent = UUID.fromString(parentUUID);
        }
        String ret = this.contextManager.create(parent, name);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public boolean delete(@PathParam(value="id") String uuid) throws ContextNotFoundException, ContextException {
        logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        return this.contextManager.delete(UUID.fromString(uuid));
    }

    @POST
    @Path(value="rename/{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String rename(@PathParam(value="id") String uuid, @QueryParam(value="name") String name) throws ContextNotFoundException, ContextException {
        logger.info("Requested to rename as {} {} with id {} ", new Object[]{name, "Context", uuid});
        return this.contextManager.rename(UUID.fromString(uuid), name);
    }

    @POST
    @Path(value="move/{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String move(@PathParam(value="id") String uuid, @QueryParam(value="parentContextId") String newParentUUID) throws ContextNotFoundException, ContextException {
        logger.info("Requested to move {} with id {} as child of {} having id {} ", new Object[]{"Context", uuid, "Context", newParentUUID});
        return this.contextManager.move(UUID.fromString(newParentUUID), UUID.fromString(uuid));
    }
}

