/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.AccessType;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

public abstract class EntityManagement<E extends Entity>
extends ERManagement<E, Vertex> {
    protected Map<String, RelationManagement> relationManagements;

    protected EntityManagement(AccessType accessType) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.relationManagements = new HashMap();
    }

    protected EntityManagement(AccessType accessType, SecurityContext workingContext, OrientGraph orientGraph) {
        this(accessType);
        this.orientGraph = orientGraph;
        this.setWorkingContext(workingContext);
    }

    protected RelationManagement getRelationManagement(Edge edge) throws ResourceRegistryException {
        String id = edge.getId().toString();
        RelationManagement relationManagement = (RelationManagement)this.relationManagements.get(id);
        if (relationManagement == null) {
            relationManagement = ERManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Edge)edge);
            this.relationManagements.put(id, relationManagement);
        }
        return relationManagement;
    }

    protected void addToRelationManagement(RelationManagement relationManagement) throws ResourceRegistryException {
        Element elem = relationManagement.getElement();
        String id = elem.getId().toString();
        if (this.relationManagements.get(id) != null && this.relationManagements.get(id) != relationManagement) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Two different instance of ");
            errorMessage.append(relationManagement.getClass().getSimpleName());
            errorMessage.append(" point to the same ");
            errorMessage.append(elem.getClass().getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(errorMessage.toString());
        }
        this.relationManagements.put(id, relationManagement);
    }

    protected static JSONObject addRelation(JSONObject sourceResource, JSONObject relation, String arrayKey) throws ResourceRegistryException {
        JSONArray relationArray = null;
        try {
            relationArray = sourceResource.has(arrayKey) ? sourceResource.getJSONArray(arrayKey) : new JSONArray();
            relationArray.put((Object)relation);
            sourceResource.putOpt(arrayKey, (Object)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    protected Vertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        this.logger.trace("Going to create {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.accessType.getName(), this.erType, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = String.format("Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.", this.accessType.getName(), this.erType);
                throw new ResourceRegistryException(error);
            }
            OrientVertex vertexEntity = this.orientGraph.addVertex((Object)("class:" + this.erType));
            try {
                Vertex v;
                if (this.uuid != null && (v = (Vertex)this.getElement()) != null) {
                    String error = String.format("A %s with UUID %s already exist", this.erType, this.uuid.toString());
                    throw this.getSpecificERAlreadyPresentException(error);
                }
            }
            catch (ERNotFoundException e) {
                try {
                    Element el = ERManagementUtility.getAnyElementByUUID((UUID)this.uuid);
                    String error = String.format("UUID %s is already used by another %s. This is not allowed.", this.uuid.toString(), el instanceof Vertex ? "Entity" : "Relation");
                    throw this.getSpecificERAvailableInAnotherContextException(error);
                }
                catch (ERNotFoundException eRNotFoundException) {
                }
            }
            catch (ERAvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            if (this.accessType != AccessType.RESOURCE) {
                ERManagement.updateProperties((OClass)this.oClass, (Element)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            }
            this.logger.info("Created {} is {}", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)((OrientVertex)this.element), (boolean)true));
            return (Vertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.accessType.getName(), this.erType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.erType + " with " + this.jsonNode, e.getCause());
        }
    }

    protected boolean reallyAddToContext() throws ContextException, ResourceRegistryException {
        this.getWorkingContext().addElement(this.getElement(), this.orientGraph);
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.internalAddToContext();
        }
        return true;
    }

    protected boolean reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.internalRemoveFromContext();
        }
        this.getWorkingContext().removeElement(this.getElement(), this.orientGraph);
        return true;
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        JSONArray jsonArray = new JSONArray();
        Iterable iterable = this.orientGraph.getVerticesOfClass(this.erType, polymorphic);
        for (Vertex vertex : iterable) {
            EntityManagement entityManagement = ERManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Vertex)vertex);
            try {
                JSONObject jsonObject = entityManagement.serializeAsJson();
                jsonArray.put((Object)jsonObject);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        return jsonArray.toString();
    }
}

