package org.gcube.informationsystem.resourceregistry.queries.json.base.relations;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class JsonQueryIsRelatedTo extends JsonQueryRelation {

	protected String requestedResourceType;
	
	public JsonQueryIsRelatedTo(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
		super(jsonQuery, AccessType.IS_RELATED_TO);
	}

	public String getRequestedResourceType() {
		return requestedResourceType;
	}

	public void setRequestedResourceType(String requestedResourceType) {
		this.requestedResourceType = requestedResourceType;
	}
	
	private StringBuffer traverseThisEdge(StringBuffer stringBuffer) throws InvalidQueryException {
		StringBuffer buffer = new StringBuffer();
		
		int size = jsonNode.size();
		if(size > 2) {
			buffer.append("SELECT FROM ");
			if(entryPoint) {
				buffer.append(type);
			}else {
				buffer.append(" ( "); // Open ( SELECT
			}
			
		}else {
			if(entryPoint) {
				buffer.append("SELECT FROM "); 
				buffer.append(type);
			}
		}
		
		if(!entryPoint) {
			buffer.append("TRAVERSE ");
			buffer.append(direction.opposite().name().toLowerCase());
			buffer.append("E(\"");
			buffer.append(type);
			buffer.append("\") FROM ( ");
			buffer.append(stringBuffer);
			buffer.append(")");
		}
		
		
		stringBuffer = buffer;
		
		// Size 2 means that only '@class' and 'target'/'source' properties are present
		if(size > 2) {
			if(!entryPoint) {
				stringBuffer.append(" )"); // Close ) SELECT
			}
			stringBuffer.append(" WHERE ");
			stringBuffer.append(addConstraints(jsonNode, null, null));
		}
		
		return stringBuffer;
	}
	
	@Override
	public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
		
		JsonNode sourceJsonNode = jsonNode.get(ConsistsOf.SOURCE_PROPERTY);
		JsonNode targetJsonNode = jsonNode.get(ConsistsOf.TARGET_PROPERTY);
		
		JsonNode resourceJsonNode = null;
		
		if(sourceJsonNode!=null) {
			resourceJsonNode = sourceJsonNode;
			direction = Direction.OUT;
		} else if(targetJsonNode!=null) {
			resourceJsonNode = targetJsonNode;
			direction = Direction.IN;
		}
		
		stringBuffer = traverseThisEdge(stringBuffer);
		
		JsonQueryResource jsonQueryResource = new JsonQueryResource(resourceJsonNode);
		jsonQueryResource.setDirection(direction);
		jsonQueryResource.setEntryPoint(false);
		stringBuffer = jsonQueryResource.analize(stringBuffer);
		
		StringBuffer buffer = new StringBuffer();
		buffer.append("TRAVERSE ");
		buffer.append(direction.opposite().name().toLowerCase());
		buffer.append("V(\"");
		buffer.append(requestedResourceType);
		buffer.append("\") FROM ( ");
		buffer.append("TRAVERSE ");
		buffer.append(direction.name().toLowerCase());		
		buffer.append("E(\"");
		buffer.append(type);
		buffer.append("\") FROM ( ");
		buffer.append(stringBuffer);
		buffer.append(")");
		buffer.append(")");
		stringBuffer = buffer;
		
		return stringBuffer;
		
	}

	
	
}
