package org.gcube.informationsystem.resourceregistry.rest;

import java.util.List;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

import org.gcube.informationsystem.resourceregistry.api.rest.InstancePath;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class BaseRest {
	
	protected Logger logger = LoggerFactory.getLogger(this.getClass());

	public BaseRest() {
		ContextUtility.getHierarchicalMode().set(false);
		ContextUtility.getIncludeInstanceContexts().set(false);
	}
	
	@Context
	protected UriInfo uriInfo;
	
	protected boolean isRequesterAllowedToPerformHierarchicalRequests() {
		// TODO check is the user has the role to query in hierarchic mode
		return true;
	}
	
	protected void checkHierarchicalMode() {
		try {
			List<String> hierarchicalQueryParameterList = uriInfo.getQueryParameters().get(InstancePath.HIERARCHICAL_MODE_QUERY_PARAMETER);
			if(hierarchicalQueryParameterList!=null && hierarchicalQueryParameterList.size()>0) {
				String hierarchicalBooleanString = hierarchicalQueryParameterList.get(0);
				boolean hierarchical = Boolean.valueOf(hierarchicalBooleanString);
				boolean h = hierarchical && isRequesterAllowedToPerformHierarchicalRequests();
				if(h) {
					logger.info("The request was performed in hierarchical mode and the requester is allowed. Going to set hierarchical mode.");
					ContextUtility.getHierarchicalMode().set(h);					
				}
			}
		}catch (Throwable t) {
			logger.warn("Unable to properly set the Hierarchical Mode is set", t.getMessage());
		}
	}
	
	protected boolean isRequesterAllowedToRequestInstancesContexts() {
		// TODO check is the user has the role to query in get instance Contexts
		return true;
	}
	
	protected void checkIncludeInstancesContexts() {
		try {
			List<String> includeContextsQueryParameterList = uriInfo.getQueryParameters().get(InstancePath.INCLUDE_CONTEXTS_IN_HEADER_QUERY_PARAMETER);
			if(includeContextsQueryParameterList!=null && includeContextsQueryParameterList.size()>0) {
				String includeContextsBooleanString = includeContextsQueryParameterList.get(0);
				boolean includeContexts = Boolean.valueOf(includeContextsBooleanString);
				boolean i = includeContexts && isRequesterAllowedToRequestInstancesContexts();
				if(i) {
					logger.info("The requet to include the contexts in header is allowed.");
					ContextUtility.getIncludeInstanceContexts().set(true);
				}
			}
		}catch (Throwable t) {
			logger.warn("Unable to properly set the Hierarchical Mode is set", t.getMessage());
		}
	}
	
}
